/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.SnapshotFormat;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenSnapshot {
    private static final String LAST_DIRECTORY_KEY = String.valueOf(OpenSnapshot.class.getName()) + ".lastDir";
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("(.*\\.)([a-zA-Z]*)\\.([0-9]*)");

    private static String askForRename(final String path, final String filename, final String extension) {
        final Pattern validFileName = Pattern.compile(".*\\.((?i)" + extension + ")");
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                if (!validFileName.matcher(newText).matches()) {
                    return MessageUtil.format((String)Messages.OpenSnapshot_FileMustHaveExtension, (Object[])new Object[]{extension});
                }
                File f = new File(path, newText);
                if (f.exists()) {
                    return MessageUtil.format((String)Messages.OpenSnapshot_FileAlreadyExists, (Object[])new Object[]{f.getAbsolutePath()});
                }
                return null;
            }
        };
        String msg = Messages.OpenSnapshot_Warning;
        InputDialog inputDialog = new InputDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.OpenSnapshot_RenameHeapDump, MessageUtil.format((String)msg, (Object[])new Object[]{extension}), String.valueOf(filename) + "." + extension, inputValidator){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Matcher matcher = TIMESTAMP_PATTERN.matcher(filename);
                if (matcher.matches()) {
                    this.getText().setSelection(matcher.start(2) - 1, matcher.end(3));
                }
            }
        };
        inputDialog.open();
        String newName = inputDialog.getValue();
        if (newName != null) {
            new File(String.valueOf(path) + File.separator + filename).renameTo(new File(String.valueOf(path) + File.separator + newName));
        }
        return newName;
    }

    public static abstract class Visitor {
        public abstract void visit(IFileStore var1);

        public boolean go(Shell shell) {
            String[] names;
            block10: {
                Preferences prefs = MemoryAnalyserPlugin.getDefault().getPluginPreferences();
                String lastDirectory = prefs.getString(LAST_DIRECTORY_KEY);
                FileDialog dialog = new FileDialog(shell, 4098);
                dialog.setText(Messages.OpenSnapshot_OpenSnapshot);
                this.applyFilter(dialog);
                if (lastDirectory != null && lastDirectory.length() > 0) {
                    dialog.setFilterPath(lastDirectory);
                } else {
                    dialog.setFilterPath(System.getProperty("user.home"));
                }
                dialog.open();
                names = dialog.getFileNames();
                if (names == null) break block10;
                String filterPath = dialog.getFilterPath();
                prefs.setValue(LAST_DIRECTORY_KEY, filterPath);
                int numberOfFilesNotFound = 0;
                StringBuffer notFound = new StringBuffer();
                int ii = 0;
                while (ii < names.length) {
                    block12: {
                        block11: {
                            Matcher matcher = TIMESTAMP_PATTERN.matcher(names[ii]);
                            if (!matcher.matches()) break block11;
                            names[ii] = OpenSnapshot.askForRename(filterPath, names[ii], matcher.group(2));
                            if (names[ii] == null) break block12;
                        }
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(filterPath));
                        if (!(fileStore = fileStore.getChild(names[ii])).fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
                            this.visit(fileStore);
                        } else {
                            if (++numberOfFilesNotFound > 1) {
                                notFound.append('\n');
                            }
                            notFound.append(fileStore.getName());
                        }
                    }
                    ++ii;
                }
                if (numberOfFilesNotFound > 0) {
                    String msgFmt = numberOfFilesNotFound == 1 ? Messages.OpenSnapshot_FileNotFound : Messages.OpenSnapshot_FilesNotFound;
                    String msg = MessageUtil.format((String)msgFmt, (Object[])new Object[]{notFound.toString()});
                    MessageDialog.openError((Shell)shell, (String)Messages.ErrorHelper_InternalError, (String)msg);
                }
            }
            return names == null || names.length != 0;
        }

        private void applyFilter(FileDialog dialog) {
            List types = SnapshotFactory.getSupportedFormats();
            Collections.sort(types, new Comparator<SnapshotFormat>(){

                @Override
                public int compare(SnapshotFormat f1, SnapshotFormat f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
            String[] filterExtensions = new String[types.size() + 1];
            String[] filterNames = new String[types.size() + 1];
            filterExtensions[0] = null;
            filterNames[0] = Messages.OpenSnapshot_AllKnownFormats;
            int ii = 0;
            while (ii < types.size()) {
                SnapshotFormat snapshotFormat = (SnapshotFormat)types.get(ii);
                StringBuilder e = new StringBuilder();
                String[] fileExtensions = snapshotFormat.getFileExtensions();
                int jj = 0;
                while (jj < fileExtensions.length) {
                    if (jj > 0) {
                        e.append(";");
                    }
                    e.append("*.").append(fileExtensions[jj]);
                    ++jj;
                }
                filterExtensions[ii + 1] = e.toString();
                filterNames[ii + 1] = snapshotFormat.getName();
                filterExtensions[0] = filterExtensions[0] == null ? filterExtensions[ii + 1] : String.valueOf(filterExtensions[0]) + ";" + filterExtensions[ii + 1];
                ++ii;
            }
            dialog.setFilterExtensions(filterExtensions);
            dialog.setFilterNames(filterNames);
        }
    }
}

