/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.panes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.snapshot.inspections.MultiplePath2GCRootsQuery;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.panes.QueryResultPane;
import org.eclipse.mat.ui.internal.viewer.RefinedResultViewer;
import org.eclipse.mat.ui.util.EasyToolBarDropDown;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class MultiplePath2GCRootsPane
extends QueryResultPane {
    private MultiplePath2GCRootsQuery.Grouping groupedBy;

    public void initWithArgument(Object argument) {
        QueryResult queryResult = (QueryResult)argument;
        MultiplePath2GCRootsQuery.Tree tree = (MultiplePath2GCRootsQuery.Tree)queryResult.getSubject();
        this.groupedBy = tree.getGroupedBy();
        super.initWithArgument(argument);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        this.addGroupingOptions(manager);
        super.contributeToToolBar(manager);
    }

    private void addGroupingOptions(IToolBarManager manager) {
        EasyToolBarDropDown groupingAction = new EasyToolBarDropDown(Messages.TableResultPane_GroupResultBy, MemoryAnalyserPlugin.getImageDescriptor("icons/grouping.gif"), this){

            public void contribute(PopupMenu menu) {
                MultiplePath2GCRootsQuery.Grouping[] groupingArray = MultiplePath2GCRootsQuery.Grouping.values();
                int n = groupingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MultiplePath2GCRootsQuery.Grouping group = groupingArray[n2];
                    GroupingAction action = new GroupingAction(group);
                    action.setText(group.toString());
                    action.setImageDescriptor(MemoryAnalyserPlugin.getDefault().getImageDescriptor(group.getIcon()));
                    if (MultiplePath2GCRootsPane.this.groupedBy == group) {
                        action.setEnabled(false);
                    }
                    menu.add(action);
                    ++n2;
                }
            }
        };
        manager.add((IAction)groupingAction);
    }

    class GroupingAction
    extends Action {
        private MultiplePath2GCRootsQuery.Grouping target;

        public GroupingAction(MultiplePath2GCRootsQuery.Grouping group) {
            this.target = group;
        }

        public void run() {
            if (MultiplePath2GCRootsPane.this.viewer.getResult().hasActiveFilter()) {
                StringBuilder buf = new StringBuilder();
                buf.append(Messages.DominatorPane_WholeTreeWillBeGrouped);
                MessageBox msg = new MessageBox(MultiplePath2GCRootsPane.this.viewer.getControl().getShell(), 288);
                msg.setText(Messages.DominatorPane_Info);
                msg.setMessage(buf.toString());
                if (msg.open() != 32) {
                    return;
                }
            }
            new Job(this.getText()){

                protected IStatus run(IProgressMonitor monitor) {
                    MultiplePath2GCRootsQuery.Tree original = (MultiplePath2GCRootsQuery.Tree)MultiplePath2GCRootsPane.this.viewer.getResult().unwrap();
                    final QueryResult queryResult = new QueryResult(null, "multiple_path -groupBy " + GroupingAction.this.target.name(), (IResult)original.groupBy(GroupingAction.this.target));
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MultiplePath2GCRootsPane.this.deactivateViewer();
                            MultiplePath2GCRootsPane.this.groupedBy = GroupingAction.this.target;
                            RefinedResultViewer v = MultiplePath2GCRootsPane.this.createViewer(queryResult);
                            MultiplePath2GCRootsPane.this.activateViewer(v);
                        }
                    });
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

