/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound;

import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.compound.AllocEntry;
import org.eclipse.birt.core.archive.compound.AllocTableLoader;
import org.eclipse.birt.core.archive.compound.ArchiveConstants;
import org.eclipse.birt.core.archive.compound.ArchiveFileV2;

class AllocTable
implements ArchiveConstants {
    protected ArchiveFileV2 af;
    final int BLOCK_SIZE;
    final int INDEX_PER_BLOCK;
    protected AllocEntry fatEntry;
    protected AllocEntry freeEntry;
    protected HashMap entries = new HashMap();

    AllocTable(ArchiveFileV2 af) {
        this.af = af;
        this.BLOCK_SIZE = af.BLOCK_SIZE;
        this.INDEX_PER_BLOCK = this.BLOCK_SIZE / 4;
        this.fatEntry = new AllocEntry(1);
        this.freeEntry = new AllocEntry(0);
        this.entries.put(new Integer(2), new AllocEntry(2));
    }

    static AllocTable createTable(ArchiveFileV2 af) throws IOException {
        AllocTable table = new AllocTable(af);
        return table;
    }

    static AllocTable loadTable(ArchiveFileV2 af) throws IOException {
        AllocTable table = new AllocTable(af);
        table.load();
        return table;
    }

    synchronized void load() throws IOException {
        AllocTableLoader loader = new AllocTableLoader();
        loader.load(this.af);
        ArrayList loadedEntries = loader.getEntryies();
        int i = 0;
        while (i < loadedEntries.size()) {
            AllocEntry entry = (AllocEntry)loadedEntries.get(i);
            int blockId = entry.getFirstBlock();
            if (blockId == 1) {
                this.fatEntry = entry;
            } else if (blockId == 0) {
                this.freeEntry = entry;
            } else {
                this.entries.put(new Integer(entry.getFirstBlock()), entry);
            }
            ++i;
        }
    }

    synchronized void flush() throws IOException {
        for (AllocEntry entry : this.entries.values()) {
            entry.flush(this);
        }
        this.fatEntry.flush(this);
        this.freeEntry.flush(this);
    }

    synchronized void refresh() throws IOException {
        this.fatEntry.refresh(this);
        for (AllocEntry entry : this.entries.values()) {
            entry.refresh(this);
        }
    }

    synchronized int getFreeBlock() throws IOException {
        if (this.freeEntry.getTotalBlocks() > 1) {
            int freeBlockId = this.freeEntry.removeLastBlock();
            return freeBlockId;
        }
        int freeBlockId = this.af.allocateBlock();
        if (freeBlockId % this.INDEX_PER_BLOCK == 0) {
            freeBlockId = this.af.allocateBlock();
        }
        return freeBlockId;
    }

    synchronized AllocEntry createEntry() throws IOException {
        int blockId = this.getFreeBlock();
        AllocEntry entry = new AllocEntry(blockId);
        this.entries.put(new Integer(blockId), entry);
        return entry;
    }

    synchronized AllocEntry loadEntry(int blockId) throws IOException {
        AllocEntry entry = (AllocEntry)this.entries.get(new Integer(blockId));
        if (entry == null) {
            entry = new AllocEntry(blockId);
            entry.refresh(this);
            this.entries.put(new Integer(blockId), entry);
        }
        return entry;
    }

    synchronized void removeEntry(AllocEntry entry) throws IOException {
        int totalBlocks = entry.getTotalBlocks();
        int i = 0;
        while (i < totalBlocks) {
            int freeBlock = entry.getBlock(i);
            this.freeEntry.appendBlock(freeBlock);
            ++i;
        }
        this.entries.remove(new Integer(entry.getFirstBlock()));
    }

    int readFATInt(long offset) throws IOException {
        int totalBlocks = this.fatEntry.getTotalBlocks();
        if (offset > (long)totalBlocks * (long)this.BLOCK_SIZE) {
            throw new EOFException();
        }
        int blockId = (int)(offset / (long)this.BLOCK_SIZE);
        int off = (int)(offset % (long)this.BLOCK_SIZE);
        int phyBlockId = this.fatEntry.getBlock(blockId);
        byte[] b = new byte[4];
        this.af.read(phyBlockId, off, b, 0, 4);
        return ArchiveUtil.bytesToInteger(b);
    }

    void writeFATInt(long offset, int block) throws IOException {
        int totalBlocks = this.fatEntry.getTotalBlocks();
        int blockId = (int)(offset / (long)this.BLOCK_SIZE);
        int off = (int)(offset % (long)this.BLOCK_SIZE);
        if (blockId >= totalBlocks) {
            int newTotalBlocks = blockId + 1;
            int i = totalBlocks;
            while (i < newTotalBlocks) {
                this.fatEntry.appendBlock(this.INDEX_PER_BLOCK * i);
                ++i;
            }
        }
        int phyBlockId = this.fatEntry.getBlock(blockId);
        byte[] b = new byte[4];
        ArchiveUtil.integerToBytes(block, b);
        this.af.write(phyBlockId, off, b, 0, 4);
    }

    void debug_dump() {
        System.out.println("ALLOC:");
        int i = 0;
        while (i < this.fatEntry.getTotalBlocks()) {
            System.out.print(String.valueOf(this.fatEntry.getBlock(i)) + ",");
            ++i;
        }
        System.out.println();
        System.out.println("FREE:");
        i = 0;
        while (i < this.freeEntry.getTotalBlocks()) {
            System.out.print(String.valueOf(this.freeEntry.getBlock(i)) + ",");
            ++i;
        }
        System.out.println();
        for (AllocEntry entry : this.entries.values()) {
            int i2 = 0;
            while (i2 < entry.getTotalBlocks()) {
                System.out.print(String.valueOf(entry.getBlock(i2)) + ",");
                ++i2;
            }
            System.out.println();
        }
    }
}

