/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplePathsFromGCRootsClassRecord {
    private List<int[]> paths = new ArrayList<int[]>();
    private SetInt distinctObjects;
    private int level;
    private IClass clazz;
    private long referencedSize = -1L;
    private ISnapshot snapshot;
    private boolean fromRoots;

    public MultiplePathsFromGCRootsClassRecord(IClass clazz, int level, boolean fromRoots, ISnapshot snapshot) {
        this.clazz = clazz;
        this.level = level;
        this.fromRoots = fromRoots;
        this.snapshot = snapshot;
    }

    public MultiplePathsFromGCRootsClassRecord[] nextLevel() throws SnapshotException {
        int nextLevel = this.level + 1;
        if (nextLevel < 0) {
            return null;
        }
        HashMapIntObject nextLevelRecords = new HashMapIntObject();
        for (int[] path : this.paths) {
            int newIndex;
            if (path == null) continue;
            int n = newIndex = this.fromRoots ? path.length - nextLevel - 1 : nextLevel;
            if (newIndex < 0 || newIndex >= path.length) continue;
            IClass clazz = this.snapshot.getClassOf(path[newIndex]);
            MultiplePathsFromGCRootsClassRecord record = (MultiplePathsFromGCRootsClassRecord)nextLevelRecords.get(clazz.getObjectId());
            if (record == null) {
                record = new MultiplePathsFromGCRootsClassRecord(clazz, nextLevel, this.fromRoots, this.snapshot);
                nextLevelRecords.put(clazz.getObjectId(), (Object)record);
            }
            record.addPath(path);
        }
        return (MultiplePathsFromGCRootsClassRecord[])nextLevelRecords.getAllValues((Object[])new MultiplePathsFromGCRootsClassRecord[0]);
    }

    public void addPath(int[] path) {
        this.paths.add(path);
    }

    public List<int[]> getPaths() {
        return this.paths;
    }

    public int getCount() {
        return this.paths.size();
    }

    public int getDistinctCount() {
        if (this.distinctObjects == null) {
            this.distinctObjects = new SetInt();
            for (int[] path : this.paths) {
                int index = this.fromRoots ? path.length - this.level - 1 : this.level;
                this.distinctObjects.add(path[index]);
            }
        }
        return this.distinctObjects.size();
    }

    public long getReferencedHeapSize() throws SnapshotException {
        if (this.referencedSize == -1L) {
            this.referencedSize = this.snapshot.getHeapSize(this.getReferencedObjects());
        }
        return this.referencedSize;
    }

    public int[] getReferencedObjects() {
        int[] result = new int[this.paths.size()];
        int i = 0;
        for (int[] path : this.paths) {
            result[i++] = path[0];
        }
        return result;
    }

    public static Comparator<MultiplePathsFromGCRootsClassRecord> getComparatorByNumberOfReferencedObjects() {
        return new Comparator<MultiplePathsFromGCRootsClassRecord>(){

            @Override
            public int compare(MultiplePathsFromGCRootsClassRecord o1, MultiplePathsFromGCRootsClassRecord o2) {
                if (o1.paths.size() < o2.paths.size()) {
                    return 1;
                }
                if (o1.paths.size() > o2.paths.size()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public static Comparator<MultiplePathsFromGCRootsClassRecord> getComparatorByReferencedHeapSize() {
        return new Comparator<MultiplePathsFromGCRootsClassRecord>(){

            @Override
            public int compare(MultiplePathsFromGCRootsClassRecord o1, MultiplePathsFromGCRootsClassRecord o2) {
                block4: {
                    try {
                        if (o1.getReferencedHeapSize() >= o2.getReferencedHeapSize()) break block4;
                        return 1;
                    }
                    catch (SnapshotException snapshotException) {
                        return 0;
                    }
                }
                if (o1.getReferencedHeapSize() > o2.getReferencedHeapSize()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public IClass getClazz() {
        return this.clazz;
    }

    public boolean isFromRoots() {
        return this.fromRoots;
    }

    public int getLevel() {
        return this.level;
    }
}

