/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.query;

import java.net.URL;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.DetailResultProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

public final class TQuantize {
    private ISnapshot snapshot;
    private IResultTable table;
    private int keyLength;
    private ArrayInt columnIndeces;
    private List<Column> columns;
    private List<Quantize.Function.Factory> functions;
    private Calculator calculator;

    public static Builder valueDistribution(ISnapshot snapshot, IResultTable base, int ... columns) throws SnapshotException {
        if (columns == null || columns.length == 0) {
            throw new NullPointerException("columns");
        }
        if (columns.length > 1) {
            Format formatter = base.getColumns()[columns[0]].getFormatter();
            Builder builder = new Builder(snapshot, base, new ByMultipleColumns(columns, formatter));
            Column[] columns2 = base.getColumns();
            int[] nArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                int column = nArray[n2];
                builder.column(columns2[column], column);
                ++n2;
            }
            return builder;
        }
        Format formatter = base.getColumns()[columns[0]].getFormatter();
        Builder builder = new Builder(snapshot, base, new BySingleColumn(columns[0], formatter));
        builder.column(base.getColumns()[columns[0]], columns[0]);
        return builder;
    }

    public static Builder valueDistribution(ISnapshot snapshot, IResultTable base, Target target) throws SnapshotException {
        try {
            Builder builder = new Builder(snapshot, base, target.getCalculatorClass().newInstance());
            builder.column(base.getColumns()[0], 0);
            return builder;
        }
        catch (Exception e) {
            throw SnapshotException.rethrow((Throwable)e);
        }
    }

    public static TQuantize defaultValueDistribution(ISnapshot snapshot, IResultTable base, Target target) throws SnapshotException {
        try {
            Builder builder = new Builder(snapshot, base, target.getCalculatorClass().newInstance());
            Column[] columns = base.getColumns();
            ResultMetaData data = base.getResultMetaData();
            if (data != null) {
                int columnIndex = data.getPreSortedColumnIndex();
                columns[columnIndex].sorting(data.getPreSortedDirection());
            }
            builder.column(columns[0], 0);
            int ii = 1;
            while (ii < columns.length) {
                Quantize.Function.Factory ff = null;
                if (columns[ii].getCalculateTotals()) {
                    Class type = columns[ii].getType();
                    if (Long.class.isAssignableFrom(type)) {
                        ff = Quantize.SUM_LONG;
                    } else if (Long.TYPE.isAssignableFrom(type)) {
                        ff = Quantize.SUM_LONG;
                    } else if (Double.class.isAssignableFrom(type)) {
                        ff = Quantize.SUM;
                    } else if (Double.TYPE.isAssignableFrom(type)) {
                        ff = Quantize.SUM;
                    } else if (Integer.class.isAssignableFrom(type)) {
                        ff = Quantize.SUM_LONG;
                    } else if (Integer.TYPE.isAssignableFrom(type)) {
                        ff = Quantize.SUM_LONG;
                    } else if (Float.class.isAssignableFrom(type)) {
                        ff = Quantize.SUM;
                    } else if (Float.TYPE.isAssignableFrom(type)) {
                        ff = Quantize.SUM;
                    }
                }
                builder.column(columns[ii].getLabel(), columns[ii], ii, ff);
                ++ii;
            }
            return builder.build();
        }
        catch (Exception e) {
            throw SnapshotException.rethrow((Throwable)e);
        }
    }

    TQuantize(ISnapshot snapshot, IResultTable table, Calculator calculator) throws SnapshotException {
        try {
            this.snapshot = snapshot;
            this.table = table;
            this.calculator = calculator;
            this.calculator.init(this);
            this.columnIndeces = new ArrayInt();
            this.columns = new ArrayList<Column>();
            this.functions = new ArrayList<Quantize.Function.Factory>();
        }
        catch (Exception e) {
            throw SnapshotException.rethrow((Throwable)e);
        }
    }

    protected void init() {
    }

    public IResult process(IProgressListener listener) throws SnapshotException {
        try {
            HashMap<Object, GroupedRowImpl> result = new HashMap<Object, GroupedRowImpl>();
            int numColumns = this.table.getColumns().length;
            int rowIndex = 0;
            while (rowIndex < this.table.getRowCount()) {
                Object tableRow = this.table.getRow(rowIndex);
                Object key = this.calculator.key(tableRow);
                GroupedRowImpl groupedRow = (GroupedRowImpl)result.get(key);
                if (groupedRow == null) {
                    groupedRow = new GroupedRowImpl(key, this.calculator.label(key));
                    groupedRow.functions = this.createFunctions();
                    result.put(key, groupedRow);
                }
                groupedRow.addRowIndex(rowIndex);
                Object[] temp = new Object[numColumns];
                int i = 0;
                while (i < groupedRow.functions.length) {
                    if (groupedRow.functions[i] != null) {
                        int idx = this.columnIndeces.get(i + this.keyLength);
                        if (temp[idx] == null) {
                            temp[idx] = this.table.getColumnValue(tableRow, idx);
                        }
                        groupedRow.functions[i].add(temp[idx]);
                    }
                    ++i;
                }
                ++rowIndex;
            }
            return this.calculator.result(result);
        }
        catch (Exception e) {
            throw SnapshotException.rethrow((Throwable)e);
        }
    }

    protected Quantize.Function[] createFunctions() {
        try {
            Quantize.Function[] answer = new Quantize.Function[this.functions.size()];
            int ii = 0;
            for (Quantize.Function.Factory factory : this.functions) {
                if (factory != null) {
                    answer[ii] = factory.build();
                }
                ++ii;
            }
            return answer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ResultMetaData wrap(IResultTable table) {
        ResultMetaData data = table.getResultMetaData();
        if (data == null) {
            return null;
        }
        ResultMetaData.Builder answer = new ResultMetaData.Builder();
        for (final ContextProvider provider : data.getContextProviders()) {
            answer.addContext(new ContextProvider(provider){

                public IContextObject getContext(Object row) {
                    if (row instanceof GroupedRow) {
                        MergedObjectContext merged = new MergedObjectContext();
                        for (Object subject : ((GroupedRow)row).getSubjects()) {
                            IContextObject obj = provider.getContext(subject);
                            merged.add(obj);
                        }
                        return merged.getContext();
                    }
                    return provider.getContext(row);
                }
            });
        }
        for (final DetailResultProvider details : data.getDetailResultProviders()) {
            answer.addDetailResult(new DetailResultProvider(details.getLabel()){

                public boolean hasResult(Object row) {
                    return !(row instanceof GroupedRow) && details.hasResult(row);
                }

                public IResult getResult(Object row, IProgressListener listener) throws SnapshotException {
                    if (row instanceof GroupedRow) {
                        return null;
                    }
                    return details.getResult(row, listener);
                }
            });
        }
        Collection derivedOperations = data.getDerivedOperations();
        if (derivedOperations != null) {
            for (ContextDerivedData.DerivedOperation operation : derivedOperations) {
                answer.addDerivedData(operation);
            }
        }
        return answer.build();
    }

    public static final class Builder {
        TQuantize quantize;

        private Builder(ISnapshot snapshot, IResultTable base, Calculator calculator) throws SnapshotException {
            this.quantize = new TQuantize(snapshot, base, calculator);
        }

        Builder column(Column col, int baseColumnIndex) {
            this.quantize.columns.add(this.wrap(col));
            this.quantize.columnIndeces.add(baseColumnIndex);
            TQuantize tQuantize = this.quantize;
            tQuantize.keyLength = tQuantize.keyLength + 1;
            return this;
        }

        private Column wrap(Column col) {
            IDecorator dec;
            Class<String> type;
            Format fmt;
            Comparator cmp = col.getComparator();
            if (cmp != null) {
                cmp = new WrappedComparator(cmp);
            }
            if ((fmt = col.getFormatter()) != null) {
                fmt = new WrappedFormat(fmt);
            }
            if ((type = col.getType()) == null) {
                type = String.class;
            }
            if ((dec = col.getDecorator()) != null) {
                dec = new WrappedDecorator(dec);
            }
            return new Column(col.getLabel(), type, col.getAlign(), col.getSortDirection(), fmt, cmp).decorator(dec);
        }

        public Builder column(String label, Column baseColumn, int baseColumnIndex, Quantize.Function.Factory qff) {
            Column col = new Column(label, baseColumn.getType(), baseColumn.getAlign(), baseColumn.getSortDirection(), baseColumn.getFormatter(), baseColumn.getComparator()).decorator(baseColumn.getDecorator());
            this.quantize.columns.add(col);
            this.quantize.columnIndeces.add(baseColumnIndex);
            this.quantize.functions.add(qff);
            return this;
        }

        public TQuantize build() {
            TQuantize answer = this.quantize;
            this.quantize = null;
            answer.init();
            return answer;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class WrappedComparator
        implements Comparator<Object> {
            Comparator<Object> original;

            private WrappedComparator(Comparator<?> cmp) {
                this.original = cmp;
            }

            @Override
            public int compare(Object o1, Object o2) {
                boolean is1Row = o1 instanceof GroupedRow;
                boolean is2Row = o2 instanceof GroupedRow;
                if (is1Row ^ is2Row) {
                    return is1Row ? -1 : 1;
                }
                if (is1Row) {
                    return ((GroupedRow)o1).compareTo((GroupedRow)o2);
                }
                return this.original.compare(o1, o2);
            }
        }

        private static final class WrappedDecorator
        implements IDecorator {
            private IDecorator delegate;

            public WrappedDecorator(IDecorator delegate) {
                this.delegate = delegate;
            }

            public String prefix(Object row) {
                return row instanceof GroupedRow ? null : this.delegate.prefix(row);
            }

            public String suffix(Object row) {
                return row instanceof GroupedRow ? null : this.delegate.suffix(row);
            }
        }

        private static final class WrappedFormat
        extends Format {
            private static final long serialVersionUID = 1L;
            Format original;

            private WrappedFormat(Format original) {
                this.original = original;
            }

            public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
                if (obj instanceof GroupedRow || obj instanceof String) {
                    toAppendTo.append(obj);
                } else {
                    this.original.format(obj, toAppendTo, pos);
                }
                return toAppendTo;
            }

            public Object parseObject(String source, ParsePosition pos) {
                return null;
            }

            public Object clone() {
                return new WrappedFormat((Format)this.original.clone());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByClassloader
    extends Calculator {
        ByClassloader() {
        }

        @Override
        public IResult result(Map<Object, GroupedRowImpl> result) {
            return new OneColumnFlatResult(this.quantize.table, this.quantize.columns, new ArrayList<GroupedRowImpl>(result.values()), Icons.CLASSLOADER_INSTANCE);
        }

        @Override
        public String label(Object key) throws SnapshotException {
            if (key == null) {
                return Messages.TQuantize_None;
            }
            int objectId = (Integer)key;
            if (objectId < 0) {
                return Messages.TQuantize_None;
            }
            IObject object = this.quantize.snapshot.getObject(objectId);
            String label = object.getClassSpecificName();
            return label != null ? label : object.getTechnicalName();
        }

        @Override
        public Object key(Object row) throws SnapshotException {
            IContextObject ctx = this.quantize.table.getContext(row);
            if (ctx == null) {
                return null;
            }
            int objectId = ctx.getObjectId();
            if (objectId < 0) {
                return -1;
            }
            IObject obj = this.quantize.snapshot.getObject(objectId);
            return obj instanceof IClass ? ((IClass)obj).getClassLoaderId() : obj.getClazz().getClassLoaderId();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByMultipleColumns
    extends Calculator {
        private int[] columnIndeces;
        private Format formatter;

        public ByMultipleColumns(int[] columnIndex, Format formatter) {
            this.formatter = formatter;
            this.columnIndeces = columnIndex;
        }

        @Override
        public Object key(Object row) throws SnapshotException {
            Object[] keys = new Object[this.columnIndeces.length];
            int ii = 0;
            while (ii < this.columnIndeces.length) {
                keys[ii] = this.quantize.table.getColumnValue(row, this.columnIndeces[ii]);
                ++ii;
            }
            return new CompositeKey(keys);
        }

        @Override
        public String label(Object key) throws SnapshotException {
            Object label = ((CompositeKey)key).keys[0];
            return this.formatter != null ? this.formatter.format(label) : String.valueOf(label);
        }

        @Override
        public IResult result(Map<Object, GroupedRowImpl> map) {
            return new MultipleColumnsFlatResult(this.quantize.table, this.quantize.columns, new ArrayList<GroupedRowImpl>(map.values()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByPackage
    extends Calculator {
        Package root = new Package("<ROOT>", null);

        ByPackage() {
        }

        @Override
        public IResult result(Map<Object, GroupedRowImpl> result) {
            for (Map.Entry<Object, GroupedRowImpl> entry : result.entrySet()) {
                GroupedRowImpl row = entry.getValue();
                Package p = (Package)entry.getKey();
                while (p != null) {
                    if (p.functions == null) {
                        p.functions = this.quantize.createFunctions();
                    }
                    int ii = 0;
                    while (ii < p.functions.length) {
                        if (p.functions[ii] != null) {
                            p.functions[ii].add(row.functions[ii].getValue());
                        }
                        ++ii;
                    }
                    p = p.parent;
                }
            }
            return new ByPackageResult(this.root, this.quantize.table, this.quantize.columns, result);
        }

        @Override
        public String label(Object key) throws SnapshotException {
            return ((Package)key).name;
        }

        @Override
        public Object key(Object row) throws SnapshotException {
            String className;
            int p;
            IObject obj;
            IContextObject ctx = this.quantize.table.getContext(row);
            if (ctx == null) {
                return this.root.getOrCreateChild(Messages.TQuantize_None);
            }
            int objectId = ctx.getObjectId();
            if (objectId < 0) {
                return this.root.getOrCreateChild(Messages.TQuantize_None);
            }
            IClass objClass = this.quantize.snapshot.getClassOf(objectId);
            if ("java.lang.Class".equals(objClass.getName()) && (obj = this.quantize.snapshot.getObject(objectId)) instanceof IClass) {
                objClass = (IClass)obj;
            }
            if ((p = (className = objClass.getName()).lastIndexOf(46)) < 0) {
                return this.root;
            }
            StringTokenizer tokenizer = new StringTokenizer(className.substring(0, p), ".");
            Package current = this.root;
            while (tokenizer.hasMoreTokens()) {
                Package childNode;
                String subpack = tokenizer.nextToken();
                current = childNode = current.getOrCreateChild(subpack);
            }
            return current;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByPackageResult
    implements IResultTree,
    IIconProvider {
        Package root;
        IResultTable table;
        List<Column> columns;
        Map<Object, GroupedRowImpl> elements;

        public ByPackageResult(Package root, IResultTable table, List<Column> groupedColumns, Map<Object, GroupedRowImpl> elements) {
            this.root = root;
            this.table = table;
            this.columns = groupedColumns;
            this.elements = elements;
            for (Map.Entry<Object, GroupedRowImpl> entry : elements.entrySet()) {
                ((Package)entry.getKey()).setGroupedRow(entry.getValue());
            }
        }

        public ResultMetaData getResultMetaData() {
            return TQuantize.wrap(this.table);
        }

        public Column[] getColumns() {
            return this.columns.toArray(new Column[0]);
        }

        public List<?> getElements() {
            ArrayList<Object> children = new ArrayList<Object>();
            children.addAll(this.root.subPackages.values());
            this.addOriginalChildren(children, this.root);
            return children;
        }

        private void addOriginalChildren(List<Object> children, Object subject) {
            GroupedRowImpl row = this.elements.get(subject);
            if (row != null) {
                int ii = 0;
                while (ii < row.rowIndex.size()) {
                    int rowIndex = row.rowIndex.get(ii);
                    children.add(this.table.getRow(rowIndex));
                    ++ii;
                }
            }
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof Package;
        }

        public List<?> getChildren(Object parent) {
            if (parent instanceof Package) {
                Package p = (Package)parent;
                ArrayList<Object> children = new ArrayList<Object>();
                for (Package sp : p.subPackages.values()) {
                    children.add(sp);
                }
                this.addOriginalChildren(children, p);
                return children;
            }
            return null;
        }

        public Object getColumnValue(Object element, int columnIndex) {
            if (element instanceof Package) {
                Package p = (Package)element;
                if (columnIndex == 0) {
                    return p.name;
                }
                Quantize.Function function = p.functions[columnIndex - 1];
                return function != null ? function.getValue() : null;
            }
            if (columnIndex == 0) {
                String label = String.valueOf(this.table.getColumnValue(element, columnIndex));
                int p = label.lastIndexOf(46);
                return p >= 0 ? label.substring(p + 1) : label;
            }
            return this.table.getColumnValue(element, columnIndex);
        }

        public URL getIcon(Object row) {
            if (row instanceof Package) {
                return Icons.PACKAGE;
            }
            return this.table instanceof IIconProvider ? ((IIconProvider)this.table).getIcon(row) : null;
        }

        public IContextObject getContext(Object row) {
            if (row instanceof Package) {
                return null;
            }
            return this.table.getContext(row);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BySingleColumn
    extends Calculator {
        private int columnIndex;
        private Format formatter;

        public BySingleColumn(int columnIndex, Format formatter) {
            this.columnIndex = columnIndex;
            this.formatter = formatter;
        }

        @Override
        public Object key(Object row) throws SnapshotException {
            return this.quantize.table.getColumnValue(row, this.columnIndex);
        }

        @Override
        public String label(Object key) throws SnapshotException {
            return this.formatter != null ? this.formatter.format(key) : String.valueOf(key);
        }

        @Override
        public IResult result(Map<Object, GroupedRowImpl> map) {
            return new OneColumnFlatResult(this.quantize.table, this.quantize.columns, new ArrayList<GroupedRowImpl>(map.values()), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Calculator {
        protected TQuantize quantize;

        Calculator() {
        }

        public final void init(TQuantize quantize) {
            this.quantize = quantize;
        }

        abstract IResult result(Map<Object, GroupedRowImpl> var1);

        abstract String label(Object var1) throws SnapshotException;

        abstract Object key(Object var1) throws SnapshotException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompositeKey
    implements Comparable<CompositeKey> {
        Object[] keys;

        public CompositeKey(Object[] keys) {
            this.keys = keys;
        }

        @Override
        public int compareTo(CompositeKey o) {
            if (this.keys.length != o.keys.length) {
                return this.keys.length > o.keys.length ? -1 : 1;
            }
            int ii = 0;
            while (ii < this.keys.length) {
                int c = ((Comparable)this.keys[ii]).compareTo(o.keys[ii]);
                if (c != 0) {
                    return c;
                }
                ++ii;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompositeKey other = (CompositeKey)obj;
            if (this.keys.length != other.keys.length) {
                return false;
            }
            int ii = 0;
            while (ii < this.keys.length) {
                if (!this.keys[ii].equals(other.keys[ii])) {
                    return false;
                }
                ++ii;
            }
            return true;
        }

        public int hashCode() {
            int result = 0;
            int ii = 0;
            while (ii < this.keys.length) {
                result = 31 * result + this.keys[ii].hashCode();
                ++ii;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface GroupedRow
    extends Comparable<GroupedRow> {
        public List<?> getSubjects();

        public void addSubjectsTo(List<Object> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GroupedRowImpl
    implements GroupedRow {
        Object key;
        Object label;
        ArrayInt rowIndex;
        Quantize.Function[] functions;

        public GroupedRowImpl(Object key, Object label) {
            this.key = key;
            this.label = label;
            this.rowIndex = new ArrayInt();
        }

        public void addRowIndex(int idx) {
            this.rowIndex.add(idx);
        }

        @Override
        public int compareTo(GroupedRow o) {
            if (o instanceof GroupedRowImpl) {
                return String.valueOf(this.label).compareTo(String.valueOf(((GroupedRowImpl)o).label));
            }
            return 1;
        }

        @Override
        public List<?> getSubjects() {
            ArrayList<Object> answer = new ArrayList<Object>();
            this.addSubjectsTo(answer);
            return answer;
        }

        @Override
        public void addSubjectsTo(List<Object> subjects) {
            int ii = 0;
            while (ii < this.rowIndex.size()) {
                int rowIdx = this.rowIndex.get(ii);
                subjects.add(TQuantize.this.table.getRow(rowIdx));
                ++ii;
            }
        }

        public ArrayInt getObjectIds() {
            return null;
        }
    }

    static class MergedObjectContext {
        List<IContextObject> objects = new ArrayList<IContextObject>();

        MergedObjectContext() {
        }

        public void add(IContextObject ctx) {
            this.objects.add(ctx);
        }

        public IContextObject getContext() {
            if (this.objects.isEmpty()) {
                return null;
            }
            if (this.objects.size() == 1) {
                return this.objects.get(0);
            }
            return new IContextObjectSet(){

                public int[] getObjectIds() {
                    ArrayInt answer = new ArrayInt();
                    for (IContextObject c : MergedObjectContext.this.objects) {
                        if (c instanceof IContextObjectSet) {
                            answer.addAll(((IContextObjectSet)c).getObjectIds());
                            continue;
                        }
                        answer.add(c.getObjectId());
                    }
                    return answer.toArray();
                }

                public String getOQL() {
                    return null;
                }

                public int getObjectId() {
                    return -1;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MultipleColumnsFlatResult
    extends OneColumnFlatResult {
        public MultipleColumnsFlatResult(IResultTable table, List<Column> columns, List<GroupedRowImpl> elements) {
            super(table, columns, elements, null);
        }

        @Override
        public Object getColumnValue(Object element, int columnIndex) {
            if (element instanceof GroupedRowImpl) {
                GroupedRowImpl row = (GroupedRowImpl)element;
                CompositeKey key = (CompositeKey)row.key;
                if (columnIndex == 0) {
                    return row.label;
                }
                if (columnIndex < key.keys.length) {
                    return key.keys[columnIndex];
                }
                Quantize.Function function = row.functions[columnIndex - key.keys.length];
                return function != null ? function.getValue() : null;
            }
            return this.table.getColumnValue(element, columnIndex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OneColumnFlatResult
    implements IResultTree,
    IIconProvider {
        IResultTable table;
        List<GroupedRowImpl> elements;
        List<Column> columns;
        URL icon;

        public OneColumnFlatResult(IResultTable table, List<Column> groupedColumns, List<GroupedRowImpl> elements, URL icon) {
            this.table = table;
            this.elements = elements;
            this.columns = groupedColumns;
            this.icon = icon;
        }

        public ResultMetaData getResultMetaData() {
            return TQuantize.wrap(this.table);
        }

        public Column[] getColumns() {
            return this.columns.toArray(new Column[0]);
        }

        public List<?> getElements() {
            return this.elements;
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof GroupedRowImpl;
        }

        public List<?> getChildren(Object parent) {
            if (parent instanceof GroupedRowImpl) {
                GroupedRowImpl row = (GroupedRowImpl)parent;
                ArrayList<Object> children = new ArrayList<Object>(row.rowIndex.size());
                int ii = 0;
                while (ii < row.rowIndex.size()) {
                    int rowIndex = row.rowIndex.get(ii);
                    children.add(this.table.getRow(rowIndex));
                    ++ii;
                }
                return children;
            }
            return null;
        }

        public Object getColumnValue(Object element, int columnIndex) {
            if (element instanceof GroupedRowImpl) {
                GroupedRowImpl row = (GroupedRowImpl)element;
                switch (columnIndex) {
                    case 0: {
                        return row.label;
                    }
                }
                Quantize.Function function = row.functions[columnIndex - 1];
                return function != null ? function.getValue() : null;
            }
            return this.table.getColumnValue(element, columnIndex);
        }

        public IContextObject getContext(Object row) {
            if (row instanceof GroupedRowImpl) {
                final ArrayInt ctxIds = new ArrayInt();
                List<?> myChildren = this.getChildren(row);
                for (Object child : myChildren) {
                    IContextObject ctx = this.table.getContext(child);
                    if (ctx instanceof IContextObjectSet) {
                        ctxIds.addAll(((IContextObjectSet)ctx).getObjectIds());
                        continue;
                    }
                    if (ctx == null) continue;
                    ctxIds.add(ctx.getObjectId());
                }
                if (ctxIds.size() == 0) {
                    return null;
                }
                if (ctxIds.size() == 1) {
                    return new IContextObject(){

                        public int getObjectId() {
                            return ctxIds.get(0);
                        }
                    };
                }
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return -1;
                    }

                    public int[] getObjectIds() {
                        return ctxIds.toArray();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
            return this.table.getContext(row);
        }

        public URL getIcon(Object row) {
            if (row instanceof GroupedRowImpl) {
                return this.icon;
            }
            return this.table instanceof IIconProvider ? ((IIconProvider)this.table).getIcon(row) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Package
    implements GroupedRow {
        String name;
        Package parent;
        Map<String, Package> subPackages = new HashMap<String, Package>();
        Quantize.Function[] functions;
        GroupedRowImpl groupedRow;

        public Package(String name, Package parent) {
            this.name = name;
            this.parent = parent;
        }

        Package getOrCreateChild(String name) {
            Package answer = this.subPackages.get(name);
            if (answer == null) {
                answer = new Package(name, this);
                this.subPackages.put(name, answer);
            }
            return answer;
        }

        @Override
        public int compareTo(GroupedRow o) {
            if (o instanceof Package) {
                return this.name.compareTo(((Package)o).name);
            }
            return 1;
        }

        void setGroupedRow(GroupedRowImpl row) {
            this.groupedRow = row;
        }

        @Override
        public List<?> getSubjects() {
            ArrayList<Object> answer = new ArrayList<Object>();
            this.addSubjectsTo(answer);
            return answer;
        }

        @Override
        public void addSubjectsTo(List<Object> subjects) {
            if (this.groupedRow != null) {
                this.groupedRow.addSubjectsTo(subjects);
            }
            if (!this.subPackages.isEmpty()) {
                for (Package p : this.subPackages.values()) {
                    p.addSubjectsTo(subjects);
                }
            }
        }

        public ArrayInt getObjectIds() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Target {
        CLASSLOADER(Messages.TQuantize_Label_GroupByClassLoader, Messages.TQuantize_Label_GroupedByClassLoader, Icons.CLASSLOADER_INSTANCE, ByClassloader.class),
        PACKAGE(Messages.TQuantize_Label_GroupByPackage, Messages.TQuantize_Label_GroupedByPackage, Icons.PACKAGE, ByPackage.class);

        private final String label;
        private final String title;
        private final URL icon;
        private final Class<? extends Calculator> calculatorClass;

        private Target(String label, String title, URL icon, Class<? extends Calculator> calculatorClass) {
            this.label = label;
            this.title = title;
            this.icon = icon;
            this.calculatorClass = calculatorClass;
        }

        public String getLabel() {
            return this.label;
        }

        public String getTitle(String command) {
            return MessageUtil.format((String)this.title, (Object[])new Object[]{command});
        }

        public URL getIcon() {
            return this.icon;
        }

        Class<? extends Calculator> getCalculatorClass() {
            return this.calculatorClass;
        }
    }
}

