/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryDescriptor {
    protected final String identifier;
    protected final String name;
    protected final String category;
    protected String usage;
    protected final URL icon;
    protected final String help;
    protected final String helpUrl;
    protected final int sortOrder;
    protected final Class<? extends IQuery> subject;
    protected final List<ArgumentDescriptor> arguments;
    protected final List<QueryDescriptor> menuEntries;

    QueryDescriptor(String identifier, String name, String category, Class<? extends IQuery> subject, String usage, URL icon, String help, String helpUrl) {
        this.identifier = identifier;
        if (name == null) {
            this.name = null;
            this.sortOrder = Integer.MAX_VALUE;
        } else {
            int p = name.indexOf(124);
            this.name = p >= 0 ? name.substring(p + 1) : name;
            this.sortOrder = p >= 0 ? Integer.parseInt(name.substring(0, p)) : 100;
        }
        this.category = category;
        this.subject = subject;
        this.usage = usage;
        this.icon = icon;
        this.help = help;
        this.helpUrl = helpUrl;
        this.arguments = new ArrayList<ArgumentDescriptor>();
        this.menuEntries = new ArrayList<QueryDescriptor>();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getCategory() {
        return this.category;
    }

    public Class<? extends IQuery> getCommandType() {
        return this.subject;
    }

    public ArgumentSet createNewArgumentSet(IQueryContext context) throws SnapshotException {
        return new ArgumentSet(this, context);
    }

    public synchronized String getUsage(IQueryContext context) {
        if (this.usage != null) {
            return this.usage;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(this.identifier);
        for (ArgumentDescriptor param : this.arguments) {
            if (context.available(param.getType(), param.getAdvice())) continue;
            param.appendUsage(buf);
        }
        this.usage = buf.toString();
        return this.usage;
    }

    public URL getIcon() {
        return this.icon;
    }

    public String getHelp() {
        return this.help;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public boolean isHelpAvailable() {
        if (this.help != null) {
            return true;
        }
        for (ArgumentDescriptor arg : this.arguments) {
            if (arg.getHelp() == null) continue;
            return true;
        }
        return false;
    }

    public String getShortDescription() {
        String description = null;
        if (this.help != null) {
            int p = this.help.indexOf(46);
            description = p >= 0 && p <= 80 ? this.help.substring(0, p + 1) : (this.help.length() > 80 ? ((p = this.help.lastIndexOf(32, 80)) >= 0 ? String.valueOf(this.help.substring(0, p)) + " ..." : String.valueOf(this.help.substring(0, 80)) + " ...") : this.help);
        }
        return description;
    }

    public String toString() {
        return new StringBuilder(128).append(this.identifier).append(" (").append(this.subject.getName()).append(")").toString();
    }

    public boolean accept(IQueryContext context) {
        for (ArgumentDescriptor argument : this.arguments) {
            if (context.available(argument.getType(), argument.getAdvice()) || context.converts(argument.getType(), argument.getAdvice())) continue;
            if (ReportPlugin.getDefault().isDebugging()) {
                ReportPlugin.log(1, MessageUtil.format(Messages.QueryDescriptor_Error_IgnoringQuery, this.getIdentifier(), argument.getName()));
            }
            return false;
        }
        return true;
    }

    public String explain(IQueryContext context) {
        StringBuilder buf = new StringBuilder();
        for (ArgumentDescriptor argument : this.arguments) {
            if (context.available(argument.getType(), argument.getAdvice()) || context.converts(argument.getType(), argument.getAdvice())) continue;
            if (buf.length() > 0) {
                buf.append('\n');
            }
            buf.append(MessageUtil.format(Messages.QueryDescriptor_Error_NotSupported, argument.toString()));
        }
        return buf.toString();
    }

    public List<ArgumentDescriptor> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public ArgumentDescriptor getArgumentByName(String name) {
        for (ArgumentDescriptor argument : this.arguments) {
            if (!argument.getName().equals(name)) continue;
            return argument;
        }
        return null;
    }

    public List<QueryDescriptor> getMenuEntries() {
        return Collections.unmodifiableList(this.menuEntries);
    }

    public boolean isShallow() {
        return false;
    }

    void addParamter(ArgumentDescriptor descriptor) {
        this.arguments.add(descriptor);
    }

    void addMenuEntry(String label, String category, String help, String helpUrl, URL icon, String options) {
        this.menuEntries.add(new ShallowQueryDescriptor(this, label, category, icon, help, helpUrl, options));
    }

    ArgumentDescriptor byFlag(String name) {
        for (ArgumentDescriptor d : this.arguments) {
            if (!name.equals(d.getFlag())) continue;
            return d;
        }
        return null;
    }

    static class ShallowQueryDescriptor
    extends QueryDescriptor {
        private String options;

        private ShallowQueryDescriptor(QueryDescriptor parent, String label, String category, URL icon, String help, String helpUrl, String options) {
            super(parent.identifier, label, category, parent.subject, parent.usage, icon, help, helpUrl);
            this.options = options;
            this.arguments.addAll(parent.arguments);
        }

        public ArgumentSet createNewArgumentSet(IQueryContext contextProvider) throws SnapshotException {
            ArgumentSet answer = super.createNewArgumentSet(contextProvider);
            if (this.options.length() > 0) {
                CommandLine.fillIn(answer, this.options);
            }
            return answer;
        }

        public boolean isShallow() {
            return true;
        }
    }
}

