/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.registry;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.annotations.Menu;
import org.eclipse.mat.query.annotations.Name;
import org.eclipse.mat.query.annotations.Usage;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.RegistryReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryRegistry
extends RegistryReader<IQuery> {
    private final Map<String, QueryDescriptor> commandsByIdentifier = new HashMap<String, QueryDescriptor>();
    private final Map<String, QueryDescriptor> commandsByClass = new HashMap<String, QueryDescriptor>();
    private CategoryDescriptor rootCategory;
    private static final QueryRegistry instance = new QueryRegistry();

    public static QueryRegistry instance() {
        return instance;
    }

    public QueryRegistry() {
        this.init(ReportPlugin.getDefault().getExtensionTracker(), "org.eclipse.mat.report.query");
    }

    @Override
    protected IQuery createDelegate(IConfigurationElement configElement) throws CoreException {
        try {
            IQuery query = (IQuery)configElement.createExecutableExtension("impl");
            QueryDescriptor descriptor = this.registerQuery(query);
            if (ReportPlugin.getDefault().isDebugging()) {
                ReportPlugin.log(1, MessageUtil.format(Messages.QueryRegistry_Msg_QueryRegistered, descriptor));
            }
            this.rootCategory = null;
            return descriptor != null ? query : null;
        }
        catch (SnapshotException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mat.report", MessageUtil.format(Messages.QueryRegistry_Error_Registering, configElement.getAttribute("impl")), (Throwable)e));
        }
    }

    @Override
    protected void removeDelegate(IQuery delegate) {
        for (QueryDescriptor descriptor : this.commandsByIdentifier.values()) {
            if (descriptor.getCommandType() != delegate.getClass()) continue;
            this.commandsByIdentifier.remove(descriptor.getIdentifier());
            this.commandsByClass.remove(descriptor.getCommandType().getName().toLowerCase());
            this.rootCategory = null;
            break;
        }
    }

    public synchronized Collection<QueryDescriptor> getQueries() {
        return Collections.unmodifiableCollection(this.commandsByIdentifier.values());
    }

    public List<QueryDescriptor> getQueries(Pattern pattern) {
        ArrayList<QueryDescriptor> answer = new ArrayList<QueryDescriptor>();
        for (Map.Entry<String, QueryDescriptor> entry : this.commandsByIdentifier.entrySet()) {
            if (!pattern.matcher(entry.getKey()).matches()) continue;
            answer.add(entry.getValue());
        }
        return answer;
    }

    public synchronized CategoryDescriptor getRootCategory() {
        if (this.rootCategory == null) {
            LinkedList<QueryDescriptor> stack = new LinkedList<QueryDescriptor>();
            stack.addAll(this.commandsByIdentifier.values());
            this.rootCategory = new CategoryDescriptor("<root>");
            while (!stack.isEmpty()) {
                QueryDescriptor descriptor = (QueryDescriptor)stack.removeFirst();
                stack.addAll(descriptor.getMenuEntries());
                String category = descriptor.getCategory();
                if ("__hidden__".equals(category)) continue;
                if (category == null) {
                    this.rootCategory.add(descriptor);
                    continue;
                }
                CategoryDescriptor entry = this.rootCategory.resolve(category);
                entry.add(descriptor);
            }
        }
        return this.rootCategory;
    }

    public synchronized QueryDescriptor getQuery(String name) {
        QueryDescriptor descriptor = this.commandsByIdentifier.get(name);
        return descriptor != null ? descriptor : this.commandsByClass.get(name);
    }

    public synchronized QueryDescriptor getQuery(Class<? extends IQuery> query) {
        return this.commandsByClass.get(query.getName().toLowerCase());
    }

    private String getIdentifier(IQuery query) {
        Class<?> queryClass = query.getClass();
        Name n = queryClass.getAnnotation(Name.class);
        String name = n != null ? n.value() : queryClass.getSimpleName();
        CommandName cn = queryClass.getAnnotation(CommandName.class);
        return (cn != null ? cn.value() : name).toLowerCase().replace(' ', '_');
    }

    private final synchronized QueryDescriptor registerQuery(IQuery query) throws SnapshotException {
        Class<?> queryClass = query.getClass();
        String key = queryClass.getSimpleName();
        ResourceBundle i18n = this.getBundle(queryClass);
        Name n = queryClass.getAnnotation(Name.class);
        String name = this.translate(i18n, String.valueOf(key) + ".name", n != null ? n.value() : queryClass.getSimpleName());
        String identifier = this.getIdentifier(query);
        if (this.commandsByIdentifier.containsKey(identifier)) {
            throw new SnapshotException(MessageUtil.format(Messages.QueryRegistry_Error_NameBound, identifier, this.commandsByIdentifier.get(identifier).getCommandType().getName()));
        }
        Category c = queryClass.getAnnotation(Category.class);
        String category = this.translate(i18n, String.valueOf(key) + ".category", c != null ? c.value() : null);
        Usage u = queryClass.getAnnotation(Usage.class);
        String usage = u != null ? u.value() : null;
        Help h = queryClass.getAnnotation(Help.class);
        String help = this.translate(i18n, String.valueOf(key) + ".help", h != null ? h.value() : null);
        HelpUrl hu = queryClass.getAnnotation(HelpUrl.class);
        String helpUrl = hu != null ? hu.value() : null;
        Icon i = queryClass.getAnnotation(Icon.class);
        URL icon = i != null ? queryClass.getResource(i.value()) : null;
        QueryDescriptor descriptor = new QueryDescriptor(identifier, name, category, queryClass, usage, icon, help, helpUrl);
        Class<?> clazz = queryClass;
        while (!clazz.equals(Object.class)) {
            this.addArguments(query, clazz, descriptor, i18n);
            clazz = clazz.getSuperclass();
        }
        this.readMenuEntries(queryClass, descriptor, i18n);
        this.commandsByIdentifier.put(identifier, descriptor);
        this.commandsByClass.put(query.getClass().getName().toLowerCase(), descriptor);
        return descriptor;
    }

    private String translate(ResourceBundle i18n, String key, String defaultValue) {
        try {
            return i18n.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return defaultValue;
        }
    }

    private ResourceBundle getBundle(Class<? extends IQuery> queryClass) {
        try {
            return ResourceBundle.getBundle(String.valueOf(queryClass.getPackage().getName()) + ".annotations", Locale.getDefault(), queryClass.getClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            return new ResourceBundle(){

                @Override
                protected Object handleGetObject(String key) {
                    return null;
                }

                @Override
                public Enumeration<String> getKeys() {
                    return null;
                }
            };
        }
    }

    private void readMenuEntries(Class<? extends IQuery> queryClass, QueryDescriptor descriptor, ResourceBundle i18n) {
        Menu menu = queryClass.getAnnotation(Menu.class);
        if (menu == null || menu.value() == null || menu.value().length == 0) {
            return;
        }
        String key = String.valueOf(queryClass.getSimpleName()) + ".menu.";
        int index = 0;
        Menu.Entry[] entryArray = menu.value();
        int n = entryArray.length;
        int n2 = 0;
        while (n2 < n) {
            String helpUrl;
            String help;
            String category;
            Menu.Entry entry = entryArray[n2];
            String label = this.translate(i18n, String.valueOf(key) + index + ".label", entry.label());
            if (label == null || label.length() == 0) {
                label = MessageUtil.format(Messages.QueryRegistry_MissingLabel, queryClass.getName(), String.valueOf(index + 1));
            }
            if ((category = this.translate(i18n, String.valueOf(key) + index + ".category", entry.category())) == null || category.length() == 0) {
                category = descriptor.getCategory();
            }
            if ((help = this.translate(i18n, String.valueOf(key) + index + ".help", entry.help())) == null || help.length() == 0) {
                help = descriptor.getHelp();
            }
            if ((helpUrl = entry.helpUrl()).length() == 0) {
                helpUrl = descriptor.getHelpUrl();
            }
            URL icon = descriptor.getIcon();
            String i = entry.icon();
            if (i.length() > 0) {
                icon = queryClass.getResource(i);
            }
            String options = entry.options();
            descriptor.addMenuEntry(label, category, help, helpUrl, icon, options);
            ++index;
            ++n2;
        }
    }

    private void addArguments(IQuery query, Class<?> clazz, QueryDescriptor descriptor, ResourceBundle i18n) throws SnapshotException {
        Field[] fields;
        Field[] fieldArray = fields = clazz.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                Argument argument = field.getAnnotation(Argument.class);
                if (argument != null) {
                    ArgumentDescriptor argDescriptor = this.fromAnnotation(clazz, argument, field, field.get(query));
                    Help h = field.getAnnotation(Help.class);
                    String help = this.translate(i18n, String.valueOf(clazz.getSimpleName()) + "." + argDescriptor.getName() + ".help", h != null ? h.value() : null);
                    if (help != null) {
                        argDescriptor.setHelp(help);
                    }
                    descriptor.addParamter(argDescriptor);
                }
            }
            catch (SnapshotException e) {
                throw e;
            }
            catch (IllegalAccessException e) {
                String msg = Messages.QueryRegistry_Error_Inaccessible;
                throw new SnapshotException(MessageUtil.format(msg, field.getName(), clazz.getName()), e);
            }
            catch (Exception e) {
                throw new SnapshotException(MessageUtil.format(Messages.QueryRegistry_Error_Argument, field.getName(), clazz.getName()), e);
            }
            ++n2;
        }
    }

    private ArgumentDescriptor fromAnnotation(Class<?> clazz, Argument annotation, Field field, Object defaultValue) throws SnapshotException {
        ArgumentDescriptor d = new ArgumentDescriptor();
        d.setMandatory(annotation.isMandatory());
        d.setName(field.getName());
        String flag = annotation.flag();
        if (flag.length() == 0) {
            flag = field.getName().toLowerCase();
        }
        if ("none".equals(flag)) {
            flag = null;
        }
        d.setFlag(flag);
        d.setField(field);
        d.setArray(field.getType().isArray());
        d.setList(List.class.isAssignableFrom(field.getType()));
        if (d.isArray()) {
            d.setType(field.getType().getComponentType());
        } else if (d.isList()) {
            Type type = field.getGenericType();
            if (type instanceof ParameterizedType) {
                Type[] typeArguments = ((ParameterizedType)type).getActualTypeArguments();
                d.setType((Class)typeArguments[0]);
            }
        } else {
            d.setType(field.getType());
        }
        Argument.Advice advice = annotation.advice();
        if (advice == Argument.Advice.CLASS_NAME_PATTERN && !Pattern.class.isAssignableFrom(d.getType())) {
            String msg = MessageUtil.format(Messages.QueryRegistry_Error_Advice, new Object[]{field.getName(), clazz.getName(), Argument.Advice.CLASS_NAME_PATTERN, Pattern.class.getName()});
            throw new SnapshotException(msg);
        }
        if (advice != Argument.Advice.NONE) {
            d.setAdvice(advice);
        }
        if (d.isArray() && defaultValue != null) {
            int size = Array.getLength(defaultValue);
            ArrayList<Object> l = new ArrayList<Object>(size);
            int ii = 0;
            while (ii < size) {
                l.add(Array.get(defaultValue, ii));
                ++ii;
            }
            d.setDefaultValue(Collections.unmodifiableList(l));
        } else {
            d.setDefaultValue(defaultValue);
        }
        return d;
    }
}

