/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.CategoryDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.internal.browser.QueryBrowserPopup;
import org.eclipse.mat.ui.internal.browser.QueryBrowserProvider;

public class QueryRegistryProvider
extends QueryBrowserProvider {
    IQueryContext context;
    CategoryDescriptor category;

    public QueryRegistryProvider(IQueryContext context, CategoryDescriptor c) {
        this.context = context;
        this.category = c;
    }

    public QueryBrowserPopup.Element[] getElements() {
        List queries = this.category.getQueries();
        ArrayList<CQQElement> answer = new ArrayList<CQQElement>(queries.size());
        for (QueryDescriptor query : queries) {
            if (!query.accept(this.context)) continue;
            answer.add(new CQQElement(query));
        }
        return answer.toArray(new QueryBrowserPopup.Element[0]);
    }

    public String getName() {
        return this.category.getFullName();
    }

    class CQQElement
    implements QueryBrowserPopup.Element {
        String label;
        QueryDescriptor query;

        public CQQElement(QueryDescriptor query) {
            this.query = query;
        }

        public void execute(MultiPaneEditor editor) throws SnapshotException {
            QueryExecution.executeQuery(editor, this.query);
        }

        public ImageDescriptor getImageDescriptor() {
            return MemoryAnalyserPlugin.getDefault().getImageDescriptor(this.query);
        }

        public String getLabel() {
            if (this.label == null) {
                StringBuilder b = new StringBuilder(128).append(this.query.getName());
                String shortDescription = this.query.getShortDescription();
                if (shortDescription != null) {
                    b.append("  -  ").append(shortDescription);
                }
                this.label = b.toString();
            }
            return this.label;
        }

        public String getUsage() {
            return this.query.getUsage(QueryRegistryProvider.this.context);
        }

        public QueryDescriptor getQuery() {
            return this.query;
        }
    }
}

