/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.DecimalFormat;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.ArrayUtils;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultTree;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.HistogramRecord;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.snapshot.query.PieFactory;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.SimpleStringTokenizer;

@CommandName(value="top_consumers_html")
@Category(value="Leak Identification")
public class TopConsumers2Query
implements IQuery {
    private static final Column COL_RETAINED_HEAP = new Column(Messages.TopConsumers2Query_Column_RetainedHeapPercent, Double.TYPE).formatting((Format)new DecimalFormat("0.00%")).noTotals();
    @Argument
    public ISnapshot snapshot;
    @Argument(advice=Argument.Advice.HEAP_OBJECT, isMandatory=false, flag="none")
    public int[] objects;
    @Argument(isMandatory=false, flag="t")
    public int thresholdPercent = 1;
    private long totalHeap;
    private int[] topDominators;
    private long[] topDominatorRetainedHeap;
    private long threshold;

    public IResult execute(IProgressListener listener) throws Exception {
        if (this.objects != null && this.objects.length == 0) {
            return new TextResult(Messages.TopConsumers2Query_MsgNoObjects);
        }
        SectionSpec spec = new SectionSpec(Messages.TopConsumers2Query_TopConsumers);
        this.setup(listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        this.addBiggestObjects(spec);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Histogram histogram = this.getDominatedHistogramWithRetainedSizes(listener);
        this.addTopLevelDominatorClasses(spec, histogram, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        this.addTopLevelDominatorClassloader(spec, histogram, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        this.addPackageTree(spec, listener);
        return spec;
    }

    private void setup(IProgressListener listener) throws SnapshotException {
        if (this.objects == null) {
            this.topDominators = this.snapshot.getImmediateDominatedIds(-1);
            this.totalHeap = this.snapshot.getSnapshotInfo().getUsedHeapSize();
            this.topDominatorRetainedHeap = new long[this.topDominators.length];
            int ii = 0;
            while (ii < this.topDominators.length) {
                this.topDominatorRetainedHeap[ii] = this.snapshot.getRetainedHeapSize(this.topDominators[ii]);
                ++ii;
            }
        } else {
            this.topDominators = this.snapshot.getTopAncestorsInDominatorTree(this.objects, listener);
            this.topDominatorRetainedHeap = new long[this.topDominators.length];
            this.totalHeap = 0L;
            int ii = 0;
            while (ii < this.topDominators.length) {
                this.topDominatorRetainedHeap[ii] = this.snapshot.getRetainedHeapSize(this.topDominators[ii]);
                this.totalHeap += this.topDominatorRetainedHeap[ii];
                ++ii;
            }
        }
        this.threshold = (long)this.thresholdPercent * this.totalHeap / 100L;
    }

    private void addBiggestObjects(SectionSpec composite) throws SnapshotException {
        if (this.objects == null) {
            ArrayInt suspects = new ArrayInt();
            PieFactory pie = new PieFactory(this.snapshot, this.totalHeap);
            int ii = 0;
            while (ii < this.topDominators.length) {
                if (this.topDominatorRetainedHeap[ii] <= this.threshold) break;
                suspects.add(this.topDominators[ii]);
                pie.addSlice(this.topDominators[ii]);
                ++ii;
            }
            if (suspects.isEmpty()) {
                String msg = MessageUtil.format((String)Messages.TopConsumers2Query_NoObjectsBiggerThan, (Object[])new Object[]{this.thresholdPercent});
                composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestObjects, (IResult)new TextResult(msg, true)));
            } else {
                composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestObjectsOverview, (IResult)pie.build()));
                QuerySpec spec = new QuerySpec(Messages.TopConsumers2Query_BiggestObjects, (IResult)new ObjectListResult.Outbound(this.snapshot, suspects.toArray()));
                spec.set("html.collapsed", Boolean.TRUE.toString());
                composite.add((Spec)spec);
            }
        } else {
            ArrayInt suspects = new ArrayInt();
            ArrayLong sizes = new ArrayLong();
            int ii = 0;
            while (ii < this.topDominators.length) {
                long size = this.topDominatorRetainedHeap[ii];
                if (size > this.threshold) {
                    suspects.add(this.topDominators[ii]);
                    sizes.add(size);
                }
                ++ii;
            }
            if (suspects.isEmpty()) {
                String msg = MessageUtil.format((String)Messages.TopConsumers2Query_NoObjectsBiggerThan, (Object[])new Object[]{this.thresholdPercent});
                composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestObjects, (IResult)new TextResult(msg, true)));
            } else {
                int[] ids = suspects.toArray();
                long[] s = sizes.toArray();
                ArrayUtils.sortDesc((long[])s, (int[])ids);
                PieFactory pie = new PieFactory(this.snapshot, this.totalHeap);
                int ii2 = 0;
                while (ii2 < ids.length) {
                    pie.addSlice(ids[ii2]);
                    ++ii2;
                }
                composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestObjectsOverview, (IResult)pie.build()));
                QuerySpec spec = new QuerySpec(Messages.TopConsumers2Query_BiggestObjects, (IResult)new ObjectListResult.Outbound(this.snapshot, ids));
                spec.set("html.collapsed", Boolean.TRUE.toString());
                composite.add((Spec)spec);
            }
        }
    }

    private void addTopLevelDominatorClasses(SectionSpec composite, Histogram histogram, IProgressListener listener) {
        ClassHistogramRecord[] records = histogram.getClassHistogramRecords().toArray(new ClassHistogramRecord[0]);
        Arrays.sort(records, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        PieFactory pie = new PieFactory(this.snapshot, this.totalHeap);
        ArrayList<ClassHistogramRecord> suspects = new ArrayList<ClassHistogramRecord>();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ClassHistogramRecord[] classHistogramRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            ClassHistogramRecord record = classHistogramRecordArray[n2];
            if (record.getRetainedHeapSize() <= this.threshold) break;
            suspects.add(record);
            pie.addSlice(record.getClassId(), record.getLabel(), record.getUsedHeapSize(), record.getRetainedHeapSize());
            ++n2;
        }
        if (suspects.isEmpty()) {
            String msg = MessageUtil.format((String)Messages.TopConsumers2Query_NoClassesBiggerThan, (Object[])new Object[]{this.thresholdPercent});
            composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestClasses, (IResult)new TextResult(msg, true)));
        } else {
            ListResult result = new ListResult(ClassHistogramRecord.class, suspects, new String[]{"label", "numberOfObjects", "usedHeapSize", "retainedHeapSize"}){

                public URL getIcon(Object row) {
                    return Icons.forObject(TopConsumers2Query.this.snapshot, ((ClassHistogramRecord)row).getClassId());
                }

                public IContextObject getContext(final Object row) {
                    return new IContextObject(){

                        public int getObjectId() {
                            return ((ClassHistogramRecord)row).getClassId();
                        }
                    };
                }
            };
            result.addColumn(COL_RETAINED_HEAP, (ListResult.ValueProvider)new PercentageValueProvider(this.totalHeap));
            composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestClassesOverview, (IResult)pie.build()));
            QuerySpec spec = new QuerySpec(Messages.TopConsumers2Query_BiggestClasses, (IResult)result);
            spec.set("html.collapsed", Boolean.TRUE.toString());
            composite.add((Spec)spec);
        }
    }

    private void addTopLevelDominatorClassloader(SectionSpec composite, Histogram histogram, IProgressListener listener) {
        ClassLoaderHistogramRecord[] records = histogram.getClassLoaderHistogramRecords().toArray(new ClassLoaderHistogramRecord[0]);
        Arrays.sort(records, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        PieFactory pie = new PieFactory(this.snapshot, this.totalHeap);
        ArrayList<ClassLoaderHistogramRecord> suspects = new ArrayList<ClassLoaderHistogramRecord>();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ClassLoaderHistogramRecord[] classLoaderHistogramRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            ClassLoaderHistogramRecord record = classLoaderHistogramRecordArray[n2];
            if (record.getRetainedHeapSize() <= this.threshold) break;
            suspects.add(record);
            pie.addSlice(record.getClassLoaderId(), record.getLabel(), record.getUsedHeapSize(), record.getRetainedHeapSize());
            ++n2;
        }
        if (suspects.isEmpty()) {
            String msg = MessageUtil.format((String)Messages.TopConsumers2Query_NoClassLoaderBiggerThan, (Object[])new Object[]{this.thresholdPercent});
            composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestClassLoaders, (IResult)new TextResult(msg, true)));
        } else {
            ListResult result = new ListResult(ClassLoaderHistogramRecord.class, suspects, new String[]{"label", "numberOfObjects", "usedHeapSize", "retainedHeapSize"}){

                public URL getIcon(Object row) {
                    return Icons.forObject(TopConsumers2Query.this.snapshot, ((ClassLoaderHistogramRecord)row).getClassLoaderId());
                }

                public IContextObject getContext(final Object row) {
                    return new IContextObject(){

                        public int getObjectId() {
                            return ((ClassLoaderHistogramRecord)row).getClassLoaderId();
                        }
                    };
                }
            };
            result.addColumn(COL_RETAINED_HEAP, (ListResult.ValueProvider)new PercentageValueProvider(this.totalHeap));
            composite.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestClassLoadersOverview, (IResult)pie.build()));
            QuerySpec spec = new QuerySpec(Messages.TopConsumers2Query_BiggestClassLoaders, (IResult)result);
            spec.set("html.collapsed", Boolean.TRUE.toString());
            composite.add((Spec)spec);
        }
    }

    private void addPackageTree(SectionSpec spec, IProgressListener listener) throws SnapshotException {
        PackageTreeNode root = this.groupByPackage(listener);
        root.retainedSize = this.totalHeap;
        root.dominatorsCount = this.topDominators.length;
        this.pruneTree(root);
        spec.add((Spec)new QuerySpec(Messages.TopConsumers2Query_BiggestPackages, (IResult)new PackageTreeResult(root, this.totalHeap)));
    }

    private Histogram getDominatedHistogramWithRetainedSizes(IProgressListener listener) throws SnapshotException {
        listener.beginTask(Messages.TopConsumers2Query_CreatingHistogram, this.topDominators.length / 1000);
        HashMapIntObject id2class = new HashMapIntObject();
        HashMapIntObject id2loader = new HashMapIntObject();
        long totalShallow = 0L;
        int ii = 0;
        while (ii < this.topDominators.length) {
            int usedHeap = this.snapshot.getHeapSize(this.topDominators[ii]);
            totalShallow += (long)usedHeap;
            IClass clazz = this.snapshot.getClassOf(this.topDominators[ii]);
            ClassHistogramRecord classRecord = (ClassHistogramRecord)id2class.get(clazz.getObjectId());
            if (classRecord == null) {
                classRecord = new ClassHistogramRecord(clazz.getName(), clazz.getObjectId(), 0L, 0L, 0L);
                id2class.put(clazz.getObjectId(), (Object)classRecord);
            }
            classRecord.incNumberOfObjects();
            classRecord.incUsedHeapSize(usedHeap);
            classRecord.incRetainedHeapSize(this.topDominatorRetainedHeap[ii]);
            ClassLoaderHistogramRecord loaderRecord = (ClassLoaderHistogramRecord)id2loader.get(clazz.getClassLoaderId());
            if (loaderRecord == null) {
                IObject loader = this.snapshot.getObject(clazz.getClassLoaderId());
                String name = loader.getClassSpecificName();
                if (name == null) {
                    name = loader.getTechnicalName();
                }
                loaderRecord = new ClassLoaderHistogramRecord(name, loader.getObjectId(), null, 0L, 0L, 0L);
                id2loader.put(clazz.getClassLoaderId(), (Object)loaderRecord);
            }
            loaderRecord.incNumberOfObjects();
            loaderRecord.incUsedHeapSize(usedHeap);
            loaderRecord.incRetainedHeapSize(this.topDominatorRetainedHeap[ii]);
            if (ii % 1000 == 0) {
                listener.worked(1);
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            ++ii;
        }
        ArrayList<ClassHistogramRecord> classList = new ArrayList<ClassHistogramRecord>(id2class.size());
        Iterator ee = id2class.values();
        while (ee.hasNext()) {
            classList.add((ClassHistogramRecord)ee.next());
        }
        ArrayList<ClassLoaderHistogramRecord> loaderList = new ArrayList<ClassLoaderHistogramRecord>(id2loader.size());
        Iterator ee2 = id2loader.values();
        while (ee2.hasNext()) {
            loaderList.add((ClassLoaderHistogramRecord)ee2.next());
        }
        listener.done();
        return new Histogram(null, classList, loaderList, this.topDominators.length, totalShallow, this.totalHeap);
    }

    private PackageTreeNode groupByPackage(IProgressListener listener) throws SnapshotException {
        PackageTreeNode root = new PackageTreeNode(Messages.TopConsumers2Query_Label_all);
        listener.beginTask(Messages.TopConsumers2Query_GroupingByPackage, this.topDominators.length / 1000);
        int ii = 0;
        while (ii < this.topDominators.length) {
            int dominatorId = this.topDominators[ii];
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            long retainedSize = this.topDominatorRetainedHeap[ii];
            PackageTreeNode current = root;
            String className = this.snapshot.isClass(dominatorId) ? ((IClass)this.snapshot.getObject(dominatorId)).getName() : this.snapshot.getClassOf(dominatorId).getName();
            for (String subpack : new SimpleStringTokenizer(className, '.')) {
                PackageTreeNode childNode = (PackageTreeNode)current.subpackages.get(subpack);
                if (childNode == null) {
                    childNode = new PackageTreeNode(subpack);
                    current.subpackages.put(subpack, childNode);
                }
                PackageTreeNode packageTreeNode = childNode;
                packageTreeNode.retainedSize = packageTreeNode.retainedSize + retainedSize;
                PackageTreeNode packageTreeNode2 = childNode;
                packageTreeNode2.dominatorsCount = packageTreeNode2.dominatorsCount + 1;
                current = childNode;
            }
            if (ii % 1000 == 0) {
                listener.worked(1);
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            ++ii;
        }
        listener.done();
        return root;
    }

    private void pruneTree(PackageTreeNode node) {
        Iterator iter = node.subpackages.values().iterator();
        while (iter.hasNext()) {
            PackageTreeNode current = (PackageTreeNode)iter.next();
            if (current.retainedSize < this.threshold) {
                iter.remove();
                continue;
            }
            this.pruneTree(current);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageTreeNode
    implements Comparable<PackageTreeNode> {
        private String packageName;
        private Map<String, PackageTreeNode> subpackages = new HashMap<String, PackageTreeNode>();
        private int dominatorsCount;
        private long retainedSize;

        public PackageTreeNode(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public int compareTo(PackageTreeNode o) {
            if (this.retainedSize < o.retainedSize) {
                return 1;
            }
            if (this.retainedSize > o.retainedSize) {
                return -1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageTreeResult
    implements IResultTree,
    IIconProvider,
    ISelectionProvider {
        PackageTreeNode root;
        double base;

        private PackageTreeResult(PackageTreeNode root, long base) {
            this.root = root;
            this.base = base;
        }

        public ResultMetaData getResultMetaData() {
            return null;
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.TopConsumers2Query_Column_Package), new Column(Messages.Column_RetainedHeap, Long.TYPE).sorting(Column.SortDirection.DESC), COL_RETAINED_HEAP, new Column(Messages.TopConsumers2Query_Column_TopDominators, Integer.TYPE)};
        }

        public List<?> getElements() {
            ArrayList<PackageTreeNode> elements = new ArrayList<PackageTreeNode>(1);
            elements.add(this.root);
            return elements;
        }

        public boolean hasChildren(Object element) {
            return !((PackageTreeNode)element).subpackages.isEmpty();
        }

        public List<?> getChildren(Object parent) {
            return new ArrayList(((PackageTreeNode)parent).subpackages.values());
        }

        public Object getColumnValue(Object row, int columnIndex) {
            PackageTreeNode node = (PackageTreeNode)row;
            switch (columnIndex) {
                case 0: {
                    return node.packageName;
                }
                case 1: {
                    return node.retainedSize;
                }
                case 2: {
                    return (double)node.retainedSize / this.base;
                }
                case 3: {
                    return node.dominatorsCount;
                }
            }
            return null;
        }

        public IContextObject getContext(Object row) {
            return null;
        }

        public URL getIcon(Object row) {
            PackageTreeNode node = (PackageTreeNode)row;
            return node.subpackages.isEmpty() ? Icons.CLASS : Icons.PACKAGE;
        }

        public boolean isExpanded(Object row) {
            return true;
        }

        public boolean isSelected(Object row) {
            return false;
        }
    }

    private static class PercentageValueProvider
    implements ListResult.ValueProvider {
        double base;

        private PercentageValueProvider(long base) {
            this.base = base;
        }

        public Object getValueFor(Object row) {
            HistogramRecord record = (HistogramRecord)row;
            return (double)record.getRetainedHeapSize() / this.base;
        }
    }
}

