/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandName(value="hash_entries")
public class HashEntriesQuery
implements IQuery {
    private static final String NULL = "<null>";
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String array_attribute;
    @Argument(isMandatory=false)
    public String key_attribute;
    @Argument(isMandatory=false)
    public String value_attribute;

    public Result execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        listener.subTask(Messages.HashEntriesQuery_Msg_Extracting);
        HashMapIntObject<CollectionUtil.Info> hashes = CollectionUtil.getKnownMaps(this.snapshot);
        if (this.collection != null) {
            if (this.array_attribute == null || this.key_attribute == null || this.value_attribute == null) {
                String msg = Messages.HashEntriesQuery_ErrorMsg_MissingArguments;
                throw new SnapshotException(msg);
            }
            CollectionUtil.Info info = new CollectionUtil.Info(this.collection, null, this.array_attribute, this.key_attribute, this.value_attribute);
            Collection<IClass> classes = this.snapshot.getClassesByName(this.collection, true);
            if (classes == null || classes.isEmpty()) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.HashEntriesQuery_ErrorMsg_ClassNotFound, (Object[])new Object[]{this.collection}), null);
            } else {
                for (IClass clasz : classes) {
                    hashes.put(clasz.getObjectId(), (Object)info);
                }
            }
        }
        ArrayList<Entry> hashEntries = new ArrayList<Entry>();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] ids;
            int[] nArray = ids = (int[])iterator.next();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                CollectionUtil.Info info = (CollectionUtil.Info)hashes.get(this.snapshot.getClassOf(id).getObjectId());
                if (info != null) {
                    ObjectReference tableFieldValue;
                    IInstance collection = (IInstance)this.snapshot.getObject(id);
                    String collectionName = collection.getDisplayName();
                    String arrayField = info.getBackingArrayField();
                    int p = arrayField.lastIndexOf(46);
                    IInstance map = p < 0 ? collection : (IInstance)collection.resolveValue(arrayField.substring(0, p));
                    Field tableField = map.getField(p < 0 ? arrayField : arrayField.substring(p + 1));
                    if (tableField != null && (tableFieldValue = (ObjectReference)tableField.getValue()) != null) {
                        int tableObjectId = tableFieldValue.getObjectId();
                        int[] outbounds = this.snapshot.getOutboundReferentIds(tableObjectId);
                        int ii = 0;
                        while (ii < outbounds.length) {
                            this.collectEntry(hashEntries, info, collection.getObjectId(), collectionName, outbounds[ii], listener);
                            ++ii;
                        }
                    }
                    if (listener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                }
                ++n2;
            }
        }
        listener.done();
        return new Result(this.snapshot, hashEntries);
    }

    private void collectEntry(List<Entry> hashEntries, CollectionUtil.Info info, int collectionId, String collectionName, int entryId, IProgressListener listener) throws SnapshotException {
        while (entryId >= 0) {
            if (this.snapshot.isClass(entryId)) {
                return;
            }
            IInstance entry = (IInstance)this.snapshot.getObject(entryId);
            entryId = -1;
            int valueId = -1;
            int keyId = -1;
            boolean nextFieldProcessed = false;
            for (Field field : entry.getFields()) {
                if (!nextFieldProcessed && "next".equals(field.getName())) {
                    nextFieldProcessed = true;
                    if (field.getValue() == null) continue;
                    entryId = ((ObjectReference)field.getValue()).getObjectId();
                    continue;
                }
                if (field.getValue() == null || field.getType() != 2) continue;
                if (info.getEntryKeyField().equals(field.getName())) {
                    keyId = ((ObjectReference)field.getValue()).getObjectId();
                }
                if (!info.getEntryValueField().equals(field.getName())) continue;
                valueId = ((ObjectReference)field.getValue()).getObjectId();
            }
            hashEntries.add(new Entry(collectionId, collectionName, keyId, valueId));
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
    }

    static class Entry {
        int collectionId;
        int keyId;
        int valueId;
        String collectionName;
        String keyValue;
        String valueValue;

        public Entry(int collectionId, String collectionName, int keyId, int valueId) {
            this.collectionId = collectionId;
            this.collectionName = collectionName;
            this.keyId = keyId;
            this.valueId = valueId;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result
    implements IResultTable {
        private ISnapshot snapshot;
        private List<Entry> entries;
        private Map<String, Entry> key2entry;

        private Result(ISnapshot snapshot, List<Entry> entries) {
            this.snapshot = snapshot;
            this.entries = entries;
        }

        public ResultMetaData getResultMetaData() {
            return new ResultMetaData.Builder().addContext(new ContextProvider(Messages.HashEntriesQuery_Column_Key){

                public IContextObject getContext(Object row) {
                    return Result.this.getKey(row);
                }
            }).addContext(new ContextProvider(Messages.HashEntriesQuery_Column_Value){

                public IContextObject getContext(Object row) {
                    return Result.this.getValue(row);
                }
            }).build();
        }

        public Column[] getColumns() {
            return new Column[]{new Column(Messages.HashEntriesQuery_Column_Collection).sorting(Column.SortDirection.ASC), new Column(Messages.HashEntriesQuery_Column_Key), new Column(Messages.HashEntriesQuery_Column_Value)};
        }

        public Object getColumnValue(Object row, int columnIndex) {
            Entry entry = (Entry)row;
            switch (columnIndex) {
                case 0: {
                    return entry.collectionName;
                }
                case 1: {
                    if (entry.keyValue == null) {
                        entry.keyValue = this.resolve(entry.keyId);
                    }
                    return entry.keyValue;
                }
                case 2: {
                    if (entry.valueValue == null) {
                        entry.valueValue = this.resolve(entry.valueId);
                    }
                    return entry.valueValue;
                }
            }
            return null;
        }

        private String resolve(int objectId) {
            block4: {
                try {
                    if (objectId >= 0) break block4;
                    return HashEntriesQuery.NULL;
                }
                catch (SnapshotException e) {
                    throw new RuntimeException(e);
                }
            }
            IObject object = this.snapshot.getObject(objectId);
            String name = object.getClassSpecificName();
            if (name == null) {
                name = object.getTechnicalName();
            }
            return name;
        }

        public int getRowCount() {
            return this.entries.size();
        }

        public Object getRow(int rowId) {
            return this.entries.get(rowId);
        }

        public IContextObject getContext(final Object row) {
            return new IContextObject(){

                public int getObjectId() {
                    return ((Entry)row).collectionId;
                }
            };
        }

        private IContextObject getKey(Object row) {
            final int keyId = ((Entry)row).keyId;
            if (keyId >= 0) {
                return new IContextObject(){

                    public int getObjectId() {
                        return keyId;
                    }
                };
            }
            return null;
        }

        private IContextObject getValue(Object row) {
            final int valueId = ((Entry)row).valueId;
            if (valueId >= 0) {
                return new IContextObject(){

                    public int getObjectId() {
                        return valueId;
                    }
                };
            }
            return null;
        }

        public String getString(String key, IProgressListener listener) {
            this.prepare(listener);
            Entry entry = this.key2entry.get(key);
            if (entry == null) {
                return null;
            }
            if (entry.valueValue == null) {
                entry.valueValue = this.resolve(entry.valueId);
            }
            return entry.valueValue == HashEntriesQuery.NULL ? null : entry.valueValue;
        }

        public int getObjectId(String key, IProgressListener listener) {
            this.prepare(listener);
            Entry entry = this.key2entry.get(key);
            if (entry == null) {
                return -1;
            }
            return entry.keyId;
        }

        private synchronized void prepare(IProgressListener listener) {
            if (this.key2entry != null) {
                return;
            }
            this.key2entry = new HashMap<String, Entry>();
            for (Entry entry : this.entries) {
                if (entry.keyValue == null) {
                    entry.keyValue = this.resolve(entry.keyId);
                }
                this.key2entry.put(entry.keyValue, entry);
                if (!listener.isCanceled()) continue;
                throw new IProgressListener.OperationCanceledException();
            }
        }
    }
}

