/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.InspectionAssert;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="hash_set_values")
public class HashSetValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject hashSet;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String array_attribute;
    @Argument(isMandatory=false)
    public String key_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        InspectionAssert.heapFormatIsNot(this.snapshot, "phd");
        CollectionUtil.Info info = null;
        if (this.collection != null && this.hashSet.getClazz().doesExtend(this.collection)) {
            if (this.array_attribute == null || this.key_attribute == null) {
                String msg = Messages.HashSetValuesQuery_ErrorMsg_MissingArgument;
                throw new SnapshotException(msg);
            }
            info = new CollectionUtil.Info(this.collection, null, this.array_attribute, this.key_attribute, null);
        } else if (this.hashSet.getClazz().doesExtend("java.util.HashSet")) {
            info = CollectionUtil.getInfo(this.hashSet);
        } else {
            throw new IllegalArgumentException(MessageUtil.format((String)Messages.HashSetValuesQuery_ErrorMsg_NotAHashSet, (Object[])new Object[]{this.hashSet.getDisplayName()}));
        }
        ArrayInt hashEntries = new ArrayInt();
        String arrayField = info.getBackingArrayField();
        int p = arrayField.lastIndexOf(46);
        IInstance map = p < 0 ? (IInstance)this.hashSet : (IInstance)this.hashSet.resolveValue(arrayField.substring(0, p));
        Field table = map.getField(p < 0 ? arrayField : arrayField.substring(p + 1));
        int tableObjectId = ((ObjectReference)table.getValue()).getObjectId();
        int[] outbounds = this.snapshot.getOutboundReferentIds(tableObjectId);
        int ii = 0;
        while (ii < outbounds.length) {
            this.collectEntry(hashEntries, outbounds[ii], info, listener);
            ++ii;
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        return new ObjectListResult.Outbound(this.snapshot, hashEntries.toArray());
    }

    private void collectEntry(ArrayInt hashEntries, int entryId, CollectionUtil.Info info, IProgressListener listener) throws SnapshotException {
        while (entryId >= 0) {
            if (this.snapshot.isClass(entryId)) {
                return;
            }
            IInstance entry = (IInstance)this.snapshot.getObject(entryId);
            entryId = -1;
            Field next = entry.getField("next");
            if (next.getValue() != null) {
                entryId = ((ObjectReference)next.getValue()).getObjectId();
            }
            Field key = entry.getField(info.getEntryKeyField());
            hashEntries.add(((ObjectReference)key.getValue()).getObjectId());
            if (!listener.isCanceled()) continue;
            throw new IProgressListener.OperationCanceledException();
        }
    }
}

