/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Iterator;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Help;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="primitive_arrays_with_a_constant_value")
public class PrimitiveArraysWithAConstantValueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    @Help(value="The array objects. Only primitive arrays will be examined.")
    public IHeapObjectArgument objects;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.PrimitiveArraysWithAConstantValueQuery_SearchingArrayValues);
        ArrayInt result = new ArrayInt();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                IPrimitiveArray array;
                int length;
                IObject object;
                int objectId = nArray[n2];
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
                if (this.snapshot.isArray(objectId) && !((object = this.snapshot.getObject(objectId)) instanceof IObjectArray) && (length = (array = (IPrimitiveArray)object).getLength()) > 1) {
                    boolean allSame = true;
                    Object value0 = array.getValueAt(0);
                    int i = 1;
                    while (i < length) {
                        Object valueAt = array.getValueAt(i);
                        if (!valueAt.equals(value0)) {
                            allSame = false;
                            break;
                        }
                        ++i;
                    }
                    if (allSame) {
                        result.add(objectId);
                    }
                }
                ++n2;
            }
        }
        return new ObjectListResult.Inbound(this.snapshot, result.toArray());
    }
}

