/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.finalizer;

import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.CommonNameResolver;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="finalizer_thread")
@Category(value="__hidden__")
@Icon(value="/META-INF/icons/finalizer.gif")
public class FinalizerThreadQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] finalizerThreadObjects = FinalizerThreadQuery.getFinalizerThreads(this.snapshot);
        return new ObjectListResult.Outbound(this.snapshot, finalizerThreadObjects);
    }

    static int[] getFinalizerThreads(ISnapshot snapshot) throws Exception {
        Collection<IClass> finalizerThreadClasses = snapshot.getClassesByName("java.lang.ref.Finalizer$FinalizerThread", false);
        if (finalizerThreadClasses == null) {
            return FinalizerThreadQuery.getFinalizerThreads2(snapshot, Messages.FinalizerThreadQuery_FinalizerThread);
        }
        int[] a = FinalizerThreadQuery.getFinalizerThreads1(snapshot);
        int[] b = FinalizerThreadQuery.getFinalizerThreads2(snapshot, Messages.FinalizerThreadQuery_SecondaryFinalizer);
        int[] ret = new int[a.length + b.length];
        System.arraycopy(a, 0, ret, 0, a.length);
        System.arraycopy(b, 0, ret, a.length, b.length);
        return ret;
    }

    private static int[] getFinalizerThreads1(ISnapshot snapshot) throws SnapshotException, Exception {
        Collection<IClass> finalizerThreadClasses = snapshot.getClassesByName("java.lang.ref.Finalizer$FinalizerThread", false);
        if (finalizerThreadClasses == null) {
            throw new Exception(Messages.FinalizerThreadQuery_ErrorMsg_FinalizerThreadNotFound);
        }
        if (finalizerThreadClasses.size() != 1) {
            throw new Exception(Messages.FinalizerThreadQuery_ErrorMsg_MultipleThreads);
        }
        int[] finalizerThreadObjects = finalizerThreadClasses.iterator().next().getObjectIds();
        if (finalizerThreadObjects == null) {
            throw new Exception(Messages.FinalizerThreadQuery_ErrorMsg_FinalizerThreadInstanceNotFound);
        }
        if (finalizerThreadObjects.length != 1) {
            throw new Exception(Messages.FinalizerThreadQuery_ErrorMsg_MultipleFinalizerThreadClasses);
        }
        return finalizerThreadObjects;
    }

    private static int[] getFinalizerThreads2(ISnapshot snapshot, String finalizerThreadName) throws Exception {
        Collection<IClass> finalizerThreadClasses = snapshot.getClassesByName("java.lang.Thread", false);
        if (finalizerThreadClasses == null) {
            throw new Exception(Messages.FinalizerThreadQuery_ErrorMsg_ThreadClassNotFound);
        }
        if (finalizerThreadClasses.size() != 1) {
            throw new Exception(Messages.FinalizerThreadQuery_ErrorMsg_MultipleThreadClassesFound);
        }
        int[] finalizerThreadObjects = finalizerThreadClasses.iterator().next().getObjectIds();
        if (finalizerThreadObjects == null) {
            throw new Exception(Messages.FinalizerThreadQuery_ErrorMsg_ThreadInstanceNotFound);
        }
        int finalizerThreadObjectsLength = 0;
        int[] nArray = finalizerThreadObjects;
        int n = finalizerThreadObjects.length;
        int n2 = 0;
        while (n2 < n) {
            CommonNameResolver.ThreadResolver t = new CommonNameResolver.ThreadResolver();
            int objectId = nArray[n2];
            IObject o = snapshot.getObject(objectId);
            String name = t.resolve(o);
            if (name != null && name.equals(finalizerThreadName)) {
                finalizerThreadObjects[finalizerThreadObjectsLength++] = objectId;
            }
            ++n2;
        }
        int[] ret = new int[finalizerThreadObjectsLength];
        System.arraycopy(finalizerThreadObjects, 0, ret, 0, finalizerThreadObjectsLength);
        return ret;
    }
}

