/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.io.Serializable;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistogramRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String label;
    protected long numberOfObjects;
    protected long usedHeapSize;
    protected long retainedHeapSize;
    public static final transient Comparator<HistogramRecord> COMPARATOR_FOR_LABEL = new Comparator<HistogramRecord>(){

        @Override
        public int compare(HistogramRecord o1, HistogramRecord o2) {
            return o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
    };
    public static final transient Comparator<HistogramRecord> COMPARATOR_FOR_NUMBEROFOBJECTS = new Comparator<HistogramRecord>(){

        @Override
        public int compare(HistogramRecord o1, HistogramRecord o2) {
            long diff = o1.getNumberOfObjects() - o2.getNumberOfObjects();
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
    };
    public static final transient Comparator<HistogramRecord> COMPARATOR_FOR_USEDHEAPSIZE = new Comparator<HistogramRecord>(){

        @Override
        public int compare(HistogramRecord o1, HistogramRecord o2) {
            long diff = o1.getUsedHeapSize() - o2.getUsedHeapSize();
            return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
    };
    public static final transient Comparator<HistogramRecord> COMPARATOR_FOR_RETAINEDHEAPSIZE = new Comparator<HistogramRecord>(){

        @Override
        public int compare(HistogramRecord o1, HistogramRecord o2) {
            long diff;
            long retained_o1 = o1.getRetainedHeapSize();
            long retained_o2 = o2.getRetainedHeapSize();
            if (o1.getRetainedHeapSize() < 0L) {
                retained_o1 = -retained_o1;
            }
            if (o2.getRetainedHeapSize() < 0L) {
                retained_o2 = -retained_o2;
            }
            return (diff = retained_o1 - retained_o2) == 0L ? 0 : (diff > 0L ? 1 : -1);
        }
    };

    HistogramRecord() {
    }

    public HistogramRecord(String label) {
        this(label, 0L, 0L, 0L);
    }

    public HistogramRecord(String label, long numberOfObjects, long usedHeapSize, long retainedHeapSize) {
        this.label = label;
        this.numberOfObjects = numberOfObjects;
        this.usedHeapSize = usedHeapSize;
        this.retainedHeapSize = retainedHeapSize;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public long getNumberOfObjects() {
        return this.numberOfObjects;
    }

    public void setNumberOfObjects(long numberOfObjects) {
        this.numberOfObjects = numberOfObjects;
    }

    public void incNumberOfObjects() {
        ++this.numberOfObjects;
    }

    public void incNumberOfObjects(long inc) {
        this.numberOfObjects += inc;
    }

    public long getUsedHeapSize() {
        return this.usedHeapSize;
    }

    public void setUsedHeapSize(long usedHeapSize) {
        this.usedHeapSize = usedHeapSize;
    }

    public void incUsedHeapSize(long inc) {
        this.usedHeapSize += inc;
    }

    public long getRetainedHeapSize() {
        return this.retainedHeapSize;
    }

    public void setRetainedHeapSize(long retainedHeapSize) {
        this.retainedHeapSize = retainedHeapSize;
    }

    public void incRetainedHeapSize(long inc) {
        this.retainedHeapSize += inc;
    }

    public static Comparator<HistogramRecord> reverseComparator(final Comparator<HistogramRecord> comparator) {
        return new Comparator<HistogramRecord>(){

            @Override
            public int compare(HistogramRecord o1, HistogramRecord o2) {
                return comparator.compare(o2, o1);
            }
        };
    }
}

