/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.HashMapLongObject;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.hprof.AbstractParser;
import org.eclipse.mat.hprof.IHprofParserHandler;
import org.eclipse.mat.hprof.Messages;
import org.eclipse.mat.parser.IPreliminaryIndex;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexManager;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XGCRootInfo;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HprofParserHandlerImpl
implements IHprofParserHandler {
    private AbstractParser.Version version;
    private XSnapshotInfo info = new XSnapshotInfo();
    private HashMapLongObject<String> constantPool = new HashMapLongObject(10000);
    private Map<String, List<ClassImpl>> classesByName = new HashMap<String, List<ClassImpl>>();
    private HashMapLongObject<ClassImpl> classesByAddress = new HashMapLongObject();
    private HashMapLongObject<List<XGCRootInfo>> gcRoots = new HashMapLongObject(200);
    private IndexWriter.Identifier identifiers = null;
    private IndexWriter.IntArray1NWriter outbound = null;
    private IndexWriter.IntIndexCollector object2classId = null;
    private IndexWriter.LongIndexCollector object2position = null;
    private IndexWriter.IntIndexCollectorUncompressed array2size = null;
    private Set<Long> requiredArrayClassIDs = new HashSet<Long>();
    private Set<Integer> requiredPrimitiveArrays = new HashSet<Integer>();
    private HashMapLongObject<HashMapLongObject<List<XGCRootInfo>>> threadAddressToLocals = new HashMapLongObject();

    @Override
    public void beforePass1(XSnapshotInfo snapshotInfo) throws IOException {
        this.info = snapshotInfo;
        this.identifiers = new IndexWriter.Identifier();
    }

    @Override
    public void beforePass2(IProgressListener monitor) throws IOException, SnapshotException {
        this.identifiers.add(0L);
        this.identifiers.sort();
        if (!this.requiredArrayClassIDs.isEmpty() || !this.requiredPrimitiveArrays.isEmpty()) {
            this.createRequiredFakeClasses();
        }
        monitor.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.HprofParserHandlerImpl_HeapContainsObjects, (Object[])new Object[]{this.info.getPath(), this.identifiers.size()}), null);
        int maxClassId = 0;
        Iterator e = this.classesByAddress.values();
        while (e.hasNext()) {
            ClassImpl clazz = (ClassImpl)e.next();
            int index = this.identifiers.reverse(clazz.getObjectAddress());
            clazz.setObjectId(index);
            maxClassId = Math.max(maxClassId, index);
            clazz.setHeapSizePerInstance(this.calculateInstanceSize(clazz));
            clazz.setUsedHeapSize(this.calculateClassSize(clazz));
        }
        this.outbound = new IndexWriter.IntArray1NWriter(this.identifiers.size(), IndexManager.Index.OUTBOUND.getFile(String.valueOf(this.info.getPrefix()) + "temp."));
        this.object2classId = new IndexWriter.IntIndexCollector(this.identifiers.size(), IndexWriter.mostSignificantBit((int)maxClassId));
        this.object2position = new IndexWriter.LongIndexCollector(this.identifiers.size(), IndexWriter.mostSignificantBit((long)new File(this.info.getPath()).length()));
        this.array2size = new IndexWriter.IntIndexCollectorUncompressed(this.identifiers.size());
        List<ClassImpl> javaLangClasses = this.classesByName.get("java.lang.Class");
        ClassImpl javaLangClass = javaLangClasses.get(0);
        javaLangClass.setObjectId(this.identifiers.reverse(javaLangClass.getObjectAddress()));
        Iterator e2 = this.classesByAddress.values();
        while (e2.hasNext()) {
            ClassImpl clazz = (ClassImpl)e2.next();
            clazz.setSuperClassIndex(this.identifiers.reverse(clazz.getSuperClassAddress()));
            clazz.setClassLoaderIndex(this.identifiers.reverse(clazz.getClassLoaderAddress()));
            if (clazz.getClassLoaderId() < 0) {
                clazz.setClassLoaderAddress(0L);
                clazz.setClassLoaderIndex(this.identifiers.reverse(0L));
            }
            clazz.setClassInstance(javaLangClass);
            javaLangClass.addInstance(clazz.getUsedHeapSize());
            ClassImpl superclass = this.lookupClass(clazz.getSuperClassAddress());
            if (superclass != null) {
                superclass.addSubClass(clazz);
            }
            this.object2classId.set(clazz.getObjectId(), clazz.getClazz().getObjectId());
            this.outbound.log(this.identifiers, clazz.getObjectId(), clazz.getReferences());
        }
        ClassImpl classLoaderClass = this.classesByName.get("java.lang.ClassLoader").get(0);
        IHprofParserHandler.HeapObject heapObject = new IHprofParserHandler.HeapObject(this.identifiers.reverse(0L), 0L, classLoaderClass, classLoaderClass.getHeapSizePerInstance());
        heapObject.references.add(classLoaderClass.getObjectAddress());
        this.addObject(heapObject, 0L);
        this.constantPool = null;
    }

    private void createRequiredFakeClasses() throws IOException, SnapshotException {
        long nextObjectAddress = 0L;
        if (!this.requiredArrayClassIDs.isEmpty()) {
            for (long arrayClassID : this.requiredArrayClassIDs) {
                ClassImpl arrayType = this.lookupClass(arrayClassID);
                if (arrayType != null) continue;
                int objectId = this.identifiers.reverse(arrayClassID);
                if (objectId >= 0) {
                    String msg = MessageUtil.format((String)Messages.HprofParserHandlerImpl_Error_ExpectedClassSegment, (Object[])new Object[]{Long.toHexString(arrayClassID)});
                    throw new SnapshotException(msg);
                }
                arrayType = new ClassImpl(arrayClassID, "unknown-class[]", 0L, 0L, new Field[0], new FieldDescriptor[0]);
                this.addClass(arrayType, -1L);
            }
        }
        this.requiredArrayClassIDs = null;
        if (!this.requiredPrimitiveArrays.isEmpty()) {
            for (Integer arrayType : this.requiredPrimitiveArrays) {
                String name = IPrimitiveArray.TYPE[arrayType];
                IClass clazz = this.lookupClassByName(name, true);
                if (clazz != null) continue;
                while (this.identifiers.reverse(++nextObjectAddress) >= 0) {
                }
                clazz = new ClassImpl(nextObjectAddress, name, 0L, 0L, new Field[0], new FieldDescriptor[0]);
                this.addClass((ClassImpl)clazz, -1L);
            }
        }
        this.identifiers.sort();
    }

    private int calculateInstanceSize(ClassImpl clazz) {
        if (!clazz.isArrayType()) {
            if (clazz.getSuperClassAddress() == 0L) {
                return 2 * this.info.getIdentifierSize();
            }
            ClassImpl superClass = (ClassImpl)this.classesByAddress.get(clazz.getSuperClassAddress());
            int ownFieldsSize = 0;
            for (FieldDescriptor field : clazz.getFieldDescriptors()) {
                ownFieldsSize += this.sizeOf(field);
            }
            return this.alignUpTo8(ownFieldsSize + this.calculateInstanceSize(superClass));
        }
        return this.info.getIdentifierSize();
    }

    private int calculateClassSize(ClassImpl clazz) {
        int staticFieldsSize = 0;
        for (Field field : clazz.getStaticFields()) {
            staticFieldsSize += this.sizeOf((FieldDescriptor)field);
        }
        return this.alignUpTo8(staticFieldsSize);
    }

    private int sizeOf(FieldDescriptor field) {
        int type = field.getType();
        if (type == 2) {
            return this.info.getIdentifierSize();
        }
        return IPrimitiveArray.ELEMENT_SIZE[type];
    }

    private int alignUpTo8(int n) {
        int r = n % 8;
        return r == 0 ? n : n + 8 - r;
    }

    @Override
    public IIndexReader.IOne2LongIndex fillIn(IPreliminaryIndex index) throws IOException {
        ClassImpl[] allClasses;
        ClassImpl[] classImplArray = allClasses = (ClassImpl[])this.classesByAddress.getAllValues((Object[])new ClassImpl[0]);
        int n = allClasses.length;
        int n2 = 0;
        while (n2 < n) {
            ClassImpl clazz = classImplArray[n2];
            if (clazz.getClassLoaderAddress() == 0L && !clazz.isArrayType() && !this.gcRoots.containsKey(clazz.getObjectAddress())) {
                this.addGCRoot(clazz.getObjectAddress(), 0L, 2);
            }
            ++n2;
        }
        HashMapIntObject classesById = new HashMapIntObject(this.classesByAddress.size());
        Iterator iter = this.classesByAddress.values();
        while (iter.hasNext()) {
            ClassImpl clazz = (ClassImpl)iter.next();
            classesById.put(clazz.getObjectId(), (Object)clazz);
        }
        index.setClassesById(classesById);
        index.setGcRoots(this.map2ids(this.gcRoots));
        HashMapIntObject thread2objects2roots = new HashMapIntObject();
        Iterator iter2 = this.threadAddressToLocals.entries();
        while (iter2.hasNext()) {
            HashMapIntObject<List<XGCRootInfo>> objects2roots;
            HashMapLongObject.Entry entry = (HashMapLongObject.Entry)iter2.next();
            int threadId = this.identifiers.reverse(entry.getKey());
            if (threadId < 0 || (objects2roots = this.map2ids((HashMapLongObject<List<XGCRootInfo>>)((HashMapLongObject)entry.getValue()))).isEmpty()) continue;
            thread2objects2roots.put(threadId, objects2roots);
        }
        index.setThread2objects2roots(thread2objects2roots);
        index.setIdentifiers((IIndexReader.IOne2LongIndex)this.identifiers);
        index.setArray2size(this.array2size.writeTo(IndexManager.Index.A2SIZE.getFile(String.valueOf(this.info.getPrefix()) + "temp.")));
        index.setObject2classId((IIndexReader.IOne2OneIndex)this.object2classId);
        index.setOutbound(this.outbound.flush());
        return this.object2position.writeTo(new File(String.valueOf(this.info.getPrefix()) + "temp.o2hprof.index"));
    }

    private HashMapIntObject<List<XGCRootInfo>> map2ids(HashMapLongObject<List<XGCRootInfo>> source) {
        HashMapIntObject sink = new HashMapIntObject();
        Iterator iter = source.entries();
        while (iter.hasNext()) {
            HashMapLongObject.Entry entry = (HashMapLongObject.Entry)iter.next();
            int idx = this.identifiers.reverse(entry.getKey());
            if (idx < 0) continue;
            Iterator roots = ((List)entry.getValue()).iterator();
            while (roots.hasNext()) {
                XGCRootInfo root = (XGCRootInfo)roots.next();
                root.setObjectId(idx);
                if (root.getContextAddress() == 0L) continue;
                int contextId = this.identifiers.reverse(root.getContextAddress());
                if (contextId < 0) {
                    roots.remove();
                    continue;
                }
                root.setContextId(contextId);
            }
            sink.put(idx, (Object)((List)entry.getValue()));
        }
        return sink;
    }

    @Override
    public void cancel() {
        if (this.constantPool != null) {
            this.constantPool.clear();
        }
        if (this.outbound != null) {
            this.outbound.cancel();
        }
    }

    @Override
    public void addProperty(String name, String value) throws IOException {
        if ("VERSION".equals(name)) {
            this.version = AbstractParser.Version.valueOf(value);
            this.info.setProperty("hprof.version", (Serializable)((Object)this.version.name()));
        } else if ("ID_SIZE".equals(name)) {
            this.info.setIdentifierSize(Integer.parseInt(value));
        } else if ("CREATION_DATE".equals(name)) {
            this.info.setCreationDate(new Date(Long.parseLong(value)));
        }
    }

    @Override
    public void addGCRoot(long id, long referrer, int rootType) {
        if (referrer != 0L) {
            ArrayList<XGCRootInfo> gcRootInfo;
            HashMapLongObject localAddressToRootInfo = (HashMapLongObject)this.threadAddressToLocals.get(referrer);
            if (localAddressToRootInfo == null) {
                localAddressToRootInfo = new HashMapLongObject();
                this.threadAddressToLocals.put(referrer, (Object)localAddressToRootInfo);
            }
            if ((gcRootInfo = (ArrayList<XGCRootInfo>)localAddressToRootInfo.get(id)) == null) {
                gcRootInfo = new ArrayList<XGCRootInfo>(1);
                localAddressToRootInfo.put(id, gcRootInfo);
            }
            gcRootInfo.add(new XGCRootInfo(id, referrer, rootType));
            return;
        }
        ArrayList<XGCRootInfo> r = (ArrayList<XGCRootInfo>)this.gcRoots.get(id);
        if (r == null) {
            r = new ArrayList<XGCRootInfo>(3);
            this.gcRoots.put(id, r);
        }
        r.add(new XGCRootInfo(id, referrer, rootType));
    }

    @Override
    public void addClass(ClassImpl clazz, long filePosition) throws IOException {
        this.identifiers.add(clazz.getObjectAddress());
        this.classesByAddress.put(clazz.getObjectAddress(), (Object)clazz);
        List<ClassImpl> list = this.classesByName.get(clazz.getName());
        if (list == null) {
            list = new ArrayList<ClassImpl>();
            this.classesByName.put(clazz.getName(), list);
        }
        list.add(clazz);
    }

    @Override
    public void addObject(IHprofParserHandler.HeapObject object, long filePosition) throws IOException {
        int index = object.objectId;
        HashMapLongObject localVars = (HashMapLongObject)this.threadAddressToLocals.get(object.objectAddress);
        if (localVars != null) {
            IteratorLong e = localVars.keys();
            while (e.hasNext()) {
                object.references.add(e.next());
            }
        }
        this.outbound.log(this.identifiers, index, object.references);
        int classIndex = object.clazz.getObjectId();
        object.clazz.addInstance(object.usedHeapSize);
        this.object2classId.set(index, classIndex);
        this.object2position.set(index, filePosition);
        if (object.isArray) {
            this.array2size.set(index, object.usedHeapSize);
        }
    }

    @Override
    public void reportInstance(long id, long filePosition) {
        this.identifiers.add(id);
    }

    @Override
    public void reportRequiredObjectArray(long arrayClassID) {
        this.requiredArrayClassIDs.add(arrayClassID);
    }

    @Override
    public void reportRequiredPrimitiveArray(int arrayType) {
        this.requiredPrimitiveArrays.add(arrayType);
    }

    @Override
    public int getIdentifierSize() {
        return this.info.getIdentifierSize();
    }

    @Override
    public HashMapLongObject<String> getConstantPool() {
        return this.constantPool;
    }

    public ClassImpl lookupClass(long classId) {
        return (ClassImpl)this.classesByAddress.get(classId);
    }

    @Override
    public IClass lookupClassByName(String name, boolean failOnMultipleInstances) {
        List<ClassImpl> list = this.classesByName.get(name);
        if (list == null) {
            return null;
        }
        if (failOnMultipleInstances && list.size() != 1) {
            throw new RuntimeException(MessageUtil.format((String)Messages.HprofParserHandlerImpl_Error_MultipleClassInstancesExist, (Object[])new Object[]{name}));
        }
        return (IClass)list.get(0);
    }

    @Override
    public IClass lookupClassByIndex(int objIndex) {
        return this.lookupClass(this.identifiers.get(objIndex));
    }

    @Override
    public List<IClass> resolveClassHierarchy(long classId) {
        ArrayList<IClass> answer = new ArrayList<IClass>();
        ClassImpl clazz = (ClassImpl)this.classesByAddress.get(classId);
        answer.add((IClass)clazz);
        while (clazz.hasSuperClass()) {
            clazz = (ClassImpl)this.classesByAddress.get(clazz.getSuperClassAddress());
            answer.add((IClass)clazz);
        }
        return answer;
    }

    @Override
    public int mapAddressToId(long address) {
        return this.identifiers.reverse(address);
    }

    @Override
    public XSnapshotInfo getSnapshotInfo() {
        return this.info;
    }
}

