/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntCompressed;
import org.eclipse.mat.collect.ArrayLongCompressed;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexWriter;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.io.SimpleBufferedRandomAccessInputStream;

public abstract class IndexReader {
    public static final boolean DEBUG = false;

    static class InboundReader
    extends IntIndex1NSortedReader
    implements IIndexReader.IOne2ManyObjectsIndex {
        public InboundReader(File indexFile) throws IOException {
            super(indexFile);
        }

        public InboundReader(File indexFile, IIndexReader.IOne2OneIndex header, IIndexReader.IOne2OneIndex body) throws IOException {
            super(indexFile, header, body);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getObjectsOf(Serializable key) throws SnapshotException, IOException {
            if (key == null) {
                return new int[0];
            }
            int[] pos = (int[])key;
            InboundReader inboundReader = this;
            synchronized (inboundReader) {
                return this.body.getNext(pos[0], pos[1]);
            }
        }
    }

    static class IntIndex1NReader
    implements IIndexReader.IOne2ManyIndex {
        File indexFile;
        SimpleBufferedRandomAccessInputStream in;
        IntIndexReader header;
        IntIndexReader body;

        public IntIndex1NReader(File indexFile) throws IOException {
            try {
                this.indexFile = indexFile;
                this.open();
                long indexLength = indexFile.length();
                this.in.seek(indexLength - 8L);
                long divider = this.in.readLong();
                this.header = new IntIndexReader(this.in, divider, indexLength - divider - 8L);
                this.body = new IntIndexReader(this.in, 0L, divider);
                this.body.LOCK = this.header.LOCK;
            }
            catch (RuntimeException e) {
                this.close();
                throw e;
            }
        }

        public IntIndex1NReader(File indexFile, IIndexReader.IOne2OneIndex header, IIndexReader.IOne2OneIndex body) {
            this.indexFile = indexFile;
            this.header = (IntIndexReader)header;
            this.body = (IntIndexReader)body;
            this.body.LOCK = this.header.LOCK;
            this.open();
        }

        public int[] get(int index) {
            int p = this.header.get(index);
            int length = this.body.get(p);
            return this.body.getNext(p + 1, length);
        }

        protected synchronized void open() {
            try {
                if (this.in == null) {
                    this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
                    if (this.header != null) {
                        this.header.in = this.in;
                    }
                    if (this.body != null) {
                        this.body.in = this.in;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized void close() {
            this.header.unload();
            this.body.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.in = null;
                        if (this.header != null) {
                            this.header.in = null;
                        }
                        if (this.body != null) {
                            this.body.in = null;
                        }
                    }
                }
                finally {
                    this.in = null;
                    if (this.header != null) {
                        this.header.in = null;
                    }
                    if (this.body != null) {
                        this.body.in = null;
                    }
                }
            }
        }

        public void unload() throws IOException {
            this.header.unload();
            this.body.unload();
        }

        public int size() {
            return this.header.size();
        }

        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }

    public static class IntIndex1NSortedReader
    extends IntIndex1NReader {
        public IntIndex1NSortedReader(File indexFile) throws IOException {
            super(indexFile);
        }

        public IntIndex1NSortedReader(File indexFile, IIndexReader.IOne2OneIndex header, IIndexReader.IOne2OneIndex body) throws IOException {
            super(indexFile, header, body);
        }

        public int[] get(int index) {
            int[] p = null;
            if (index + 1 < this.header.size()) {
                if ((p = this.header.getNext(index++, 2))[0] == 0) {
                    return new int[0];
                }
                ++index;
                while (p[1] < p[0] && index < this.header.size()) {
                    p[1] = this.header.get(index);
                    ++index;
                }
                if (p[1] < p[0]) {
                    p[1] = this.body.size() + 1;
                }
            } else {
                int[] nArray = new int[2];
                nArray[0] = this.header.get(index);
                p = nArray;
                if (p[0] == 0) {
                    return new int[0];
                }
                p[1] = this.body.size() + 1;
            }
            return this.body.getNext(p[0] - 1, p[1] - p[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntIndexReader
    extends IndexWriter.IntIndex<SoftReference<ArrayIntCompressed>>
    implements IIndexReader.IOne2OneIndex {
        public Object LOCK = new Object();
        File indexFile;
        public SimpleBufferedRandomAccessInputStream in;
        long[] pageStart;

        public IntIndexReader(File indexFile, IndexWriter.Pages<SoftReference<ArrayIntCompressed>> pages, int size, int pageSize, long[] pageStart) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = pages;
            this.indexFile = indexFile;
            this.pageStart = pageStart;
            if (indexFile != null) {
                this.open();
            }
        }

        public IntIndexReader(File indexFile) throws IOException {
            this(new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(indexFile, "r")), 0L, indexFile.length());
            this.indexFile = indexFile;
        }

        public IntIndexReader(SimpleBufferedRandomAccessInputStream in, long start, long length) throws IOException {
            this.in = in;
            this.in.seek(start + length - 8L);
            int pageSize = this.in.readInt();
            int size = this.in.readInt();
            this.init(size, pageSize);
            int pages = size / pageSize + (size % pageSize > 0 ? 2 : 1);
            this.pageStart = new long[pages];
            this.in.seek(start + length - 8L - (long)(this.pageStart.length * 8));
            this.in.readLongArray(this.pageStart);
        }

        private synchronized void open() {
            try {
                if (this.in != null) {
                    return;
                }
                if (this.indexFile == null) {
                    throw new IOException(Messages.IndexReader_Error_IndexIsEmbedded);
                }
                this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public synchronized void close() {
            this.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.in = null;
                    }
                }
                finally {
                    this.in = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ArrayIntCompressed getPage(int page) {
            ArrayIntCompressed array;
            SoftReference ref = (SoftReference)this.pages.get(page);
            ArrayIntCompressed arrayIntCompressed = array = ref == null ? null : (ArrayIntCompressed)ref.get();
            if (array == null) {
                Object object = this.LOCK;
                synchronized (object) {
                    ref = (SoftReference)this.pages.get(page);
                    ArrayIntCompressed arrayIntCompressed2 = array = ref == null ? null : (ArrayIntCompressed)ref.get();
                    if (array == null) {
                        try {
                            byte[] buffer = null;
                            this.in.seek(this.pageStart[page]);
                            buffer = new byte[(int)(this.pageStart[page + 1] - this.pageStart[page])];
                            if (this.in.read(buffer) != buffer.length) {
                                throw new IOException();
                            }
                            array = new ArrayIntCompressed(buffer);
                            IndexWriter.Pages pages = this.pages;
                            synchronized (pages) {
                                this.pages.put(page, new SoftReference<ArrayIntCompressed>(array));
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return array;
        }

        @Override
        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }

    public static class LongIndex1NReader
    implements IIndexReader {
        File indexFile;
        SimpleBufferedRandomAccessInputStream in;
        IntIndexReader header;
        LongIndexReader body;

        public LongIndex1NReader(File indexFile) throws IOException {
            this.indexFile = indexFile;
            this.open();
            long indexLength = indexFile.length();
            this.in.seek(indexLength - 8L);
            long divider = this.in.readLong();
            this.header = new IntIndexReader(this.in, divider, indexLength - divider - 8L);
            this.body = new LongIndexReader(this.in, 0L, divider);
            this.body.LOCK = this.header.LOCK;
        }

        public long[] get(int index) {
            int p = this.header.get(index);
            if (p == 0) {
                return new long[0];
            }
            int length = (int)this.body.get(p - 1);
            return this.body.getNext(p, length);
        }

        protected synchronized void open() {
            try {
                if (this.in == null) {
                    this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
                    if (this.header != null) {
                        this.header.in = this.in;
                    }
                    if (this.body != null) {
                        this.body.in = this.in;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public synchronized void close() {
            this.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.body.in = null;
                        this.header.in = null;
                        this.in = null;
                    }
                }
                finally {
                    this.body.in = null;
                    this.header.in = null;
                    this.in = null;
                }
            }
        }

        public void unload() {
            this.header.unload();
            this.body.unload();
        }

        public int size() {
            return this.header.size();
        }

        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongIndexReader
    extends IndexWriter.LongIndex
    implements IIndexReader.IOne2LongIndex {
        Object LOCK = new Object();
        File indexFile;
        SimpleBufferedRandomAccessInputStream in;
        long[] pageStart;

        public LongIndexReader(File indexFile, HashMapIntObject<Object> pages, int size, int pageSize, long[] pageStart) throws IOException {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = pages;
            this.indexFile = indexFile;
            this.pageStart = pageStart;
            this.open();
        }

        public LongIndexReader(File indexFile) throws IOException {
            this(new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(indexFile, "r")), 0L, indexFile.length());
            this.indexFile = indexFile;
            this.open();
        }

        protected LongIndexReader(SimpleBufferedRandomAccessInputStream in, long start, long length) throws IOException {
            this.in = in;
            this.in.seek(start + length - 8L);
            int pageSize = this.in.readInt();
            int size = this.in.readInt();
            this.init(size, pageSize);
            int pages = size / pageSize + (size % pageSize > 0 ? 2 : 1);
            this.pageStart = new long[pages];
            this.in.seek(start + length - 8L - (long)(this.pageStart.length * 8));
            this.in.readLongArray(this.pageStart);
        }

        private synchronized void open() throws IOException {
            if (this.in != null) {
                return;
            }
            if (this.indexFile == null) {
                throw new IOException(Messages.IndexReader_Error_IndexIsEmbedded);
            }
            this.in = new SimpleBufferedRandomAccessInputStream(new RandomAccessFile(this.indexFile, "r"));
        }

        @Override
        public synchronized void close() {
            this.unload();
            if (this.in != null) {
                try {
                    try {
                        this.in.close();
                    }
                    catch (IOException iOException) {
                        this.in = null;
                    }
                }
                finally {
                    this.in = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected ArrayLongCompressed getPage(int page) {
            ArrayLongCompressed array;
            SoftReference ref = (SoftReference)this.pages.get(page);
            ArrayLongCompressed arrayLongCompressed = array = ref == null ? null : (ArrayLongCompressed)ref.get();
            if (array == null) {
                Object object = this.LOCK;
                synchronized (object) {
                    ref = (SoftReference)this.pages.get(page);
                    ArrayLongCompressed arrayLongCompressed2 = array = ref == null ? null : (ArrayLongCompressed)ref.get();
                    if (array == null) {
                        try {
                            byte[] buffer = null;
                            this.in.seek(this.pageStart[page]);
                            buffer = new byte[(int)(this.pageStart[page + 1] - this.pageStart[page])];
                            if (this.in.read(buffer) != buffer.length) {
                                throw new IOException();
                            }
                            array = new ArrayLongCompressed(buffer);
                            HashMapIntObject hashMapIntObject = this.pages;
                            synchronized (hashMapIntObject) {
                                this.pages.put(page, new SoftReference<ArrayLongCompressed>(array));
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            return array;
        }

        @Override
        public void delete() {
            this.close();
            if (this.indexFile != null) {
                this.indexFile.delete();
            }
        }
    }
}

