/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.index;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.ArrayIntCompressed;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.collect.ArrayLongCompressed;
import org.eclipse.mat.collect.ArrayUtils;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.collect.HashMapIntLong;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.collect.IteratorInt;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.SetInt;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.index.IndexReader;
import org.eclipse.mat.parser.io.BitInputStream;
import org.eclipse.mat.parser.io.BitOutputStream;
import org.eclipse.mat.util.IProgressListener;

public abstract class IndexWriter {
    public static final int PAGE_SIZE_INT = 1000000;
    public static final int PAGE_SIZE_LONG = 500000;

    public static long[] copyOf(long[] original, int newLength) {
        long[] copy = new long[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static int mostSignificantBit(int x) {
        int length = 0;
        if ((x & 0xFFFF0000) != 0) {
            length += 16;
            x >>= 16;
        }
        if ((x & 0xFF00) != 0) {
            length += 8;
            x >>= 8;
        }
        if ((x & 0xF0) != 0) {
            length += 4;
            x >>= 4;
        }
        if ((x & 0xC) != 0) {
            length += 2;
            x >>= 2;
        }
        if ((x & 2) != 0) {
            ++length;
            x >>= 1;
        }
        if ((x & 1) != 0) {
            ++length;
        }
        return length - 1;
    }

    public static int mostSignificantBit(long x) {
        long lead = x >>> 32;
        return lead == 0L ? IndexWriter.mostSignificantBit((int)x) : 32 + IndexWriter.mostSignificantBit((int)lead);
    }

    public static class Identifier
    implements IIndexReader.IOne2LongIndex {
        long[] identifiers;
        int size;

        public void add(long id) {
            if (this.identifiers == null) {
                this.identifiers = new long[10000];
                this.size = 0;
            }
            if (this.size + 1 > this.identifiers.length) {
                int newCapacity = this.identifiers.length * 3 / 2 + 1;
                if (newCapacity < this.size + 1) {
                    newCapacity = this.size + 1;
                }
                this.identifiers = IndexWriter.copyOf(this.identifiers, newCapacity);
            }
            this.identifiers[this.size++] = id;
        }

        public void sort() {
            Arrays.sort(this.identifiers, 0, this.size);
        }

        public int size() {
            return this.size;
        }

        public long get(int index) {
            if (index < 0 || index >= this.size) {
                throw new IndexOutOfBoundsException();
            }
            return this.identifiers[index];
        }

        public int reverse(long value) {
            int low = 0;
            int high = this.size - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                long midVal = this.identifiers[mid];
                if (midVal < value) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public IteratorLong iterator() {
            return new IteratorLong(){
                int index = 0;

                public boolean hasNext() {
                    return this.index < Identifier.this.size;
                }

                public long next() {
                    return Identifier.this.identifiers[this.index++];
                }
            };
        }

        public long[] getNext(int index, int length) {
            long[] answer = new long[length];
            int ii = 0;
            while (ii < length) {
                answer[ii] = this.identifiers[index + ii];
                ++ii;
            }
            return answer;
        }

        public void close() throws IOException {
        }

        public void delete() {
            this.identifiers = null;
        }

        public void unload() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    public static class InboundWriter {
        int size;
        File indexFile;
        int bitLength;
        int pageSize;
        BitOutputStream[] segments;
        int[] segmentSizes;

        public InboundWriter(int size, File indexFile) throws IOException {
            this.size = size;
            this.indexFile = indexFile;
            int requiredSegments = size / 500000 + 1;
            int segments = 1;
            while (segments < requiredSegments) {
                segments <<= 1;
            }
            this.bitLength = IndexWriter.mostSignificantBit(size) + 1;
            this.pageSize = size / segments + 1;
            this.segments = new BitOutputStream[segments];
            this.segmentSizes = new int[segments];
        }

        public void log(int objectIndex, int refIndex, boolean isPseudo) throws IOException {
            int segment = objectIndex / this.pageSize;
            if (this.segments[segment] == null) {
                File segmentFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + segment + ".log");
                this.segments[segment] = new BitOutputStream(new FileOutputStream(segmentFile));
            }
            this.segments[segment].writeBit(isPseudo ? 1 : 0);
            this.segments[segment].writeInt(objectIndex, this.bitLength);
            this.segments[segment].writeInt(refIndex, this.bitLength);
            int n = segment;
            this.segmentSizes[n] = this.segmentSizes[n] + 1;
        }

        public IIndexReader.IOne2ManyObjectsIndex flush(IProgressListener monitor, KeyWriter keyWriter) throws IOException {
            IndexReader.InboundReader inboundReader;
            this.close();
            int[] header = new int[this.size];
            DataOutputStream index = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.indexFile), 262144));
            BitInputStream segmentIn = null;
            try {
                IntIndexStreamer body = new IntIndexStreamer();
                body.openStream(index, 0L);
                int segment = 0;
                while (segment < this.segments.length) {
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    File segmentFile = new File(String.valueOf(this.indexFile.getAbsolutePath()) + segment + ".log");
                    if (segmentFile.exists()) {
                        segmentIn = new BitInputStream(new FileInputStream(segmentFile));
                        int[] objIndex = new int[this.segmentSizes[segment]];
                        int[] refIndex = new int[this.segmentSizes[segment]];
                        int ii = 0;
                        while (ii < this.segmentSizes[segment]) {
                            boolean isPseudo = segmentIn.readBit() == 1;
                            objIndex[ii] = segmentIn.readInt(this.bitLength);
                            refIndex[ii] = segmentIn.readInt(this.bitLength);
                            if (isPseudo) {
                                refIndex[ii] = -1 - refIndex[ii];
                            }
                            ++ii;
                        }
                        segmentIn.close();
                        segmentIn = null;
                        if (monitor.isCanceled()) {
                            throw new IProgressListener.OperationCanceledException();
                        }
                        segmentFile.delete();
                        segmentFile = null;
                        this.processSegment(monitor, keyWriter, header, body, objIndex, refIndex);
                    }
                    ++segment;
                }
                long divider = body.closeStream();
                IIndexReader.IOne2OneIndex headerIndex = new IntIndexStreamer().writeTo(index, divider, header);
                index.writeLong(divider);
                index.flush();
                index.close();
                index = null;
                inboundReader = new IndexReader.InboundReader(this.indexFile, headerIndex, body.getReader(null));
            }
            catch (Throwable throwable) {
                try {
                    if (index != null) {
                        index.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (segmentIn != null) {
                        segmentIn.close();
                    }
                }
                catch (IOException iOException) {}
                if (monitor.isCanceled()) {
                    this.cancel();
                }
                throw throwable;
            }
            try {
                if (index != null) {
                    index.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (segmentIn != null) {
                    segmentIn.close();
                }
            }
            catch (IOException iOException) {}
            if (monitor.isCanceled()) {
                this.cancel();
            }
            return inboundReader;
        }

        private void processSegment(IProgressListener monitor, KeyWriter keyWriter, int[] header, IntIndexStreamer body, int[] objIndex, int[] refIndex) throws IOException {
            ArrayUtils.sort((int[])objIndex, (int[])refIndex);
            int start = 0;
            int previous = -1;
            int ii = 0;
            while (ii <= objIndex.length) {
                if (ii == 0) {
                    start = ii;
                    previous = objIndex[ii];
                } else if (ii == objIndex.length || previous != objIndex[ii]) {
                    if (monitor.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                    header[previous] = body.size() + 1;
                    this.processObject(keyWriter, header, body, previous, refIndex, start, ii);
                    if (ii < objIndex.length) {
                        previous = objIndex[ii];
                        start = ii;
                    }
                }
                ++ii;
            }
        }

        private void processObject(KeyWriter keyWriter, int[] header, IntIndexStreamer body, int objectId, int[] refIndex, int fromIndex, int toIndex) throws IOException {
            Arrays.sort(refIndex, fromIndex, toIndex);
            int endPseudo = fromIndex;
            if (toIndex - fromIndex > 100000) {
                BitField duplicates = new BitField(this.size);
                int jj = fromIndex;
                while (jj < toIndex) {
                    if (refIndex[jj] >= 0) break;
                    ++endPseudo;
                    refIndex[jj] = -refIndex[jj] - 1;
                    if (!duplicates.get(refIndex[jj])) {
                        body.add(refIndex[jj]);
                        duplicates.set(refIndex[jj]);
                    }
                    ++jj;
                }
                while (jj < toIndex) {
                    if (!(jj != fromIndex && refIndex[jj - 1] == refIndex[jj] || duplicates.get(refIndex[jj]))) {
                        body.add(refIndex[jj]);
                    }
                    ++jj;
                }
            } else {
                SetInt duplicates = new SetInt(toIndex - fromIndex);
                int jj = fromIndex;
                while (jj < toIndex) {
                    if (refIndex[jj] >= 0) break;
                    ++endPseudo;
                    refIndex[jj] = -refIndex[jj] - 1;
                    if (duplicates.add(refIndex[jj])) {
                        body.add(refIndex[jj]);
                    }
                    ++jj;
                }
                while (jj < toIndex) {
                    if (!(jj != fromIndex && refIndex[jj - 1] == refIndex[jj] || duplicates.contains(refIndex[jj]))) {
                        body.add(refIndex[jj]);
                    }
                    ++jj;
                }
            }
            if (endPseudo > fromIndex) {
                keyWriter.storeKey(objectId, (Serializable)new int[]{header[objectId] - 1, endPseudo - fromIndex});
            }
        }

        public synchronized void cancel() {
            try {
                try {
                    this.close();
                    if (this.segments != null) {
                        int ii = 0;
                        while (ii < this.segments.length) {
                            new File(String.valueOf(this.indexFile.getAbsolutePath()) + ii + ".log").delete();
                            ++ii;
                        }
                    }
                }
                catch (IOException iOException) {
                    this.indexFile.delete();
                }
            }
            finally {
                this.indexFile.delete();
            }
        }

        public synchronized void close() throws IOException {
            if (this.segments != null) {
                int ii = 0;
                while (ii < this.segments.length) {
                    if (this.segments[ii] != null) {
                        this.segments[ii].flush();
                        this.segments[ii].close();
                        this.segments[ii] = null;
                    }
                    ++ii;
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }
    }

    public static class IntArray1NSortedWriter
    extends IntArray1NWriter {
        public IntArray1NSortedWriter(int size, File indexFile) throws IOException {
            super(size, indexFile);
        }

        protected void set(int index, int[] values, int offset, int length) throws IOException {
            this.header[index] = this.body.size() + 1;
            this.body.addAll(values, offset, length);
        }

        protected IIndexReader.IOne2ManyIndex createReader(IIndexReader.IOne2OneIndex headerIndex, IIndexReader.IOne2OneIndex bodyIndex) throws IOException {
            return new IndexReader.IntIndex1NSortedReader(this.indexFile, headerIndex, bodyIndex);
        }
    }

    public static class IntArray1NUncompressedCollector {
        int[][] elements;
        File indexFile;

        public IntArray1NUncompressedCollector(int size, File indexFile) throws IOException {
            this.elements = new int[size][];
            this.indexFile = indexFile;
        }

        public void log(int classId, int methodId) {
            if (this.elements[classId] == null) {
                this.elements[classId] = new int[]{methodId};
            } else {
                int[] newChildren = new int[this.elements[classId].length + 1];
                System.arraycopy(this.elements[classId], 0, newChildren, 0, this.elements[classId].length);
                newChildren[this.elements[classId].length] = methodId;
                this.elements[classId] = newChildren;
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }

        public IIndexReader.IOne2ManyIndex flush() throws IOException {
            IntArray1NSortedWriter writer = new IntArray1NSortedWriter(this.elements.length, this.indexFile);
            int ii = 0;
            while (ii < this.elements.length) {
                if (this.elements[ii] != null) {
                    writer.log(ii, this.elements[ii]);
                }
                ++ii;
            }
            return writer.flush();
        }
    }

    public static class IntArray1NWriter {
        int[] header;
        File indexFile;
        DataOutputStream out;
        IntIndexStreamer body;

        public IntArray1NWriter(int size, File indexFile) throws IOException {
            this.header = new int[size];
            this.indexFile = indexFile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.body = new IntIndexStreamer();
            this.body.openStream(this.out, 0L);
        }

        public void log(Identifier identifer, int index, ArrayLong references) throws IOException {
            long pseudo = references.firstElement();
            references.sort();
            int[] objectIds = new int[references.size()];
            int length = 1;
            long current = 0L;
            long last = references.firstElement() - 1L;
            int ii = 0;
            while (ii < objectIds.length) {
                int objectId;
                current = references.get(ii);
                if (last != current && (objectId = identifer.reverse(current)) >= 0) {
                    int jj = current == pseudo ? 0 : length++;
                    objectIds[jj] = objectId;
                }
                last = current;
                ++ii;
            }
            this.set(index, objectIds, 0, length);
        }

        public void log(int index, ArrayInt references) throws IOException {
            this.set(index, references.toArray(), 0, references.size());
        }

        public void log(int index, int[] values) throws IOException {
            this.set(index, values, 0, values.length);
        }

        protected void set(int index, int[] values, int offset, int length) throws IOException {
            this.header[index] = this.body.size();
            this.body.add(length);
            this.body.addAll(values, offset, length);
        }

        public IIndexReader.IOne2ManyIndex flush() throws IOException {
            long divider = this.body.closeStream();
            IIndexReader.IOne2OneIndex headerIndex = new IntIndexStreamer().writeTo(this.out, divider, this.header);
            this.out.writeLong(divider);
            this.out.close();
            this.out = null;
            return this.createReader(headerIndex, this.body.getReader(null));
        }

        protected IIndexReader.IOne2ManyIndex createReader(IIndexReader.IOne2OneIndex headerIndex, IIndexReader.IOne2OneIndex bodyIndex) throws IOException {
            return new IndexReader.IntIndex1NReader(this.indexFile, headerIndex, bodyIndex);
        }

        public void cancel() {
            try {
                try {
                    if (this.out != null) {
                        this.out.close();
                        this.body = null;
                        this.out = null;
                    }
                }
                catch (IOException iOException) {
                    if (this.indexFile.exists()) {
                        this.indexFile.delete();
                    }
                }
            }
            finally {
                if (this.indexFile.exists()) {
                    this.indexFile.delete();
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class IntIndex<V> {
        int pageSize;
        int size;
        Pages<V> pages;

        protected IntIndex() {
        }

        protected IntIndex(int size) {
            this.init(size, 1000000);
        }

        protected void init(int size, int pageSize) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = new Pages(size / pageSize + 1);
        }

        public int get(int index) {
            ArrayIntCompressed array = this.getPage(index / this.pageSize);
            return array.get(index % this.pageSize);
        }

        public int[] getNext(int index, int length) {
            int[] answer = new int[length];
            int page = index / this.pageSize;
            int pageIndex = index % this.pageSize;
            ArrayIntCompressed array = this.getPage(page);
            int ii = 0;
            while (ii < length) {
                answer[ii] = array.get(pageIndex++);
                if (pageIndex >= this.pageSize) {
                    array = this.getPage(++page);
                    pageIndex = 0;
                }
                ++ii;
            }
            return answer;
        }

        public int[] getAll(int[] index) {
            int[] answer = new int[index.length];
            int page = -1;
            ArrayIntCompressed array = null;
            int ii = 0;
            while (ii < answer.length) {
                int p = index[ii] / this.pageSize;
                if (p != page) {
                    page = p;
                    array = this.getPage(page);
                }
                answer[ii] = array.get(index[ii] % this.pageSize);
                ++ii;
            }
            return answer;
        }

        public void set(int index, int value) {
            ArrayIntCompressed array = this.getPage(index / this.pageSize);
            array.set(index % this.pageSize, value);
        }

        protected abstract ArrayIntCompressed getPage(int var1);

        public synchronized void unload() {
            this.pages = new Pages(this.size / this.pageSize + 1);
        }

        public int size() {
            return this.size;
        }

        public IteratorInt iterator() {
            return new IntIndexIterator(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntIndexCollector
    extends IntIndex<ArrayIntCompressed>
    implements IIndexReader.IOne2OneIndex {
        int mostSignificantBit;

        public IntIndexCollector(int size, int mostSignificantBit) {
            super(size);
            this.mostSignificantBit = mostSignificantBit;
        }

        @Override
        protected ArrayIntCompressed getPage(int page) {
            ArrayIntCompressed array = (ArrayIntCompressed)this.pages.get(page);
            if (array == null) {
                int ps = page < this.size / this.pageSize ? this.pageSize : this.size % this.pageSize;
                array = new ArrayIntCompressed(ps, 31 - this.mostSignificantBit, 0);
                this.pages.put(page, array);
            }
            return array;
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile) throws IOException {
            return new IntIndexStreamer().writeTo(indexFile, this.iterator());
        }

        public IIndexReader.IOne2OneIndex writeTo(DataOutputStream out, long position) throws IOException {
            return new IntIndexStreamer().writeTo(out, position, this.iterator());
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void delete() {
            this.pages = null;
        }
    }

    public static class IntIndexCollectorUncompressed {
        int[] dataElements;

        public IntIndexCollectorUncompressed(int size) {
            this.dataElements = new int[size];
        }

        public void set(int index, int value) {
            this.dataElements[index] = value;
        }

        public int get(int index) {
            return this.dataElements[index];
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile) throws IOException {
            return new IntIndexStreamer().writeTo(indexFile, this.dataElements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntIndexIterator
    implements IteratorInt {
        IntIndex<?> intArray;
        int nextIndex = 0;

        public IntIndexIterator(IntIndex<?> intArray) {
            this.intArray = intArray;
        }

        public int next() {
            return this.intArray.get(this.nextIndex++);
        }

        public boolean hasNext() {
            return this.nextIndex < this.intArray.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntIndexStreamer
    extends IntIndex<SoftReference<ArrayIntCompressed>> {
        DataOutputStream out;
        ArrayLong pageStart;
        int[] page;
        int left;

        public IIndexReader.IOne2OneIndex writeTo(File indexFile, IteratorInt iterator) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(iterator);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2OneIndex writeTo(File indexFile, int[] array) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2OneIndex writeTo(DataOutputStream out, long position, IteratorInt iterator) throws IOException {
            this.openStream(out, position);
            this.addAll(iterator);
            this.closeStream();
            return this.getReader(null);
        }

        public IIndexReader.IOne2OneIndex writeTo(DataOutputStream out, long position, int[] array) throws IOException {
            this.openStream(out, position);
            this.addAll(array);
            this.closeStream();
            return this.getReader(null);
        }

        void openStream(DataOutputStream out, long position) {
            this.out = out;
            this.init(0, 1000000);
            this.page = new int[this.pageSize];
            this.pageStart = new ArrayLong();
            this.pageStart.add(position);
            this.left = this.page.length;
        }

        long closeStream() throws IOException {
            if (this.left < this.page.length) {
                this.addPage();
            }
            int jj = 0;
            while (jj < this.pageStart.size()) {
                this.out.writeLong(this.pageStart.get(jj));
                ++jj;
            }
            this.out.writeInt(this.pageSize);
            this.out.writeInt(this.size);
            this.page = null;
            this.out = null;
            return this.pageStart.lastElement() + (long)(8 * this.pageStart.size()) + 8L - this.pageStart.firstElement();
        }

        IndexReader.IntIndexReader getReader(File indexFile) {
            return new IndexReader.IntIndexReader(indexFile, this.pages, this.size, this.pageSize, this.pageStart.toArray());
        }

        void addAll(IteratorInt iterator) throws IOException {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }

        void add(int value) throws IOException {
            if (this.left == 0) {
                this.addPage();
            }
            this.page[this.page.length - this.left--] = value;
            ++this.size;
        }

        void addAll(int[] values) throws IOException {
            this.addAll(values, 0, values.length);
        }

        void addAll(int[] values, int offset, int length) throws IOException {
            while (length > 0) {
                if (this.left == 0) {
                    this.addPage();
                }
                int chunk = Math.min(this.left, length);
                System.arraycopy(values, offset, this.page, this.page.length - this.left, chunk);
                this.left -= chunk;
                this.size += chunk;
                length -= chunk;
                offset += chunk;
            }
        }

        private void addPage() throws IOException {
            ArrayIntCompressed array = new ArrayIntCompressed(this.page, 0, this.page.length - this.left);
            byte[] buffer = array.toByteArray();
            this.out.write(buffer);
            int written = buffer.length;
            this.pages.put(this.pages.size(), new SoftReference<ArrayIntCompressed>(array));
            this.pageStart.add(this.pageStart.lastElement() + (long)written);
            this.left = this.page.length;
        }

        @Override
        protected ArrayIntCompressed getPage(int page) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface KeyWriter {
        public void storeKey(int var1, Serializable var2);
    }

    public static class LongArray1NWriter {
        int[] header;
        File indexFile;
        DataOutputStream out;
        LongIndexStreamer body;

        public LongArray1NWriter(int size, File indexFile) throws IOException {
            this.header = new int[size];
            this.indexFile = indexFile;
            this.out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.body = new LongIndexStreamer();
            this.body.openStream(this.out, 0L);
        }

        public void log(int index, long[] values) throws IOException {
            this.set(index, values, 0, values.length);
        }

        protected void set(int index, long[] values, int offset, int length) throws IOException {
            this.header[index] = this.body.size() + 1;
            this.body.add(length);
            this.body.addAll(values, offset, length);
        }

        public void flush() throws IOException {
            long divider = this.body.closeStream();
            new IntIndexStreamer().writeTo(this.out, divider, this.header).close();
            this.out.writeLong(divider);
            this.out.close();
            this.out = null;
        }

        public void cancel() {
            try {
                try {
                    if (this.out != null) {
                        this.out.close();
                        this.body = null;
                        this.out = null;
                    }
                }
                catch (IOException iOException) {
                    if (this.indexFile.exists()) {
                        this.indexFile.delete();
                    }
                }
            }
            finally {
                if (this.indexFile.exists()) {
                    this.indexFile.delete();
                }
            }
        }

        public File getIndexFile() {
            return this.indexFile;
        }
    }

    static abstract class LongIndex {
        private static final int DEPTH = 10;
        int pageSize;
        int size;
        HashMapIntObject<Object> pages;
        HashMapIntLong binarySearchCache = new HashMapIntLong(1024);

        protected LongIndex() {
        }

        protected LongIndex(int size) {
            this.init(size, 500000);
        }

        protected void init(int size, int pageSize) {
            this.size = size;
            this.pageSize = pageSize;
            this.pages = new HashMapIntObject(size / pageSize + 1);
        }

        public long get(int index) {
            ArrayLongCompressed array = this.getPage(index / this.pageSize);
            return array.get(index % this.pageSize);
        }

        public long[] getNext(int index, int length) {
            long[] answer = new long[length];
            int page = index / this.pageSize;
            int pageIndex = index % this.pageSize;
            ArrayLongCompressed array = this.getPage(page);
            int ii = 0;
            while (ii < length) {
                answer[ii] = array.get(pageIndex++);
                if (pageIndex >= this.pageSize) {
                    array = this.getPage(++page);
                    pageIndex = 0;
                }
                ++ii;
            }
            return answer;
        }

        public int reverse(long value) {
            int low = 0;
            int high = this.size - 1;
            int depth = 0;
            int page = -1;
            ArrayLongCompressed array = null;
            while (low <= high) {
                int p;
                long midVal;
                int mid = low + high >> 1;
                if (depth++ < 10) {
                    try {
                        midVal = this.binarySearchCache.get(mid);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        p = mid / this.pageSize;
                        if (p != page) {
                            page = p;
                            array = this.getPage(page);
                        }
                        midVal = array.get(mid % this.pageSize);
                        this.binarySearchCache.put(mid, midVal);
                    }
                } else {
                    p = mid / this.pageSize;
                    if (p != page) {
                        page = p;
                        array = this.getPage(page);
                    }
                    midVal = array.get(mid % this.pageSize);
                }
                if (midVal < value) {
                    low = mid + 1;
                    continue;
                }
                if (midVal > value) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return -(low + 1);
        }

        public void set(int index, long value) {
            ArrayLongCompressed array = this.getPage(index / this.pageSize);
            array.set(index % this.pageSize, value);
        }

        protected abstract ArrayLongCompressed getPage(int var1);

        public synchronized void unload() {
            this.pages = new HashMapIntObject(this.size / this.pageSize + 1);
            this.binarySearchCache = new HashMapIntLong(1024);
        }

        public int size() {
            return this.size;
        }

        public IteratorLong iterator() {
            return new LongIndexIterator(this);
        }
    }

    public static class LongIndexCollector
    extends LongIndex {
        int mostSignificantBit;

        public LongIndexCollector(int size, int mostSignificantBit) {
            super(size);
            this.mostSignificantBit = mostSignificantBit;
        }

        protected ArrayLongCompressed getPage(int page) {
            ArrayLongCompressed array = (ArrayLongCompressed)this.pages.get(page);
            if (array == null) {
                int ps = page < this.size / this.pageSize ? this.pageSize : this.size % this.pageSize;
                array = new ArrayLongCompressed(ps, 63 - this.mostSignificantBit, 0);
                this.pages.put(page, (Object)array);
            }
            return array;
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile) throws IOException {
            return new LongIndexStreamer().writeTo(indexFile, this.size, (HashMapIntObject<Object>)this.pages, this.pageSize);
        }
    }

    public static class LongIndexCollectorUncompressed {
        long[] dataElements;

        public LongIndexCollectorUncompressed(int size) {
            this.dataElements = new long[size];
        }

        public void set(int index, long value) {
            this.dataElements[index] = value;
        }

        public long get(int index) {
            return this.dataElements[index];
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile) throws IOException {
            return new LongIndexStreamer().writeTo(indexFile, this.dataElements);
        }
    }

    static class LongIndexIterator
    implements IteratorLong {
        LongIndex longArray;
        int nextIndex = 0;

        public LongIndexIterator(LongIndex longArray) {
            this.longArray = longArray;
        }

        public long next() {
            return this.longArray.get(this.nextIndex++);
        }

        public boolean hasNext() {
            return this.nextIndex < this.longArray.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongIndexStreamer
    extends LongIndex {
        DataOutputStream out;
        ArrayLong pageStart;
        long[] page;
        int left;

        public LongIndexStreamer() {
        }

        public LongIndexStreamer(File indexFile) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
        }

        public void close() throws IOException {
            DataOutputStream out = this.out;
            this.closeStream();
            out.close();
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, int size, HashMapIntObject<Object> pages, int pageSize) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            int noOfPages = size / pageSize + (size % pageSize > 0 ? 1 : 0);
            int ii = 0;
            while (ii < noOfPages) {
                int len;
                ArrayLongCompressed a = (ArrayLongCompressed)pages.get(ii);
                int n = len = ii + 1 < noOfPages ? pageSize : size % pageSize;
                if (a == null) {
                    this.addAll(new long[len]);
                } else {
                    int jj = 0;
                    while (jj < len) {
                        this.add(a.get(jj));
                        ++jj;
                    }
                }
                ++ii;
            }
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, long[] array) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, IteratorLong iterator) throws IOException {
            IndexReader.LongIndexReader longIndexReader;
            FileOutputStream fos = new FileOutputStream(indexFile);
            try {
                DataOutputStream out = new DataOutputStream(new BufferedOutputStream(fos));
                this.openStream(out, 0L);
                this.addAll(iterator);
                this.closeStream();
                out.flush();
                longIndexReader = this.getReader(indexFile);
            }
            catch (Throwable throwable) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                fos.close();
            }
            catch (IOException iOException) {}
            return longIndexReader;
        }

        public IIndexReader.IOne2LongIndex writeTo(File indexFile, ArrayLong array) throws IOException {
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexFile)));
            this.openStream(out, 0L);
            this.addAll(array);
            this.closeStream();
            out.close();
            return this.getReader(indexFile);
        }

        void openStream(DataOutputStream out, long position) {
            this.out = out;
            this.init(0, 500000);
            this.page = new long[this.pageSize];
            this.pageStart = new ArrayLong();
            this.pageStart.add(position);
            this.left = this.page.length;
        }

        long closeStream() throws IOException {
            if (this.left < this.page.length) {
                this.addPage();
            }
            int jj = 0;
            while (jj < this.pageStart.size()) {
                this.out.writeLong(this.pageStart.get(jj));
                ++jj;
            }
            this.out.writeInt(this.pageSize);
            this.out.writeInt(this.size);
            this.page = null;
            this.out = null;
            return this.pageStart.lastElement() + (long)(8 * this.pageStart.size()) + 8L - this.pageStart.firstElement();
        }

        IndexReader.LongIndexReader getReader(File indexFile) throws IOException {
            return new IndexReader.LongIndexReader(indexFile, (HashMapIntObject<Object>)this.pages, this.size, this.pageSize, this.pageStart.toArray());
        }

        public void addAll(IteratorLong iterator) throws IOException {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }

        public void addAll(ArrayLong array) throws IOException {
            IteratorLong e = array.iterator();
            while (e.hasNext()) {
                this.add(e.next());
            }
        }

        public void add(long value) throws IOException {
            if (this.left == 0) {
                this.addPage();
            }
            this.page[this.page.length - this.left--] = value;
            ++this.size;
        }

        public void addAll(long[] values) throws IOException {
            this.addAll(values, 0, values.length);
        }

        public void addAll(long[] values, int offset, int length) throws IOException {
            while (length > 0) {
                if (this.left == 0) {
                    this.addPage();
                }
                int chunk = Math.min(this.left, length);
                System.arraycopy(values, offset, this.page, this.page.length - this.left, chunk);
                this.left -= chunk;
                this.size += chunk;
                length -= chunk;
                offset += chunk;
            }
        }

        private void addPage() throws IOException {
            ArrayLongCompressed array = new ArrayLongCompressed(this.page, 0, this.page.length - this.left);
            byte[] buffer = array.toByteArray();
            this.out.write(buffer);
            int written = buffer.length;
            this.pages.put(this.pages.size(), new SoftReference<ArrayLongCompressed>(array));
            this.pageStart.add(this.pageStart.lastElement() + (long)written);
            this.left = this.page.length;
        }

        @Override
        protected ArrayLongCompressed getPage(int page) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Pages<V> {
        int size;
        Object[] elements;

        public Pages(int initialSize) {
            this.elements = new Object[initialSize];
            this.size = 0;
        }

        private void ensureCapacity(int minCapacity) {
            int oldCapacity = this.elements.length;
            if (minCapacity > oldCapacity) {
                int newCapacity = oldCapacity * 3 / 2 + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                Object[] copy = new Object[newCapacity];
                System.arraycopy(this.elements, 0, copy, 0, Math.min(this.elements.length, newCapacity));
                this.elements = copy;
            }
        }

        public V get(int key) {
            return (V)(key >= this.elements.length ? null : this.elements[key]);
        }

        public void put(int key, V value) {
            this.ensureCapacity(key + 1);
            this.elements[key] = value;
            this.size = Math.max(this.size, key + 1);
        }

        public int size() {
            return this.size;
        }
    }
}

