/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.parser.internal.StackFrameImpl;
import org.eclipse.mat.parser.internal.ThreadStackImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IThreadStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ThreadStackHelper {
    ThreadStackHelper() {
    }

    static HashMapIntObject<IThreadStack> loadThreadsData(ISnapshot snapshot) throws SnapshotException {
        String fileName = String.valueOf(snapshot.getSnapshotInfo().getPrefix()) + "threads";
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        HashMapIntObject threadId2stack = new HashMapIntObject();
        BufferedReader in = null;
        try {
            try {
                in = new BufferedReader(new FileReader(f));
                String line = in.readLine();
                while (line != null) {
                    if ((line = line.trim()).startsWith("Thread")) {
                        long threadAddress = ThreadStackHelper.readThreadAddres(line);
                        ArrayList<String> lines = new ArrayList<String>();
                        HashMapIntObject line2locals = new HashMapIntObject();
                        line = in.readLine();
                        while (line != null && !line.equals("")) {
                            lines.add(line.trim());
                            line = in.readLine();
                        }
                        line = in.readLine();
                        if (line != null && line.trim().startsWith("locals")) {
                            line = in.readLine();
                            while (line != null && !line.equals("")) {
                                int lineNr = ThreadStackHelper.readLineNumber(line);
                                if (lineNr > 0) {
                                    int objectId = ThreadStackHelper.readLocalId(line, snapshot);
                                    ArrayInt arr = (ArrayInt)line2locals.get(lineNr);
                                    if (arr == null) {
                                        arr = new ArrayInt();
                                        line2locals.put(lineNr, (Object)arr);
                                    }
                                    arr.add(objectId);
                                }
                                line = in.readLine();
                            }
                        }
                        int threadId = snapshot.mapAddressToId(threadAddress);
                        ThreadStackImpl stack = new ThreadStackImpl(threadId, ThreadStackHelper.buildFrames(lines, (HashMapIntObject<ArrayInt>)line2locals));
                        threadId2stack.put(threadId, (Object)stack);
                    }
                    if (line != null) {
                        line = in.readLine();
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                throw new SnapshotException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return threadId2stack;
    }

    private static long readThreadAddres(String line) {
        int start = line.indexOf("0x");
        return new BigInteger(line.substring(start + 2), 16).longValue();
    }

    private static int readLocalId(String line, ISnapshot snapshot) throws SnapshotException {
        int start = line.indexOf("0x");
        int end = line.indexOf(44, start);
        long address = new BigInteger(line.substring(start + 2, end), 16).longValue();
        return snapshot.mapAddressToId(address);
    }

    private static int readLineNumber(String line) {
        int start = line.indexOf("line=");
        return Integer.valueOf(line.substring(start + 5));
    }

    private static StackFrameImpl[] buildFrames(List<String> lines, HashMapIntObject<ArrayInt> line2locals) {
        int sz = lines.size();
        StackFrameImpl[] frames = new StackFrameImpl[sz];
        int i = 0;
        while (i < sz) {
            int[] localsIds = null;
            ArrayInt locals = (ArrayInt)line2locals.get(i);
            if (locals != null && locals.size() > 0) {
                localsIds = locals.toArray();
            }
            frames[i] = new StackFrameImpl(lines.get(i), localsIds);
            ++i;
        }
        return frames;
    }
}

