/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.actions;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.action.Action;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.QueryExecution;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.util.ErrorHelper;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;

public class RunExternalReportAction
extends Action {
    private static final String LAST_DIRECTORY_KEY = String.valueOf(RunExternalReportAction.class.getName()) + ".lastDir";
    private MultiPaneEditor editor;

    public RunExternalReportAction(MultiPaneEditor editor) {
        super(Messages.RunExternalReportAction_RunReport);
        this.editor = editor;
    }

    public void run() {
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 4098);
        dialog.setText(Messages.RunExternalReportAction_OpenReportDefinition);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.setFilterNames(new String[]{Messages.RunExternalReportAction_ReportDefinitions});
        Preferences prefs = MemoryAnalyserPlugin.getDefault().getPluginPreferences();
        String lastDirectory = prefs.getString(LAST_DIRECTORY_KEY);
        if (lastDirectory != null && lastDirectory.length() > 0) {
            dialog.setFilterPath(lastDirectory);
        }
        dialog.open();
        String[] names = dialog.getFileNames();
        if (names != null) {
            prefs.setValue(LAST_DIRECTORY_KEY, dialog.getFilterPath());
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    QueryExecution.executeCommandLine(this.editor, null, "create_report " + new File(dialog.getFilterPath(), name).getAbsolutePath());
                }
                catch (SnapshotException e) {
                    ErrorHelper.showErrorMessage(e);
                }
                ++n2;
            }
        }
    }
}

