/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.HeapObjectContextArgument;
import org.eclipse.mat.internal.snapshot.HeapObjectParamArgument;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.ArgumentDescriptor;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotFactory;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentEditor;
import org.eclipse.mat.ui.internal.query.arguments.CheckBoxEditor;
import org.eclipse.mat.ui.internal.query.arguments.ImageTextEditor;
import org.eclipse.mat.ui.internal.query.arguments.LinkEditor;
import org.eclipse.mat.ui.internal.query.arguments.TableEditorFactory;
import org.eclipse.mat.ui.internal.query.arguments.TextEditor;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ArgumentsTable
implements ArgumentEditor.IEditorListener {
    private static final int MIN_EDITOR_WIDTH = 50;
    private static final String ADDRESS_PREFIX = "0x";
    protected static final String EOL = System.getProperty("line.separator", "\n");
    private static final String ARGUMENT = Messages.ArgumentsTable_Argument;
    private static final String VALUE = Messages.ArgumentsTable_Value;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Table table;
    private Font boldFont;
    private Font normalFont;
    private List<ITableListener> listeners = Collections.synchronizedList(new ArrayList());
    private Map<ArgumentEditor, String> errors = Collections.synchronizedMap(new HashMap());
    private LinkEditor.Mode mode = LinkEditor.Mode.SIMPLE_MODE;
    private Map<ArgumentDescriptor, LinkEditor.Mode> modeMap;
    private IQueryContext context;
    private ArgumentSet argumentSet;

    public ArgumentsTable(Composite parent, int style, IQueryContext context, ArgumentSet argumentSet, LinkEditor.Mode mode) {
        this.context = context;
        this.argumentSet = argumentSet;
        this.mode = mode;
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableColumnLayout);
        this.table = new Table(parent, style);
        this.table.setFont(parent.getFont());
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0);
        column.setText(ARGUMENT);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(0, 100));
        column = new TableColumn(this.table, 0);
        column.setText(VALUE);
        tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.table.getFont()).setStyle(1));
        this.normalFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.table.getFont()).setStyle(0));
        this.modeMap = new HashMap<ArgumentDescriptor, LinkEditor.Mode>(argumentSet.getQueryDescriptor().getArguments().size());
        for (ArgumentDescriptor descriptor : argumentSet.getQueryDescriptor().getArguments()) {
            if (!this.isHeapObject(descriptor)) continue;
            this.modeMap.put(descriptor, mode);
        }
        this.createTableContent();
        new DefaultToolTip((Control)this.table, 2, false){

            private ArgumentDescriptor getEntry(Event event) {
                TableItem item = ArgumentsTable.this.table.getItem(new Point(event.x, event.y));
                if (item != null && item.getData() != null) {
                    return ((ArgumentEditor)((Object)item.getData())).getDescriptor();
                }
                return null;
            }

            protected String getText(Event event) {
                ArgumentDescriptor entry = this.getEntry(event);
                if (entry != null) {
                    return entry.getHelp();
                }
                return null;
            }

            protected boolean shouldCreateToolTip(Event event) {
                ArgumentsTable.this.table.setToolTipText("");
                return this.getEntry(event) != null && super.shouldCreateToolTip(event);
            }

            protected Object getToolTipArea(Event event) {
                return this.getEntry(event);
            }
        }.activate();
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    private void createTableContent() {
        this.table.setData((Object)this.argumentSet);
        for (ArgumentDescriptor descriptor : this.argumentSet.getQueryDescriptor().getArguments()) {
            TableItem item;
            if (this.context.available(descriptor.getType(), descriptor.getAdvice())) continue;
            String flag = this.createArgumentLabel(descriptor);
            boolean isHeapObject = this.isHeapObject(descriptor);
            Object argumentValue = this.argumentSet.getArgumentValue(descriptor);
            if (IContextObject.class.isAssignableFrom(descriptor.getType())) {
                item = new TableItem(this.table, 0);
                item.setFont(this.normalFont);
                item.setText(new String[]{flag, Messages.ArgumentsTable_selectedRows});
                continue;
            }
            if (descriptor.isMultiple() && !isHeapObject) {
                List values = (List)argumentValue;
                if (values == null) {
                    values = (List)descriptor.getDefaultValue();
                }
                if (values == null || values.isEmpty()) {
                    this.addEditorRow(descriptor, flag, null, -1);
                    continue;
                }
                Iterator valueIt = values.iterator();
                Object firstValue = valueIt.next();
                this.addEditorRow(descriptor, flag, firstValue, -1);
                while (valueIt.hasNext()) {
                    Object objValue = valueIt.next();
                    this.addEditorRow(descriptor, "..\"..", objValue, -1);
                }
                this.addEditorRow(descriptor, "..\"..", null, -1);
                continue;
            }
            if (isHeapObject && argumentValue instanceof HeapObjectContextArgument) {
                item = new TableItem(this.table, 0);
                item.setFont(this.normalFont);
                item.setText(new String[]{flag, String.valueOf(argumentValue)});
                continue;
            }
            if (isHeapObject) {
                this.addHeapObjectTableItems(descriptor, (HeapObjectParamArgument)argumentValue);
                continue;
            }
            Object value = argumentValue;
            if (value == null) {
                value = descriptor.getDefaultValue();
            }
            this.addEditorRow(descriptor, flag, value, -1);
        }
        Control[] controlArray = this.table.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof ArgumentEditor) {
                ((ArgumentEditor)control).addListener(this);
            }
            ++n2;
        }
        try {
            this.table.getChildren()[0].setFocus();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    private boolean isHeapObject(ArgumentDescriptor descriptor) {
        boolean isHeapObject = descriptor.getAdvice() == Argument.Advice.HEAP_OBJECT || IObject.class.isAssignableFrom(descriptor.getType()) || IHeapObjectArgument.class.isAssignableFrom(descriptor.getType());
        return isHeapObject;
    }

    private String createArgumentLabel(ArgumentDescriptor descriptor) {
        String flag = descriptor.getFlag();
        if (flag == null) {
            return descriptor.getName();
        }
        return "-" + flag;
    }

    private void addEditorRow(ArgumentDescriptor descriptor, String flag, Object value, int index) {
        TableItem item = index > 0 ? new TableItem(this.table, 0, index) : new TableItem(this.table, 0);
        item.setText(flag);
        this.setFont(descriptor, item);
        TableEditor editor = this.createEditor();
        ArgumentEditor aec = TableEditorFactory.createTableEditor((Composite)this.table, this.context, descriptor, item);
        aec.setFont(this.table.getFont());
        editor.setEditor((Control)aec, item, 1);
        item.setData((Object)aec);
        if (index > 0) {
            aec.addListener(this);
            this.table.pack();
            this.table.getParent().pack();
            this.setNewTabOrder();
        }
        try {
            if (value != null) {
                aec.setValue(value);
            }
        }
        catch (SnapshotException snapshotException) {}
    }

    private void setFont(ArgumentDescriptor descriptor, TableItem item) {
        if (descriptor.isMandatory()) {
            item.setFont(this.boldFont);
        } else {
            item.setFont(this.normalFont);
        }
    }

    private void setNewTabOrder() {
        TableItem[] items = this.table.getItems();
        Control[] newTabOrder = new Control[this.table.getChildren().length];
        int i = 0;
        int j = 0;
        while (i < items.length) {
            if (items[i].getData() != null) {
                newTabOrder[j] = (ArgumentEditor)((Object)items[i].getData());
            } else {
                --j;
            }
            ++i;
            ++j;
        }
        this.table.setTabList(newTabOrder);
    }

    private void addHeapObjectTableItems(ArgumentDescriptor descriptor, int index, TextEditor.DecoratorType decorator) {
        TableItem item = new TableItem(this.table, 0, index);
        this.setFont(descriptor, item);
        TableEditor editor = this.createEditor();
        ImageTextEditor aec = new ImageTextEditor((Composite)this.table, this.context, descriptor, item, decorator);
        aec.setFont(this.table.getFont());
        editor.setEditor((Control)aec, item, 1);
        item.setData((Object)aec);
        aec.addListener(this);
        this.table.getParent().pack();
        this.setNewTabOrder();
    }

    private void addHeapObjectTableItems(ArgumentDescriptor descriptor, HeapObjectParamArgument initialInput) {
        if (!(initialInput == null || initialInput.getAddresses().isEmpty() && initialInput.getOqls().isEmpty())) {
            this.verifyMode();
        }
        TextEditor.DecoratorType[] decoratorTypeArray = TextEditor.DecoratorType.values();
        int n = decoratorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TextEditor.DecoratorType decorator = decoratorTypeArray[n2];
            String label = "";
            if (decorator.equals((Object)TextEditor.DecoratorType.PATTERN)) {
                label = this.createArgumentLabel(descriptor);
                List patterns = null;
                if (initialInput != null) {
                    patterns = initialInput.getPatterns();
                }
                if (patterns != null) {
                    for (Pattern pattern : patterns) {
                        this.createHeapObjectRow(descriptor, pattern.toString(), decorator, label);
                        label = "";
                    }
                }
            } else if (decorator.equals((Object)TextEditor.DecoratorType.OBJECT_ADDRESS)) {
                List addresses = null;
                if (initialInput != null) {
                    addresses = initialInput.getAddresses();
                }
                if (addresses != null) {
                    for (Long address : addresses) {
                        this.createHeapObjectRow(descriptor, ADDRESS_PREFIX + Long.toHexString(address), decorator, label);
                    }
                }
            } else {
                List oqls = null;
                if (initialInput != null) {
                    oqls = initialInput.getOqls();
                }
                if (oqls != null) {
                    for (String oql : oqls) {
                        this.createHeapObjectRow(descriptor, oql.toString(), decorator, label);
                    }
                }
            }
            this.createHeapObjectRow(descriptor, null, decorator, label);
            if (this.modeMap.get(descriptor).equals((Object)LinkEditor.Mode.SIMPLE_MODE)) break;
            ++n2;
        }
        this.addCheckBoxRows(descriptor, CheckBoxEditor.Type.INCLUDE_CLASS_INSTANCE, initialInput != null ? initialInput.isIncludeClassInstance() : false);
        if (this.modeMap.get(descriptor) == LinkEditor.Mode.ADVANCED_MODE) {
            this.addCheckBoxRows(descriptor, CheckBoxEditor.Type.INCLUDE_SUBCLASSES, initialInput != null ? initialInput.isIncludeSubclasses() : false);
            this.addCheckBoxRows(descriptor, CheckBoxEditor.Type.INTEPRET_AS_CLASSLOADER, initialInput != null ? initialInput.isIncludeLoadedInstances() : false);
            this.addCheckBoxRows(descriptor, CheckBoxEditor.Type.RETAINED, initialInput != null ? initialInput.isRetained() : false);
        }
        this.addLink(descriptor, this.modeMap.get(descriptor));
        this.table.getParent().pack();
    }

    private void verifyMode() {
        if (this.mode.equals((Object)LinkEditor.Mode.SIMPLE_MODE)) {
            this.mode = LinkEditor.Mode.ADVANCED_MODE;
        }
    }

    private void createHeapObjectRow(ArgumentDescriptor descriptor, String value, TextEditor.DecoratorType decorator, String label) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(label);
        this.setFont(descriptor, item);
        TableEditor editor = this.createEditor();
        ImageTextEditor aec = new ImageTextEditor((Composite)this.table, this.context, descriptor, item, decorator);
        aec.setFont(this.table.getFont());
        editor.setEditor((Control)aec, item, 1);
        item.setData((Object)aec);
        if (value != null) {
            try {
                aec.setValue(value);
            }
            catch (SnapshotException snapshotException) {}
        }
    }

    private void addLink(ArgumentDescriptor descriptor, LinkEditor.Mode mode) {
        TableItem item = new TableItem(this.table, 0);
        item.setText("");
        TableEditor editor = this.createEditor();
        LinkEditor aec = new LinkEditor((Composite)this.table, this.context, descriptor, item, mode);
        aec.setFont(this.table.getFont());
        editor.setEditor((Control)aec, item, 1);
        item.setData((Object)aec);
    }

    private TableEditor createEditor() {
        TableEditor editor = new TableEditor(this.table);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = 50;
        return editor;
    }

    private void addCheckBoxRows(ArgumentDescriptor descriptor, CheckBoxEditor.Type type, boolean selected) {
        TableItem item = new TableItem(this.table, 0);
        item.setText("");
        TableEditor editor = this.createEditor();
        CheckBoxEditor aec = new CheckBoxEditor((Composite)this.table, this.context, descriptor, item, type);
        aec.setFont(this.table.getFont());
        editor.setEditor((Control)aec, item, 1);
        item.setData((Object)aec);
        try {
            aec.setValue(selected);
        }
        catch (SnapshotException snapshotException) {}
    }

    public synchronized void onValueChanged(Object value, ArgumentDescriptor descriptor, TableItem item, ArgumentEditor argEditor) {
        boolean isLastOne;
        int myIndex = this.table.indexOf(item);
        this.onError(argEditor, null);
        this.onError(null, null);
        boolean isHeapObject = this.isHeapObject(descriptor);
        boolean bl = isLastOne = descriptor.isMultiple() && !isHeapObject && (myIndex + 1 == this.table.getItemCount() || ((ArgumentEditor)((Object)this.table.getItem(myIndex + 1).getData())).getDescriptor() != descriptor);
        if (isHeapObject) {
            if (argEditor instanceof ImageTextEditor) {
                this.verifyHeapObjectTextEditorInput((ImageTextEditor)argEditor);
            }
            if (this.noErrorsInHoa()) {
                this.argumentSet.removeArgumentValue(descriptor);
                HeapObjectParamArgument hoa = this.createHeapObjectDefinition(descriptor);
                if (hoa.isComplete()) {
                    this.argumentSet.setArgumentValue(descriptor, (Object)hoa);
                    if (argEditor instanceof ImageTextEditor && this.isNewRowNeeded(descriptor, ((ImageTextEditor)argEditor).getDecorator())) {
                        this.addHeapObjectTableItems(descriptor, myIndex + 1, ((ImageTextEditor)argEditor).getDecorator());
                    }
                } else if (descriptor.isMandatory()) {
                    this.onError(null, Messages.ArgumentsTable_ProvidePattern);
                }
            }
        } else if (descriptor.isMultiple()) {
            Object defaultValue;
            ArrayList<Object> values = new ArrayList<Object>();
            Control[] children = this.table.getChildren();
            int ii = 0;
            while (ii < children.length) {
                Object v;
                ArgumentEditor editor;
                if (children[ii] instanceof ArgumentEditor && (editor = (ArgumentEditor)children[ii]).getDescriptor() == descriptor && (v = editor.getValue()) != null) {
                    values.add(v);
                }
                ++ii;
            }
            if (values.isEmpty()) {
                values = null;
            }
            if ((defaultValue = descriptor.getDefaultValue()) == null || !defaultValue.equals(values)) {
                this.argumentSet.setArgumentValue(descriptor, values);
            } else {
                this.argumentSet.removeArgumentValue(descriptor);
            }
            if (descriptor.isMandatory() && values == null) {
                this.onError(argEditor, MessageUtil.format((String)Messages.ArgumentsTable_isMandatory, (Object[])new Object[]{descriptor.getName()}));
            }
            if (isLastOne && value != null) {
                this.addEditorRow(descriptor, "..\"..", null, myIndex + 1);
            }
        } else {
            Object defaultValue = descriptor.getDefaultValue();
            if (defaultValue == null || !defaultValue.equals(value)) {
                this.argumentSet.setArgumentValue(descriptor, value);
            } else {
                this.argumentSet.removeArgumentValue(descriptor);
            }
            if (descriptor.isMandatory() && value == null) {
                this.onError(argEditor, MessageUtil.format((String)Messages.ArgumentsTable_isMandatory, (Object[])new Object[]{descriptor.getName()}));
            }
        }
        this.fireInputChangedEvent();
    }

    private boolean isNewRowNeeded(ArgumentDescriptor descriptor, TextEditor.DecoratorType decorator) {
        Control[] children;
        boolean notEmpty = true;
        Control[] controlArray = children = this.table.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof ImageTextEditor && ((ImageTextEditor)control).getDescriptor().equals(descriptor) && ((ImageTextEditor)control).getDecorator().equals((Object)decorator)) {
                notEmpty = notEmpty && ((ImageTextEditor)control).getValue() != null && !((ImageTextEditor)control).getValue().equals("");
            }
            ++n2;
        }
        return notEmpty;
    }

    private HeapObjectParamArgument createHeapObjectDefinition(ArgumentDescriptor descriptor) {
        Control[] children;
        ISnapshot snapshot = (ISnapshot)this.context.get(ISnapshot.class, null);
        HeapObjectParamArgument hoa = new HeapObjectParamArgument(snapshot);
        Control[] controlArray = children = this.table.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (descriptor.equals(((ArgumentEditor)control).getDescriptor())) {
                if (control instanceof CheckBoxEditor) {
                    Boolean value = (Boolean)((CheckBoxEditor)control).getValue();
                    switch (((CheckBoxEditor)control).getType()) {
                        case INCLUDE_CLASS_INSTANCE: {
                            hoa.setIncludeClassInstance(value.booleanValue());
                            break;
                        }
                        case INCLUDE_SUBCLASSES: {
                            hoa.setIncludeSubclasses(value.booleanValue());
                            break;
                        }
                        case INTEPRET_AS_CLASSLOADER: {
                            hoa.setIncludeLoadedInstances(value.booleanValue());
                            break;
                        }
                        case RETAINED: {
                            hoa.setRetained(value.booleanValue());
                            break;
                        }
                        case VERBOSE: {
                            hoa.setVerbose(value.booleanValue());
                        }
                    }
                } else if (control instanceof ImageTextEditor && ((ImageTextEditor)control).getValue() != null) {
                    String line = ((ImageTextEditor)control).getValue().toString().trim();
                    if (line.toLowerCase().startsWith("select")) {
                        hoa.addOql(line);
                    } else if (line.startsWith(ADDRESS_PREFIX)) {
                        hoa.addObjectAddress(new BigInteger(line.substring(2), 16).longValue());
                    } else if (!line.equals("")) {
                        hoa.addPattern(Pattern.compile(line));
                    }
                }
            }
            ++n2;
        }
        return hoa;
    }

    private void verifyHeapObjectTextEditorInput(ImageTextEditor editor) {
        TextEditor.DecoratorType decorator = editor.getDecorator();
        if (editor.getValue() != null) {
            this.onError(editor, null);
            String line = editor.getValue().toString().trim();
            if (decorator.equals((Object)TextEditor.DecoratorType.QUERY)) {
                if (line.equals("")) {
                    return;
                }
                try {
                    SnapshotFactory.createQuery((String)line);
                }
                catch (SnapshotException e) {
                    int p;
                    String msg = e.getMessage();
                    if (msg.startsWith(Messages.ArgumentsTable_Encountered) && (p = msg.indexOf(Messages.ArgumentsTable_WasExpecting)) >= 0) {
                        msg = msg.substring(p, msg.length()).replace(EOL, " ");
                    }
                    this.onError(editor, msg);
                }
            } else if (decorator.equals((Object)TextEditor.DecoratorType.OBJECT_ADDRESS)) {
                if (line.length() > 2 && ADDRESS_PREFIX.equals(line.substring(0, 2))) {
                    try {
                        new BigInteger(line.substring(2), 16).longValue();
                    }
                    catch (NumberFormatException e) {
                        this.onError(editor, String.valueOf(Messages.ArgumentsTable_InvalidAddress) + e.getMessage());
                    }
                } else if (line.length() < 2 && !line.startsWith(ADDRESS_PREFIX.substring(0, line.length())) || line.length() >= 2 && !line.startsWith(ADDRESS_PREFIX.substring(0, 2))) {
                    this.onError(editor, String.valueOf(Messages.ArgumentsTable_InvalidAddress) + line);
                } else if (line.length() != 0) {
                    this.onError(editor, Messages.ArgumentsTable_AddressNotComplete);
                }
            } else if (!line.equals("")) {
                try {
                    Pattern.compile(line);
                }
                catch (PatternSyntaxException e) {
                    this.onError(editor, e.getMessage());
                }
            }
        }
    }

    private boolean noErrorsInHoa() {
        for (Map.Entry<ArgumentEditor, String> entry : this.errors.entrySet()) {
            if (!(entry.getKey() instanceof ImageTextEditor)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onError(ArgumentEditor editor, String message) {
        Map<ArgumentEditor, String> map = this.errors;
        synchronized (map) {
            if (message == null) {
                if (this.errors.remove((Object)editor) != null) {
                    if (this.errors.isEmpty()) {
                        this.fireErrorMessageEvent(null);
                    } else {
                        this.fireErrorMessageEvent(this.errors.values().iterator().next());
                    }
                }
            } else {
                this.errors.put(editor, message);
                this.fireErrorMessageEvent(message);
            }
        }
    }

    public void addListener(ITableListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITableListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInputChangedEvent() {
        List<ITableListener> list = this.listeners;
        synchronized (list) {
            for (ITableListener listener : this.listeners) {
                listener.onInputChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireErrorMessageEvent(String message) {
        List<ITableListener> list = this.listeners;
        synchronized (list) {
            for (ITableListener listener : this.listeners) {
                listener.onError(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFocusChangedEvent(String message) {
        List<ITableListener> list = this.listeners;
        synchronized (list) {
            for (ITableListener listener : this.listeners) {
                listener.onFocus(message);
            }
        }
    }

    public void onFocus(String message) {
        this.fireFocusChangedEvent(message);
    }

    public void onModeChange(LinkEditor.Mode mode, ArgumentDescriptor descriptor) {
        Control[] children;
        if (this.modeMap == null) {
            this.modeMap = new HashMap<ArgumentDescriptor, LinkEditor.Mode>();
        }
        this.modeMap.put(descriptor, mode);
        ArrayList<ITableListener> copy = new ArrayList<ITableListener>(this.listeners);
        for (ITableListener listener : copy) {
            listener.onModeChange(mode);
        }
        this.errors.clear();
        this.fireErrorMessageEvent(null);
        this.table.removeAll();
        Control[] controlArray = children = this.table.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.createTableContent();
    }

    public static interface ITableListener {
        public void onInputChanged();

        public void onError(String var1);

        public void onFocus(String var1);

        public void onModeChange(LinkEditor.Mode var1);
    }
}

