/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.query.arguments;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.registry.ArgumentSet;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.internal.browser.QueryContextHelp;
import org.eclipse.mat.ui.internal.query.arguments.ArgumentsWizardPage;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ArgumentsWizard
extends Wizard {
    private IQueryContext context;
    private ArgumentSet argumentSet;
    private QueryContextHelp helpPopup;

    public ArgumentsWizard(IQueryContext context, ArgumentSet argumentSet) {
        this.context = context;
        this.argumentSet = argumentSet;
        this.setWindowTitle(argumentSet.getQueryDescriptor().getName());
        this.setForcePreviousAndNextButtons(false);
        this.setDefaultPageImageDescriptor(MemoryAnalyserPlugin.getImageDescriptor("icons/fill_arguments_wiz.gif"));
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                ArgumentsWizard.this.relocateHelp(false);
            }
        };
        this.getShell().addListener(11, listener);
        this.getShell().addListener(10, listener);
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings workbenchDialogSettings = MemoryAnalyserPlugin.getDefault().getDialogSettings();
        IDialogSettings result = workbenchDialogSettings.getSection(ArgumentsWizard.class.getName());
        if (result == null) {
            result = workbenchDialogSettings.addNewSection(ArgumentsWizard.class.getName());
        }
        return result;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ArgumentsWizardPage(this.context, this.argumentSet));
        this.relocateHelp(true);
    }

    public void relocateHelp(boolean create) {
        if (this.argumentSet.getQueryDescriptor().isHelpAvailable() && (create || this.helpPopup != null && this.helpPopup.getShell() != null)) {
            if (this.getShell() == null) {
                this.helpPopup.close();
                return;
            }
            this.getShell().getDisplay().timerExec(100, new Runnable(){

                public void run() {
                    if (ArgumentsWizard.this.getShell() != null && !ArgumentsWizard.this.getShell().isDisposed()) {
                        Rectangle myBounds = ArgumentsWizard.this.getShell().getBounds();
                        Rectangle helpBounds = new Rectangle(myBounds.x, myBounds.y + myBounds.height, myBounds.width, -1);
                        if (ArgumentsWizard.this.helpPopup != null) {
                            ArgumentsWizard.this.helpPopup.resize(helpBounds);
                            return;
                        }
                        ArgumentsWizard.this.helpPopup = new QueryContextHelp(ArgumentsWizard.this.getShell(), ArgumentsWizard.this.argumentSet.getQueryDescriptor(), helpBounds);
                        ArgumentsWizard.this.helpPopup.open();
                    }
                }
            });
        }
    }

    public boolean performFinish() {
        return true;
    }
}

