/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.ui.snapshot.editor.ISnapshotEditorInput;
import org.eclipse.mat.ui.snapshot.views.Messages;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class SnapshotOutlinePage
extends Page
implements IContentOutlinePage {
    protected TreeViewer treeViewer;

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 768);
        this.createColumns();
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new OutlineContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new OutlineLabelProvider());
        this.updateSnapshotInput();
    }

    protected void createColumns() {
        TreeColumn column = new TreeColumn(this.treeViewer.getTree(), 16384);
        column.setText(Messages.col_property);
        column.setWidth(160);
        column = new TreeColumn(this.treeViewer.getTree(), 16384);
        column.setText(Messages.col_file);
        column.setWidth(80);
    }

    protected void updateSnapshotInput() {
        ArrayList<Object> elements = new ArrayList<Object>();
        SnapshotInfo info = this.getSnapshot();
        if (info != null) {
            int p;
            SnapshotInfo bInfo = this.getBaseline();
            if (bInfo == null) {
                bInfo = new SnapshotInfo(null, null, null, 0, null, 0, 0, 0, 0, 0L);
            }
            String filename = (p = info.getPath().lastIndexOf(File.separatorChar)) >= 0 ? info.getPath().substring(p + 1) : info.getPath();
            String bFilename = null;
            if (bInfo.getPath() != null) {
                p = bInfo.getPath().lastIndexOf(File.separatorChar);
                bFilename = p >= 0 ? bInfo.getPath().substring(p + 1) : bInfo.getPath();
            }
            elements.add(new Label(Messages.resource, filename, bFilename));
            Category category = new Category(Messages.general_info);
            elements.add(category);
            category.addChild(new Label(Messages.format, info.getProperty("$heapFormat"), bInfo.getProperty("$heapFormat")));
            category.addChild(new Label(Messages.time, info.getCreationDate(), bInfo.getCreationDate()));
            category.addChild(new Label(Messages.date, info.getCreationDate(), bInfo.getCreationDate()));
            category.addChild(new Label(Messages.identifier_size, info.getIdentifierSize(), bInfo.getIdentifierSize()));
            category.addChild(new Label(Messages.file_path, info.getPath(), bInfo.getPath()));
            Double fileLength = new Double((double)new File(info.getPath()).length() / 1048576.0);
            Double bFileLength = bInfo.getPath() != null ? new Double((double)new File(bInfo.getPath()).length() / 1048576.0) : null;
            category.addChild(new Label(Messages.file_length, fileLength, bFileLength));
            category = new Category(Messages.statistic_info);
            elements.add(category);
            category.addChild(new Label(Messages.heap, info.getUsedHeapSize(), bInfo.getUsedHeapSize()));
            category.addChild(new Label(Messages.number_of_objects, info.getNumberOfObjects(), bInfo.getNumberOfObjects()));
            category.addChild(new Label(Messages.number_of_classes, info.getNumberOfClasses(), bInfo.getNumberOfClasses()));
            category.addChild(new Label(Messages.number_of_classloaders, info.getNumberOfClassLoaders(), bInfo.getNumberOfClassLoaders()));
            category.addChild(new Label(Messages.number_of_gc_roots, info.getNumberOfGCRoots(), bInfo.getNumberOfGCRoots()));
        } else if (this.getSnapshotPath() != null) {
            IPath path = this.getSnapshotPath();
            File osFile = path.toFile();
            elements.add(new Label(Messages.resource, path.lastSegment(), null));
            Category category = new Category(Messages.general_info);
            elements.add(category);
            category.addChild(new Label(Messages.format, null, null));
            category.addChild(new Label(Messages.time, new Date(osFile.lastModified()), null));
            category.addChild(new Label(Messages.date, new Date(osFile.lastModified()), null));
            category.addChild(new Label(Messages.identifier_size, null, null));
            category.addChild(new Label(Messages.file_path, path.toOSString(), null));
            Double fileLength = new Double((double)osFile.length() / 1048576.0);
            category.addChild(new Label(Messages.file_length, fileLength, null));
        }
        this.treeViewer.getTree().setRedraw(false);
        this.treeViewer.setInput(elements);
        this.treeViewer.expandAll();
        this.treeViewer.getTree().setRedraw(true);
    }

    protected abstract IPath getSnapshotPath();

    protected abstract SnapshotInfo getSnapshot();

    protected abstract SnapshotInfo getBaseline();

    public Control getControl() {
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.treeViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    class Category {
        String categoryId;
        protected List<Label> children = new ArrayList<Label>();

        public Category(String categoryId) {
            this.categoryId = categoryId;
        }

        public String getCategoryId() {
            return this.categoryId;
        }

        public void addChild(Label label) {
            this.children.add(label);
        }
    }

    public static class HeapEditorOutlinePage
    extends SnapshotOutlinePage
    implements ISnapshotEditorInput.IChangeListener {
        private ISnapshotEditorInput snapshotInput;

        public HeapEditorOutlinePage(ISnapshotEditorInput input) {
            this.snapshotInput = input;
            this.snapshotInput.addChangeListener(this);
        }

        protected void createColumns() {
            super.createColumns();
            TreeColumn column = new TreeColumn(this.treeViewer.getTree(), 16384);
            column.setText(Messages.baseline);
            column.setWidth(80);
        }

        public void onSnapshotLoaded(ISnapshot snapshot) {
            this.updateSnapshotInput();
        }

        public void onBaselineLoaded(ISnapshot snapshot) {
            this.updateSnapshotInput();
        }

        protected SnapshotInfo getBaseline() {
            return this.snapshotInput.hasBaseline() ? this.snapshotInput.getBaseline().getSnapshotInfo() : null;
        }

        protected SnapshotInfo getSnapshot() {
            if (this.snapshotInput == null) {
                return null;
            }
            return this.snapshotInput.hasSnapshot() ? this.snapshotInput.getSnapshot().getSnapshotInfo() : null;
        }

        protected IPath getSnapshotPath() {
            return this.snapshotInput.getPath();
        }

        public void dispose() {
            if (this.snapshotInput != null) {
                this.snapshotInput.removeChangeListener(this);
                this.snapshotInput = null;
            }
            super.dispose();
        }
    }

    class Label {
        String text;
        Object snapshotValue;
        Object baselineValue;

        public Label(String typeId, Object snapshotValue, Object baselineValue) {
            this.text = typeId;
            this.snapshotValue = snapshotValue;
            this.baselineValue = baselineValue;
        }

        public String getText() {
            return this.text;
        }

        public Object getBaselineValue() {
            return this.baselineValue;
        }

        public Object getSnapshotValue() {
            return this.snapshotValue;
        }
    }

    class OutlineContentProvider
    implements ITreeContentProvider {
        List<Object> elements;

        OutlineContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.elements = (List)newInput;
        }

        public Object[] getElements(Object inputElement) {
            return this.elements.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            return parentElement instanceof Category ? ((Category)parentElement).children.toArray() : null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Category;
        }

        public void dispose() {
        }
    }

    class OutlineLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        OutlineLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Category) {
                return columnIndex == 0 ? ((Category)element).getCategoryId() : null;
            }
            if (element instanceof Label) {
                Object obj;
                Label label = (Label)element;
                if (columnIndex == 0) {
                    return label.getText();
                }
                Object object = obj = columnIndex == 1 ? label.getSnapshotValue() : label.getBaselineValue();
                if (obj == null) {
                    return null;
                }
                if (Messages.identifier_size.equals(label.getText())) {
                    int identifierSize = (Integer)obj;
                    return MessageUtil.format((String)Messages.identifier_format, (Object[])new Object[]{identifierSize});
                }
                if (obj instanceof Long || obj instanceof Integer) {
                    return ((Number)obj).longValue() == 0L ? null : NumberFormat.getInstance().format(obj);
                }
                if (obj instanceof Double) {
                    return new DecimalFormat("#,##0.0 M").format(obj);
                }
                if (obj instanceof Date) {
                    return Messages.date.equals(label.getText()) ? DateFormat.getDateInstance().format(obj) : DateFormat.getTimeInstance().format(obj);
                }
                return String.valueOf(obj);
            }
            return null;
        }
    }
}

