/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.NumberFormat;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayIntBig;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.inspections.FindLeaksQuery;
import org.eclipse.mat.inspections.threads.ThreadInfoQuery;
import org.eclipse.mat.inspections.util.ObjectTreeFactory;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.snapshot.inspections.MultiplePath2GCRootsQuery;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.IMultiplePathsFromGCRootsComputer;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsClassRecord;
import org.eclipse.mat.snapshot.MultiplePathsFromGCRootsRecord;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.extension.ITroubleTicketResolver;
import org.eclipse.mat.snapshot.model.GCRootInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IStackFrame;
import org.eclipse.mat.snapshot.model.IThreadStack;
import org.eclipse.mat.snapshot.query.Icons;
import org.eclipse.mat.snapshot.query.PieFactory;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.snapshot.registry.TroubleTicketResolverRegistry;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandName(value="leakhunter")
public class LeakHunterQuery
implements IQuery {
    private static final Set<String> REFERENCE_FIELD_SET = new HashSet<String>(Arrays.asList("referent"));
    static final String SYSTEM_CLASSLOADER = Messages.LeakHunterQuery_SystemClassLoader;
    static NumberFormat percentFormatter = new DecimalFormat("0.00%");
    static NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false)
    public int threshold_percent = 10;
    @Argument(isMandatory=false)
    public int max_paths = 10000;
    @Argument(isMandatory=false, advice=Argument.Advice.CLASS_NAME_PATTERN, flag="skip")
    public Pattern skipPattern = Pattern.compile("java.*|com\\.sun\\..*");
    private long totalHeap;
    private final IProgressListener voidListener = new VoidProgressListener();
    private IProgressListener listener;

    public IResult execute(IProgressListener listener) throws Exception {
        this.listener = listener;
        this.totalHeap = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        listener.subTask(Messages.LeakHunterQuery_FindingProblemSuspects);
        FindLeaksQuery.SuspectsResultTable findLeaksResult = this.callFindLeaks(this.voidListener);
        FindLeaksQuery.SuspectRecord[] leakSuspects = findLeaksResult.getData();
        SectionSpec result = new SectionSpec(Messages.LeakHunterQuery_LeakHunter);
        listener.subTask(Messages.LeakHunterQuery_PreparingResults);
        if (leakSuspects.length > 0) {
            PieFactory pie = new PieFactory(this.snapshot);
            int num = 0;
            while (num < leakSuspects.length) {
                FindLeaksQuery.SuspectRecord rec = leakSuspects[num];
                pie.addSlice(rec.suspect.getObjectId(), MessageUtil.format((String)Messages.LeakHunterQuery_ProblemSuspect, (Object[])new Object[]{num + 1}), rec.suspect.getUsedHeapSize(), rec.suspectRetained);
                ++num;
            }
            result.add((Spec)new QuerySpec(Messages.LeakHunterQuery_Overview, (IResult)pie.build()));
            HashMap<Integer, List<Integer>> accPoint2ProblemNr = new HashMap<Integer, List<Integer>>();
            int problemNum = 0;
            FindLeaksQuery.SuspectRecord[] suspectRecordArray = leakSuspects;
            int n = leakSuspects.length;
            int n2 = 0;
            while (n2 < n) {
                FindLeaksQuery.SuspectRecord rec = suspectRecordArray[n2];
                ++problemNum;
                FindLeaksQuery.AccumulationPoint ap = rec.getAccumulationPoint();
                if (ap != null) {
                    List<Integer> numbers = accPoint2ProblemNr.get(ap.getObject().getObjectId());
                    if (numbers == null) {
                        numbers = new ArrayList<Integer>(2);
                        accPoint2ProblemNr.put(ap.getObject().getObjectId(), numbers);
                    }
                    numbers.add(problemNum);
                }
                CompositeResult suspectDetails = this.getLeakSuspectDescription(rec, listener);
                suspectDetails.setStatus(ITestResult.Status.ERROR);
                QuerySpec spec = new QuerySpec(MessageUtil.format((String)Messages.LeakHunterQuery_ProblemSuspect, (Object[])new Object[]{problemNum}));
                spec.setResult((IResult)suspectDetails);
                spec.set("rendering.pattern", "overview_details");
                spec.set("html.is_important", Boolean.TRUE.toString());
                result.add((Spec)spec);
                ++n2;
            }
            List<CompositeResult> hints = this.findCommonPathForSuspects(accPoint2ProblemNr);
            int k = 0;
            while (k < hints.size()) {
                QuerySpec spec = new QuerySpec(MessageUtil.format((String)Messages.LeakHunterQuery_Hint, (Object[])new Object[]{k + 1}));
                spec.setResult((IResult)hints.get(k));
                spec.set("rendering.pattern", "overview_details");
                spec.set("html.is_important", Boolean.TRUE.toString());
                result.add((Spec)spec);
                ++k;
            }
        }
        if (result.getChildren().size() != 0) {
            return result;
        }
        return new TextResult(Messages.LeakHunterQuery_NothingFound);
    }

    private FindLeaksQuery.SuspectsResultTable callFindLeaks(IProgressListener listener) throws Exception {
        return (FindLeaksQuery.SuspectsResultTable)SnapshotQuery.lookup("find_leaks", this.snapshot).setArgument("threshold_percent", this.threshold_percent).setArgument("max_paths", this.max_paths).execute(listener);
    }

    private boolean isThreadRelated(FindLeaksQuery.SuspectRecord suspect) throws SnapshotException {
        return this.isThread(suspect.getSuspect().getObjectId());
    }

    private boolean isThread(int objectId) throws SnapshotException {
        GCRootInfo[] gcRootInfo = this.snapshot.getGCRootInfo(objectId);
        if (gcRootInfo != null) {
            GCRootInfo[] gCRootInfoArray = gcRootInfo;
            int n = gcRootInfo.length;
            int n2 = 0;
            while (n2 < n) {
                GCRootInfo singleInfo = gCRootInfoArray[n2];
                if (singleInfo.getType() == 256) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private CompositeResult getLeakSuspectDescription(FindLeaksQuery.SuspectRecord suspect, IProgressListener listener) throws SnapshotException {
        if (suspect instanceof FindLeaksQuery.SuspectRecordGroupOfObjects) {
            return this.getLeakDescriptionGroupOfObjects((FindLeaksQuery.SuspectRecordGroupOfObjects)suspect);
        }
        return this.getLeakDescriptionSingleObject(suspect, listener);
    }

    private CompositeResult getLeakDescriptionSingleObject(FindLeaksQuery.SuspectRecord suspect, IProgressListener listener) throws SnapshotException {
        String classloaderName;
        IClassLoader suspectClassloader;
        String className;
        StringBuilder overview = new StringBuilder(256);
        TextResult overviewResult = new TextResult();
        HashSet<String> keywords = new HashSet<String>();
        ArrayList<IObject> objectsForTroubleTicketInfo = new ArrayList<IObject>(2);
        int suspectId = suspect.getSuspect().getObjectId();
        boolean isThreadRelated = this.isThreadRelated(suspect);
        if (isThreadRelated) {
            overview.append("<p>");
            overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Thread, (Object[])new Object[]{suspect.getSuspect().getDisplayName(), this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
            overview.append("</p>");
        } else if (this.snapshot.isClassLoader(suspectId)) {
            IClassLoader suspectClassloader2 = (IClassLoader)suspect.getSuspect();
            objectsForTroubleTicketInfo.add(suspectClassloader2);
            String classloaderName2 = this.getClassloarerName(suspectClassloader2, keywords);
            overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ClassLoader, (Object[])new Object[]{classloaderName2, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
        } else if (this.snapshot.isClass(suspectId)) {
            className = ((IClass)suspect.getSuspect()).getName();
            keywords.add(className);
            suspectClassloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getSuspect()).getClassLoaderId());
            objectsForTroubleTicketInfo.add(suspect.getSuspect());
            classloaderName = this.getClassloarerName(suspectClassloader, keywords);
            overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Class, (Object[])new Object[]{className, classloaderName, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
        } else {
            int referrerId;
            className = suspect.getSuspect().getClazz().getName();
            keywords.add(className);
            suspectClassloader = (IClassLoader)this.snapshot.getObject(suspect.getSuspect().getClazz().getClassLoaderId());
            objectsForTroubleTicketInfo.add(suspect.getSuspect());
            classloaderName = this.getClassloarerName(suspectClassloader, keywords);
            overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Instance, (Object[])new Object[]{className, classloaderName, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
            if (this.skipPattern.matcher(className).matches() && !isThreadRelated && (referrerId = this.findReferrer(suspect.getSuspect().getObjectId())) != -1) {
                IObject referrer = this.snapshot.getObject(referrerId);
                IObject referrerClassloader = null;
                if (this.snapshot.isClassLoader(referrerId)) {
                    referrerClassloader = referrer;
                    objectsForTroubleTicketInfo.add(suspectClassloader);
                    String referrerClassloaderName = this.getClassloarerName(referrerClassloader, keywords);
                    overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedBy, (Object[])new Object[]{referrerClassloaderName}));
                } else if (this.snapshot.isClass(referrerId)) {
                    referrerClassloader = this.snapshot.getObject(((IClass)referrer).getClassLoaderId());
                    objectsForTroubleTicketInfo.add(referrer);
                    String referrerClassloaderName = this.getClassloarerName(referrerClassloader, keywords);
                    overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedByClass, (Object[])new Object[]{className, referrerClassloaderName}));
                } else {
                    if (this.isThread(referrerId)) {
                        isThreadRelated = true;
                        suspectId = referrerId;
                    }
                    referrerClassloader = this.snapshot.getObject(referrer.getClazz().getClassLoaderId());
                    objectsForTroubleTicketInfo.add(referrer);
                    String referrerClassloaderName = this.getClassloarerName(referrerClassloader, keywords);
                    overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedByInstance, (Object[])new Object[]{referrer.getDisplayName(), referrerClassloaderName}));
                }
            }
        }
        if (suspect.getAccumulationPoint() != null) {
            String classloaderName3;
            IObject accumulationObject = suspect.getAccumulationPoint().getObject();
            int accumulationPointId = accumulationObject.getObjectId();
            if (this.snapshot.isClassLoader(accumulationPointId)) {
                IClassLoader accPointClassloader = (IClassLoader)accumulationObject;
                objectsForTroubleTicketInfo.add(accPointClassloader);
                String classloaderName4 = this.getClassloarerName(accPointClassloader, keywords);
                overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_AccumulatedBy, (Object[])new Object[]{classloaderName4}));
            } else if (this.snapshot.isClass(accumulationPointId)) {
                IClass clazz = (IClass)accumulationObject;
                keywords.add(clazz.getName());
                IClassLoader accPointClassloader = (IClassLoader)this.snapshot.getObject(clazz.getClassLoaderId());
                objectsForTroubleTicketInfo.add(accumulationObject);
                classloaderName3 = this.getClassloarerName(accPointClassloader, keywords);
                overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_AccumulatedByLoadedBy, (Object[])new Object[]{clazz.getName(), classloaderName3}));
            } else {
                String className2 = accumulationObject.getClazz().getName();
                keywords.add(className2);
                IClassLoader accPointClassloader = (IClassLoader)this.snapshot.getObject(accumulationObject.getClazz().getClassLoaderId());
                objectsForTroubleTicketInfo.add(accumulationObject);
                classloaderName3 = this.getClassloarerName(accPointClassloader, keywords);
                overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_AccumulatedByInstance, (Object[])new Object[]{className2, classloaderName3}));
            }
        }
        ThreadInfoQuery.Result threadDetails = null;
        if (isThreadRelated) {
            threadDetails = this.extractThreadData(suspectId, keywords, objectsForTroubleTicketInfo, overview, overviewResult);
        }
        overview.append("<br><br>");
        this.appendKeywords(keywords, overview);
        this.appendTroubleTicketInformation(objectsForTroubleTicketInfo, overview);
        CompositeResult composite = new CompositeResult(new IResult[0]);
        overviewResult.setText(overview.toString());
        composite.addResult(Messages.LeakHunterQuery_Description, (IResult)overviewResult);
        IObject describedObject = suspect.getAccumulationPoint() != null ? suspect.getAccumulationPoint().getObject() : suspect.getSuspect();
        try {
            IResult result = SnapshotQuery.lookup("path2gc", this.snapshot).set("object", describedObject).execute(listener);
            composite.addResult(Messages.LeakHunterQuery_ShortestPaths, result);
        }
        catch (Exception e) {
            throw new SnapshotException(Messages.LeakHunterQuery_ErrorShortestPaths, (Throwable)e);
        }
        IResult objectInDominatorTree = this.showInDominatorTree(describedObject.getObjectId());
        composite.addResult(Messages.LeakHunterQuery_AccumulatedObjects, objectInDominatorTree);
        IResult histogramOfDominated = this.getHistogramOfDominated(describedObject.getObjectId());
        if (histogramOfDominated != null) {
            composite.addResult(Messages.LeakHunterQuery_AccumulatedObjectsByClass, histogramOfDominated);
        }
        if (threadDetails != null) {
            composite.addResult(Messages.LeakHunterQuery_ThreadDetails, (IResult)threadDetails);
        }
        return composite;
    }

    /*
     * WARNING - void declaration
     */
    private CompositeResult getLeakDescriptionGroupOfObjects(FindLeaksQuery.SuspectRecordGroupOfObjects suspect) throws SnapshotException {
        void var11_12;
        StringBuilder builder = new StringBuilder(256);
        HashSet<String> keywords = new HashSet<String>();
        ArrayList<IObject> involvedClassLoaders = new ArrayList<IObject>(2);
        String className = ((IClass)suspect.getSuspect()).getName();
        keywords.add(className);
        IClassLoader classloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getSuspect()).getClassLoaderId());
        involvedClassLoaders.add(suspect.getSuspect());
        String classloaderName = this.getClassloarerName(classloader, keywords);
        String numberOfInstances = numberFormatter.format((long)suspect.getSuspectInstances().length);
        builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_InstancesOccupy, (Object[])new Object[]{numberOfInstances, className, classloaderName, this.formatRetainedHeap(suspect.getSuspectRetained(), this.totalHeap)}));
        int[] suspectInstances = suspect.getSuspectInstances();
        ArrayList<Object> bigSuspectInstances = new ArrayList<Object>();
        boolean bl = false;
        while (var11_12 < suspectInstances.length) {
            IObject inst = this.snapshot.getObject(suspectInstances[var11_12]);
            if (inst.getRetainedHeapSize() < this.totalHeap / 100L) break;
            bigSuspectInstances.add(inst);
            ++var11_12;
        }
        if (bigSuspectInstances.size() > 0) {
            builder.append("<p>").append(Messages.LeakHunterQuery_BiggestInstances);
            builder.append("<ul>");
            for (IObject iObject : bigSuspectInstances) {
                builder.append("<li>").append(iObject.getDisplayName());
                builder.append("&nbsp;-&nbsp;").append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_Bytes, (Object[])new Object[]{this.formatRetainedHeap(iObject.getRetainedHeapSize(), this.totalHeap)}));
            }
            builder.append("</ul>");
            builder.append("</p>");
        }
        if (suspect.getAccumulationPoint() != null) {
            IClassLoader accPointClassloader;
            int n = suspect.getAccumulationPoint().getObject().getObjectId();
            if (this.snapshot.isClassLoader(n)) {
                involvedClassLoaders.add((IClassLoader)suspect.getAccumulationPoint().getObject());
                classloaderName = this.getClassloarerName(suspect.getAccumulationPoint().getObject(), keywords);
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedFromClassLoader, (Object[])new Object[]{classloaderName}));
            } else if (this.snapshot.isClass(n)) {
                className = ((IClass)suspect.getAccumulationPoint().getObject()).getName();
                keywords.add(className);
                accPointClassloader = (IClassLoader)this.snapshot.getObject(((IClass)suspect.getAccumulationPoint().getObject()).getClassLoaderId());
                involvedClassLoaders.add(suspect.getAccumulationPoint().getObject());
                classloaderName = this.getClassloarerName(accPointClassloader, keywords);
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedFromClass, (Object[])new Object[]{className, classloaderName}));
            } else {
                className = suspect.getAccumulationPoint().getObject().getClazz().getName();
                keywords.add(className);
                accPointClassloader = (IClassLoader)this.snapshot.getObject(suspect.getAccumulationPoint().getObject().getClazz().getClassLoaderId());
                involvedClassLoaders.add(suspect.getAccumulationPoint().getObject());
                classloaderName = this.getClassloarerName(accPointClassloader, keywords);
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_ReferencedFromInstance, (Object[])new Object[]{className, classloaderName}));
            }
        }
        builder.append("<br><br>");
        this.appendKeywords(keywords, builder);
        this.appendTroubleTicketInformation(involvedClassLoaders, builder);
        CompositeResult compositeResult = new CompositeResult(new IResult[0]);
        compositeResult.addResult(Messages.LeakHunterQuery_Description, (IResult)new TextResult(builder.toString(), true));
        FindLeaksQuery.AccumulationPoint accPoint = suspect.getAccumulationPoint();
        if (accPoint != null) {
            compositeResult.addResult(Messages.LeakHunterQuery_CommonPath, (IResult)MultiplePath2GCRootsQuery.create(this.snapshot, suspect.getPathsComputer(), suspect.getCommonPath()));
        } else {
            IResult result = this.findReferencePattern(suspect);
            if (result != null) {
                compositeResult.addResult(Messages.LeakHunterQuery_ReferencePattern, result);
            }
        }
        return compositeResult;
    }

    private String formatRetainedHeap(long retained, long totalHeap) {
        return String.valueOf(numberFormatter.format(retained)) + " (" + percentFormatter.format((double)retained / (double)totalHeap) + ")";
    }

    private Map<String, String> getTroubleTicketMapping(ITroubleTicketResolver resolver, List<IObject> classloaders) throws SnapshotException {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (IObject suspect : classloaders) {
            String old;
            String ticket = null;
            String key = null;
            if (suspect instanceof IClassLoader) {
                ticket = resolver.resolveByClassLoader((IClassLoader)suspect, (IProgressListener)new VoidProgressListener());
                if (ticket != null && !"".equals(ticket.trim()) && (key = suspect.getClassSpecificName()) == null) {
                    key = suspect.getTechnicalName();
                }
            } else {
                IClass clazz = suspect instanceof IClass ? (IClass)suspect : suspect.getClazz();
                ticket = resolver.resolveByClass(clazz, this.listener);
                key = clazz.getName();
            }
            if (ticket == null || (old = mapping.put(ticket, key)) == null) continue;
            mapping.put(ticket, String.valueOf(key) + ", " + old);
        }
        return mapping;
    }

    private String getName(IObject object) {
        String name = object.getClassSpecificName();
        if (name == null) {
            name = object.getTechnicalName();
        }
        return name;
    }

    private String getClassloarerName(IObject classloader, Set<String> keywords) {
        if (classloader.getObjectAddress() == 0L) {
            return SYSTEM_CLASSLOADER;
        }
        String classloaderName = this.getName(classloader);
        if (keywords != null) {
            keywords.add(classloaderName);
        }
        return classloaderName;
    }

    private IResult showInDominatorTree(int objectId) throws SnapshotException {
        Stack<Integer> tmp = new Stack<Integer>();
        int e = objectId;
        while (e != -1) {
            tmp.push(e);
            e = this.snapshot.getImmediateDominatorId(e);
        }
        ObjectTreeFactory.TreePathBuilder treeBuilder = new ObjectTreeFactory.TreePathBuilder(this.snapshot.getSnapshotInfo().getUsedHeapSize());
        treeBuilder.setIsOutgoing();
        treeBuilder.addBranch((Integer)tmp.pop());
        while (tmp.size() > 0) {
            treeBuilder.addChild(e, (e = ((Integer)tmp.pop()).intValue()) == objectId);
        }
        int[] dominatedByAccPoint = this.snapshot.getImmediateDominatedIds(objectId);
        int i = 0;
        while (i < 20 && i < dominatedByAccPoint.length) {
            treeBuilder.addSibling(dominatedByAccPoint[i], false);
            ++i;
        }
        return treeBuilder.build(this.snapshot);
    }

    private IResult getHistogramOfDominated(int objectId) throws SnapshotException {
        ClassHistogramRecord[] records;
        int[] dominatedByAccPoint = this.snapshot.getImmediateDominatedIds(objectId);
        Histogram h = this.snapshot.getHistogram(dominatedByAccPoint, this.voidListener);
        ClassHistogramRecord[] classHistogramRecordArray = records = h.getClassHistogramRecords().toArray(new ClassHistogramRecord[0]);
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            ClassHistogramRecord record = classHistogramRecordArray[n2];
            record.setRetainedHeapSize(this.snapshot.getMinRetainedSize(record.getObjectIds(), this.voidListener));
            ++n2;
        }
        Arrays.sort(records, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        ArrayList<ClassHistogramRecord> suspects = new ArrayList<ClassHistogramRecord>();
        int limit = 0;
        ClassHistogramRecord[] classHistogramRecordArray2 = records;
        int n3 = records.length;
        int n4 = 0;
        while (n4 < n3) {
            ClassHistogramRecord record = classHistogramRecordArray2[n4];
            if (limit >= 20) break;
            suspects.add(record);
            ++limit;
            ++n4;
        }
        ListResult result = new ListResult(ClassHistogramRecord.class, suspects, new String[]{"label", "numberOfObjects", "usedHeapSize", "retainedHeapSize"}){

            public URL getIcon(Object row) {
                return Icons.forObject(LeakHunterQuery.this.snapshot, ((ClassHistogramRecord)row).getClassId());
            }

            public IContextObject getContext(final Object row) {
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return ((ClassHistogramRecord)row).getClassId();
                    }

                    public int[] getObjectIds() {
                        return ((ClassHistogramRecord)row).getObjectIds();
                    }

                    public String getOQL() {
                        return null;
                    }
                };
            }
        };
        return result;
    }

    private void appendKeywords(Set<String> keywords, StringBuilder builder) {
        builder.append("<b>").append(Messages.LeakHunterQuery_Keywords).append("</b><br>");
        for (String s : keywords) {
            builder.append(s).append("<br>");
        }
    }

    private void appendTroubleTicketInformation(List<IObject> classloaders, StringBuilder builder) throws SnapshotException {
        for (ITroubleTicketResolver resolver : TroubleTicketResolverRegistry.instance().delegates()) {
            Map<String, String> mapping = this.getTroubleTicketMapping(resolver, classloaders);
            if (mapping.isEmpty()) continue;
            builder.append("<br><b>").append(resolver.getTicketSystem()).append("</b><br>");
            for (Map.Entry<String, String> entry : mapping.entrySet()) {
                builder.append(MessageUtil.format((String)Messages.LeakHunterQuery_TicketForSuspect, (Object[])new Object[]{entry.getKey(), entry.getValue()})).append("<br>");
            }
        }
    }

    private ThreadInfoQuery.Result extractThreadData(int threadId, Set<String> keywords, List<IObject> involvedClassloaders, StringBuilder builder, TextResult textResult) {
        ThreadInfoQuery.Result threadDetails = null;
        try {
            int contextClassloaderId;
            IThreadStack stack;
            threadDetails = (ThreadInfoQuery.Result)SnapshotQuery.lookup("thread_details", this.snapshot).set("threadIds", threadId).execute(this.listener);
            IThreadInfo threadInfo = threadDetails.getThreads().get(0);
            keywords.addAll(threadInfo.getKeywords());
            CompositeResult requestInfos = threadInfo.getRequests();
            if (requestInfos != null && !requestInfos.isEmpty()) {
                builder.append("<p>");
                for (CompositeResult.Entry requestInfo : requestInfos.getResultEntries()) {
                    builder.append(requestInfo.getName()).append(" ").append(textResult.linkTo(Messages.LeakHunterQuery_RequestDetails, requestInfo.getResult())).append("<br>");
                }
                builder.append("</p>");
            }
            if ((stack = this.snapshot.getThreadStack(threadId)) != null) {
                StringBuilder stackBuilder = new StringBuilder();
                IObject threadObject = this.snapshot.getObject(threadId);
                stackBuilder.append(threadObject.getClassSpecificName()).append("\r\n");
                IStackFrame[] iStackFrameArray = stack.getStackFrames();
                int n = iStackFrameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IStackFrame frame = iStackFrameArray[n2];
                    stackBuilder.append("  ").append(frame.getText()).append("\r\n");
                    ++n2;
                }
                QuerySpec stackResult = new QuerySpec(Messages.LeakHunterQuery_ThreadStack, (IResult)new TextResult(stackBuilder.toString()));
                builder.append("<p>");
                builder.append(String.valueOf(Messages.LeakHunterQuery_StackTraceAvailable) + " ").append(textResult.linkTo(Messages.LeakHunterQuery_SeeStackstrace, (IResult)stackResult)).append('.');
                builder.append("</p>");
            }
            if ((contextClassloaderId = threadInfo.getContextClassLoaderId()) != 0) {
                involvedClassloaders.add((IClassLoader)this.snapshot.getObject(contextClassloaderId));
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.LeakHunterQuery_ErrorRetrievingRequestDetails, e);
        }
        return threadDetails;
    }

    private IResult findReferencePattern(FindLeaksQuery.SuspectRecordGroupOfObjects suspect) throws SnapshotException {
        Object[] allPaths;
        MultiplePathsFromGCRootsClassRecord dummy = new MultiplePathsFromGCRootsClassRecord(null, -1, true, this.snapshot);
        Object[] objectArray = allPaths = suspect.getPathsComputer().getAllPaths(this.voidListener);
        int n = allPaths.length;
        int n2 = 0;
        while (n2 < n) {
            Object path = objectArray[n2];
            dummy.addPath((int[])path);
            ++n2;
        }
        MultiplePathsFromGCRootsClassRecord[] classRecords = dummy.nextLevel();
        int numPaths = allPaths.length;
        double threshold = (double)numPaths * 0.9;
        ArrayList<IClass> referencePattern = new ArrayList<IClass>();
        Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
        MultiplePathsFromGCRootsClassRecord r = classRecords[0];
        while ((double)r.getCount() > threshold) {
            referencePattern.add(r.getClazz());
            classRecords = r.nextLevel();
            if (classRecords == null || classRecords.length == 0) break;
            Arrays.sort(classRecords, MultiplePathsFromGCRootsClassRecord.getComparatorByNumberOfReferencedObjects());
            r = classRecords[0];
        }
        if (referencePattern.isEmpty()) {
            return null;
        }
        ObjectTreeFactory.TreePathBuilder treeBuilder = new ObjectTreeFactory.TreePathBuilder(this.snapshot.getSnapshotInfo().getUsedHeapSize());
        treeBuilder.addBranch(((IClass)referencePattern.get(0)).getObjectId());
        int i = 1;
        while (i < referencePattern.size()) {
            treeBuilder.addChild(((IClass)referencePattern.get(i)).getObjectId(), false);
            ++i;
        }
        return treeBuilder.build(this.snapshot);
    }

    private List<CompositeResult> findCommonPathForSuspects(HashMap<Integer, List<Integer>> accPoint2ProblemNr) throws SnapshotException {
        ArrayList<CompositeResult> result = new ArrayList<CompositeResult>(2);
        int[] objectIds = new int[accPoint2ProblemNr.size()];
        int j = 0;
        for (Integer accPointId : accPoint2ProblemNr.keySet()) {
            objectIds[j++] = accPointId;
        }
        HashMap<IClass, Set<String>> excludeMap = new HashMap<IClass, Set<String>>();
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.ref.WeakReference", true);
        if (classes != null) {
            for (IClass clazz : classes) {
                excludeMap.put(clazz, REFERENCE_FIELD_SET);
            }
        }
        IMultiplePathsFromGCRootsComputer comp = this.snapshot.getMultiplePathsFromGCRoots(objectIds, excludeMap);
        MultiplePathsFromGCRootsRecord[] records = comp.getPathsByGCRoot(this.voidListener);
        Arrays.sort(records, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
        MultiplePathsFromGCRootsRecord[] multiplePathsFromGCRootsRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            int[] referencedAccumulationPoints;
            MultiplePathsFromGCRootsRecord rec = multiplePathsFromGCRootsRecordArray[n2];
            if (rec.getCount() < 2) break;
            CompositeResult composite = new CompositeResult(new IResult[0]);
            ArrayList<Integer> problemIds = new ArrayList<Integer>(4);
            int[] nArray = referencedAccumulationPoints = rec.getReferencedObjects();
            int n3 = referencedAccumulationPoints.length;
            int n4 = 0;
            while (n4 < n3) {
                int accPointId = nArray[n4];
                for (Integer problemId : accPoint2ProblemNr.get(accPointId)) {
                    problemIds.add(problemId);
                }
                ++n4;
            }
            Collections.sort(problemIds);
            StringBuilder overview = new StringBuilder(256);
            StringBuilder left = new StringBuilder();
            int k = 0;
            while (k < problemIds.size() - 1) {
                if (left.length() > 0) {
                    left.append(", ");
                }
                left.append(problemIds.get(k));
                ++k;
            }
            overview.append(MessageUtil.format((String)Messages.LeakHunterQuery_Msg_SuspectsRelated, (Object[])new Object[]{left.toString(), problemIds.get(problemIds.size() - 1)}));
            composite.addResult(Messages.LeakHunterQuery_Overview, (IResult)new TextResult(overview.toString(), true));
            MultiplePathsFromGCRootsRecord parentRecord = rec;
            ArrayIntBig commonPath = new ArrayIntBig();
            while (parentRecord.getCount() == rec.getCount()) {
                commonPath.add(parentRecord.getObjectId());
                MultiplePathsFromGCRootsRecord[] children = parentRecord.nextLevel();
                if (children == null || children.length == 0) break;
                Arrays.sort(children, MultiplePathsFromGCRootsRecord.getComparatorByNumberOfReferencedObjects());
                parentRecord = children[0];
            }
            composite.addResult(Messages.LeakHunterQuery_CommonPath, (IResult)MultiplePath2GCRootsQuery.create(this.snapshot, comp, commonPath.toArray()));
            result.add(composite);
            ++n2;
        }
        return result;
    }

    private int findReferrer(int objectId) throws SnapshotException {
        int n;
        BitField skipped = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        Collection<IClass> classes = this.snapshot.getClassesByName(this.skipPattern, false);
        for (IClass clazz : classes) {
            int[] nArray = clazz.getObjectIds();
            n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int instance = nArray[n2];
                skipped.set(instance);
                ++n2;
            }
        }
        BitField visited = new BitField(this.snapshot.getSnapshotInfo().getNumberOfObjects());
        LinkedList<int[]> fifo = new LinkedList<int[]>();
        fifo.add(new int[]{objectId});
        while (fifo.size() > 0) {
            int[] e;
            int[] nArray = e = (int[])fifo.removeFirst();
            int n3 = e.length;
            n = 0;
            while (n < n3) {
                int referrer = nArray[n];
                if (!visited.get(referrer)) {
                    if (skipped.get(referrer)) {
                        int[] referrers = this.snapshot.getInboundRefererIds(referrer);
                        fifo.add(referrers);
                        visited.set(referrer);
                    } else {
                        return referrer;
                    }
                }
                ++n;
            }
        }
        return -1;
    }
}

