/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot.registry;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.MATPlugin;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.RegistryReader;

public final class ClassSpecificNameResolverRegistry {
    private static ClassSpecificNameResolverRegistry instance = new ClassSpecificNameResolverRegistry();
    private RegistryImpl registry = new RegistryImpl();

    public static ClassSpecificNameResolverRegistry instance() {
        return instance;
    }

    private ClassSpecificNameResolverRegistry() {
    }

    @Deprecated
    public static void registerResolver(String className, IClassSpecificNameResolver resolver) {
        ClassSpecificNameResolverRegistry.instance().registry.resolvers.put(className, resolver);
    }

    public static String resolve(IObject object) {
        if (object == null) {
            throw new NullPointerException(Messages.ClassSpecificNameResolverRegistry_Error_MissingObject);
        }
        return ClassSpecificNameResolverRegistry.instance().registry.doResolve(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistryImpl
    extends RegistryReader<IClassSpecificNameResolver> {
        private Map<String, IClassSpecificNameResolver> resolvers = new HashMap<String, IClassSpecificNameResolver>();

        public RegistryImpl() {
            this.init(MATPlugin.getDefault().getExtensionTracker(), "org.eclipse.mat.api.nameResolver");
        }

        public IClassSpecificNameResolver createDelegate(IConfigurationElement configElement) {
            try {
                IClassSpecificNameResolver resolver = (IClassSpecificNameResolver)configElement.createExecutableExtension("impl");
                String[] subjects = this.extractSubjects(resolver);
                if (subjects != null && subjects.length > 0) {
                    int ii = 0;
                    while (ii < subjects.length) {
                        this.resolvers.put(subjects[ii], resolver);
                        ++ii;
                    }
                } else {
                    String msg = MessageUtil.format((String)Messages.ClassSpecificNameResolverRegistry_ErrorMsg_MissingSubject, (Object[])new Object[]{resolver.getClass().getName()});
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, msg);
                }
                return resolver;
            }
            catch (CoreException e) {
                String msg = MessageUtil.format((String)Messages.ClassSpecificNameResolverRegistry_ErrorMsg_WhileCreatingResolver, (Object[])new Object[]{configElement.getAttribute("impl")});
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, msg, e);
                return null;
            }
        }

        protected void removeDelegate(IClassSpecificNameResolver delegate) {
            Iterator<IClassSpecificNameResolver> iter = this.resolvers.values().iterator();
            while (iter.hasNext()) {
                IClassSpecificNameResolver r = iter.next();
                if (r != delegate) continue;
                iter.remove();
            }
        }

        private String doResolve(IObject object) {
            try {
                IClass clazz = object.getClazz();
                while (clazz != null) {
                    IClassSpecificNameResolver resolver = this.resolvers.get(clazz.getName());
                    if (resolver != null) {
                        return resolver.resolve(object);
                    }
                    clazz = clazz.getSuperClass();
                }
                return null;
            }
            catch (RuntimeException e) {
                Logger.getLogger(ClassSpecificNameResolverRegistry.class.getName()).log(Level.SEVERE, MessageUtil.format((String)Messages.ClassSpecificNameResolverRegistry_ErrorMsg_DuringResolving, (Object[])new Object[]{object.getTechnicalName()}), e);
                return null;
            }
            catch (SnapshotException e) {
                Logger.getLogger(ClassSpecificNameResolverRegistry.class.getName()).log(Level.SEVERE, MessageUtil.format((String)Messages.ClassSpecificNameResolverRegistry_ErrorMsg_DuringResolving, (Object[])new Object[]{object.getTechnicalName()}), e);
                return null;
            }
        }

        private String[] extractSubjects(IClassSpecificNameResolver instance) {
            String[] stringArray;
            Subjects subjects = instance.getClass().getAnnotation(Subjects.class);
            if (subjects != null) {
                return subjects.value();
            }
            Subject subject = instance.getClass().getAnnotation(Subject.class);
            if (subject != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = subject.value();
            } else {
                stringArray = null;
            }
            return stringArray;
        }
    }
}

