/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class ImageHelper {
    private static final String[] IMAGES = new String[]{"class_obj", "instance_obj", "classloader_obj", "array_obj", "class_obj_gc_root", "instance_obj_gc_root", "classloader_obj_gc_root", "array_obj_gc_root", "class", "package"};
    private static final String PREFIX_OVERLAY = "icons/decorations/";
    private static final String PREFIX = "icons/heapobjects/";
    private static HashMapIntObject<ImageDescriptor> IMAGES_BY_TYPE = new HashMapIntObject();

    public static int getType(IObject object) {
        boolean isGCRoot = false;
        try {
            isGCRoot = object.getGCRootInfo() != null;
        }
        catch (SnapshotException snapshotException) {}
        if (object == null) {
            // empty if block
        }
        if (object instanceof IClass) {
            return isGCRoot ? 4 : 0;
        }
        if (object instanceof IClassLoader) {
            return isGCRoot ? 6 : 2;
        }
        if (object.getClazz().isArrayType()) {
            return isGCRoot ? 7 : 3;
        }
        return isGCRoot ? 5 : 1;
    }

    public static ImageDescriptor getImageDescriptor(int type) {
        ImageDescriptor id = (ImageDescriptor)IMAGES_BY_TYPE.get(type);
        if (id == null) {
            id = MemoryAnalyserPlugin.getImageDescriptor(PREFIX + IMAGES[type] + ".gif");
            IMAGES_BY_TYPE.put(type, (Object)id);
        }
        return id;
    }

    public static Image getImage(int type) {
        return MemoryAnalyserPlugin.getDefault().getImage(ImageHelper.getImageDescriptor(type));
    }

    public static ImageDescriptor getInboundImageDescriptor(int type) {
        ImageDescriptor id = (ImageDescriptor)IMAGES_BY_TYPE.get(type + 10);
        if (id == null) {
            id = ImageHelper.createOverlay(IMAGES[type], "in.gif");
            IMAGES_BY_TYPE.put(type + 10, (Object)id);
        }
        return id;
    }

    public static Image getInboundImage(int type) {
        return MemoryAnalyserPlugin.getDefault().getImage(ImageHelper.getInboundImageDescriptor(type));
    }

    public static ImageDescriptor getOutboundImageDescriptor(int type) {
        ImageDescriptor id = (ImageDescriptor)IMAGES_BY_TYPE.get(type + 20);
        if (id == null) {
            id = ImageHelper.createOverlay(IMAGES[type], "out.gif");
            IMAGES_BY_TYPE.put(type + 20, (Object)id);
        }
        return id;
    }

    public static Image getOutboundImage(int type) {
        return MemoryAnalyserPlugin.getDefault().getImage(ImageHelper.getOutboundImageDescriptor(type));
    }

    public static ImageDescriptor decorate(int type, ImageDescriptor overlay) {
        Image base = ImageHelper.getImage(type);
        Image over = MemoryAnalyserPlugin.getDefault().getImage(overlay);
        return new OverlayImageDescriptor(base, over);
    }

    private static ImageDescriptor createOverlay(String baseName, String overlayName) {
        Image base = MemoryAnalyserPlugin.getImage(PREFIX + baseName + ".gif");
        Image overlay = MemoryAnalyserPlugin.getImage(PREFIX_OVERLAY + overlayName);
        return new OverlayImageDescriptor(base, overlay);
    }

    public static interface Decorations {
        public static final String GC_ROOT = "icons/decorations/gc_root.gif";
    }

    public static class ImageImageDescriptor
    extends ImageDescriptor {
        private Image fImage;

        public ImageImageDescriptor(Image image) {
            this.fImage = image;
        }

        public ImageData getImageData() {
            return this.fImage.getImageData();
        }

        public boolean equals(Object obj) {
            return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass()) && this.fImage.equals((Object)((ImageImageDescriptor)((Object)obj)).fImage);
        }

        public int hashCode() {
            return this.fImage.hashCode();
        }
    }

    static class OverlayImageDescriptor
    extends CompositeImageDescriptor {
        ImageData base;
        ImageData overlay;

        public OverlayImageDescriptor(Image base, Image overlay) {
            this.base = base.getImageData();
            this.overlay = overlay.getImageData();
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(this.overlay, 0, height - this.overlay.height);
        }

        protected Point getSize() {
            return new Point(16, 16);
        }
    }

    public static interface Type {
        public static final int CLASS_INSTANCE = 0;
        public static final int OBJECT_INSTANCE = 1;
        public static final int CLASSLOADER_INSTANCE = 2;
        public static final int ARRAY_INSTANCE = 3;
        public static final int CLASS_INSTANCE_GC_ROOT = 4;
        public static final int OBJECT_INSTANCE_GC_ROOT = 5;
        public static final int CLASSLOADER_INSTANCE_GC_ROOT = 6;
        public static final int ARRAY_INSTANCE_GC_ROOT = 7;
        public static final int CLASS = 8;
        public static final int PACKAGE = 9;
    }
}

