/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.resolver;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.mat.jruby.resolver.Messages;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeapDumpProxy {
    public static <T> T make(Class<T> fakeInterface, Class<?> realClass, IObject heapDumpObject) {
        return HeapDumpProxy.make(fakeInterface.getClassLoader(), fakeInterface, realClass, heapDumpObject);
    }

    private static <T> T make(ClassLoader loader, Class<T> fakeInterface, Class<?> realClass, IObject heapDumpObject) {
        Class<?> heapDumpClass;
        if (fakeInterface.equals(String.class)) {
            ProxyString proxyString = HeapDumpProxy.make(loader, ProxyString.class, realClass, heapDumpObject);
            return HeapDumpProxy.unsafeCast(new String(proxyString.value(), proxyString.offset(), proxyString.count()));
        }
        try {
            heapDumpClass = Class.forName(heapDumpObject.getClazz().getName(), false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.HeapDumpProxy_UnknownClass, (Object)heapDumpObject.getClazz().getName()), e);
        }
        if (!realClass.isAssignableFrom(heapDumpClass)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.HeapDumpProxy_TypeMismatch, heapDumpClass, realClass));
        }
        Object proxy = Proxy.newProxyInstance(loader, new Class[]{fakeInterface}, (InvocationHandler)new Handler(loader, realClass, heapDumpObject));
        return fakeInterface.cast(proxy);
    }

    public static <T> T unsafeCast(Object obj) {
        return (T)obj;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Handler
    implements InvocationHandler {
        private final ClassLoader loader;
        private final Class<?> realClass;
        private final IObject heapDumpObject;

        public Handler(ClassLoader loader, Class<?> realClass, IObject heapDumpObject) {
            this.loader = loader;
            this.realClass = realClass;
            this.heapDumpObject = heapDumpObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Field field;
            String methodName = method.getName();
            if (methodName.equals("equals")) {
                Object other = args[0];
                if (Proxy.isProxyClass(other.getClass())) {
                    return this.equals(Proxy.getInvocationHandler(proxy));
                }
                return false;
            }
            if (methodName.equals("hashCode")) {
                return this.hashCode();
            }
            try {
                field = this.realClass.getDeclaredField(methodName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new RuntimeException(NLS.bind((String)Messages.HeapDumpProxy_NoSuchField, (Object)this.realClass.getName(), (Object)methodName));
            }
            Class<?> fieldType = field.getType();
            Object fieldValue = this.heapDumpObject.resolveValue(methodName);
            if (fieldValue == null) {
                return null;
            }
            if (fieldType.isPrimitive()) {
                if (fieldType.equals(Integer.TYPE)) {
                    return Integer.parseInt(((Integer)fieldValue).toString());
                }
                if (fieldType.equals(Boolean.TYPE)) {
                    return Boolean.parseBoolean(((Boolean)fieldValue).toString());
                }
                throw new UnsupportedOperationException(Messages.HeapDumpProxy_NotImplemented);
            }
            if (fieldType.isArray()) {
                if (fieldType.getComponentType().isPrimitive()) {
                    return ((IObject)fieldValue).getClassSpecificName().toCharArray();
                }
                IObjectArray fieldValueArray = (IObjectArray)fieldValue;
                long[] elements = fieldValueArray.getReferenceArray();
                Class<?> fieldElementType = fieldType.getComponentType();
                ISnapshot snapshot = fieldValueArray.getSnapshot();
                Class<?> returnElementType = method.getReturnType().getComponentType();
                Object[] returnArray = (Object[])Array.newInstance(returnElementType, elements.length);
                int i = 0;
                while (i < elements.length) {
                    int mapAddressToId = snapshot.mapAddressToId(elements[i]);
                    returnArray[i] = HeapDumpProxy.make(this.loader, returnElementType, fieldElementType, snapshot.getObject(mapAddressToId));
                    ++i;
                }
                return returnArray;
            }
            IObject returnObject = (IObject)fieldValue;
            Class<?> returnType = method.getReturnType();
            return HeapDumpProxy.make(this.loader, returnType, fieldType, returnObject);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Handler)) {
                return false;
            }
            Handler other = (Handler)obj;
            return this.heapDumpObject.equals(other.heapDumpObject);
        }

        public int hashCode() {
            return 47 * this.heapDumpObject.hashCode();
        }
    }

    public static interface ProxyString {
        public char[] value();

        public int offset();

        public int count();
    }
}

