/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.jruby.resolver.HeapDumpProxy;
import org.eclipse.mat.jruby.resolver.Messages;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.CompositeResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IRequestDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.osgi.util.NLS;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.internal.runtime.RubyRunnable;
import org.jruby.runtime.ThreadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Subject(value="org.jruby.internal.runtime.RubyRunnable")
public class RubyStacktraceDumper
implements IRequestDetailsResolver {
    public void complement(ISnapshot snapshot, IThreadInfo thread, int[] javaLocals, int thisJavaLocal, IProgressListener listener) throws SnapshotException {
        Ruby ruby = null;
        try {
            ruby = Ruby.newInstance();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            thread.addRequest(Messages.RubyStacktraceDumper_NoJRuby, (IResult)new TextResult(Messages.RubyStacktraceDumper_NoJRubyDetails, true));
            return;
        }
        for (Map.Entry<String, ThreadContext.RubyStackTraceElement[]> entry : RubyStacktraceDumper.getAllStackTraces(snapshot).entrySet()) {
            String javaThreadName = entry.getKey();
            ThreadContext.RubyStackTraceElement[] backtraceFrames = entry.getValue();
            CompositeResult result = new CompositeResult(new IResult[0]);
            RubyArray backtrace = (RubyArray)ThreadContext.createBacktraceFromFrames((Ruby)ruby, (ThreadContext.RubyStackTraceElement[])backtraceFrames);
            if (javaThreadName == null && backtrace.size() == 1 && "<script>:1".equals(((String)backtrace.get(0)).trim()) || !thread.getThreadObject().getClassSpecificName().equals(javaThreadName)) continue;
            StringBuilder stackTrace = new StringBuilder();
            for (Object element : backtrace) {
                stackTrace.append(NLS.bind((String)Messages.RubyStacktraceDumper_StackTraceLine, element));
            }
            String summary = NLS.bind((String)Messages.RubyStacktraceDumper_Summary, (Object)javaThreadName);
            if (javaThreadName == null) {
                javaThreadName = Messages.RubyStacktraceDumper_UnknownThread;
            }
            result.addResult(NLS.bind((String)Messages.RubyStacktraceDumper_ResultHeader, (Object)javaThreadName), (IResult)new TextResult(stackTrace.toString(), true));
            thread.addRequest(summary, (IResult)result);
            thread.addKeyword("thread_details");
        }
    }

    public static Map<String, ThreadContext.RubyStackTraceElement[]> getAllStackTraces(ISnapshot model) throws SnapshotException {
        HashMap<RubyThreadProxy, String> javaThreadNameForRubyThread = new HashMap<RubyThreadProxy, String>();
        Collection classesByName = model.getClassesByName(RubyRunnable.class.getName(), false);
        for (IClass rubyRunnableClass : classesByName) {
            int[] objectIds;
            int[] nArray = objectIds = rubyRunnableClass.getObjectIds();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int id = nArray[n2];
                IObject runnable = model.getObject(id);
                RubyRunnableProxy runnableProxy = HeapDumpProxy.make(RubyRunnableProxy.class, RubyRunnable.class, runnable);
                RubyThreadProxy rubyThread = runnableProxy.rubyThread();
                ThreadProxy thread = runnableProxy.javaThread();
                if (thread != null) {
                    String threadName = new String(thread.name());
                    javaThreadNameForRubyThread.put(rubyThread, threadName);
                }
                ++n2;
            }
        }
        HashMap<String, ThreadContext.RubyStackTraceElement[]> stackTraces = new HashMap<String, ThreadContext.RubyStackTraceElement[]>();
        Collection classesByName2 = model.getClassesByName(ThreadContext.class.getName(), false);
        for (IClass threadContextClass : classesByName2) {
            int[] objectIds;
            int[] nArray = objectIds = threadContextClass.getObjectIds();
            int n = objectIds.length;
            int n3 = 0;
            while (n3 < n) {
                int id = nArray[n3];
                IObject threadContext = model.getObject(id);
                ThreadContextProxy threadContextProxy = HeapDumpProxy.make(ThreadContextProxy.class, ThreadContext.class, threadContext);
                RubyThreadProxy rubyThread = threadContextProxy.thread();
                String javaThreadName = (String)javaThreadNameForRubyThread.get(rubyThread);
                String currentFile = threadContextProxy.file();
                int currentLine = threadContextProxy.line();
                FrameProxy[] frames = threadContextProxy.frameStack();
                int frameIndex = threadContextProxy.frameIndex();
                int traceSize = frameIndex + 2;
                ThreadContext.RubyStackTraceElement[] backtraceFrames = new ThreadContext.RubyStackTraceElement[traceSize];
                backtraceFrames[0] = new ThreadContext.RubyStackTraceElement(Messages.RubyStacktraceDumper_Unknown, Messages.RubyStacktraceDumper_Unknown, currentFile, currentLine + 1, false);
                int i = 0;
                while (i <= frameIndex) {
                    FrameProxy frame = frames[i];
                    String frameFileName = frame.fileName();
                    int frameLine = frame.line();
                    String methodName = RubyStacktraceDumper.getMethodNameFromFrame(frame);
                    String moduleName = RubyStacktraceDumper.getClassNameFromFrame(frame);
                    boolean isBindingFrame = frame.isBindingFrame();
                    backtraceFrames[traceSize - 1 - i] = new ThreadContext.RubyStackTraceElement(moduleName, methodName, frameFileName, frameLine + 1, isBindingFrame);
                    ++i;
                }
                stackTraces.put(javaThreadName, backtraceFrames);
                ++n3;
            }
        }
        return stackTraces;
    }

    private static String getClassNameFromFrame(FrameProxy current) {
        String fullName;
        String klazzName = Messages.RubyStacktraceDumper_Unknown;
        RubyModuleProxy klazz = current.klazz();
        if (klazz != null && (fullName = klazz.fullName()) != null) {
            klazzName = fullName;
        }
        return klazzName;
    }

    private static String getMethodNameFromFrame(FrameProxy current) {
        String methodName = current.name();
        if (current.name() == null) {
            methodName = Messages.RubyStacktraceDumper_Unknown;
        }
        return methodName;
    }

    public static interface FrameProxy {
        public String fileName();

        public int line();

        public String name();

        public RubyModuleProxy klazz();

        public boolean isBindingFrame();
    }

    public static interface RubyModuleProxy {
        public String fullName();
    }

    public static interface RubyRunnableProxy {
        public RubyThreadProxy rubyThread();

        public ThreadProxy javaThread();
    }

    public static interface RubyThreadProxy {
    }

    public static interface ThreadContextProxy {
        public RubyThreadProxy thread();

        public FrameProxy[] frameStack();

        public int frameIndex();

        public String file();

        public int line();
    }

    public static interface ThreadProxy {
        public char[] name();
    }
}

