/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mat.jruby.Messages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class JRubyPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mat.jruby";
    public static final String RESOLVER_PLUGIN_ID = "org.eclipse.mat.jruby.resolver";
    public static final String JRUBY_PLUGIN_ID = "org.jruby.jruby";
    public static final String RUBY_CLASS = "org.jruby.Ruby";
    public static final String CHECK_ON_STARTUP_PREFERENCE = "checkOnStartup";
    private static JRubyPlugin plugin;
    private static ServiceTracker bundleTracker;

    static {
        bundleTracker = null;
    }

    public JRubyPlugin() {
        plugin = this;
    }

    public static JRubyPlugin getDefault() {
        return plugin;
    }

    public synchronized void start(BundleContext context) throws Exception {
        super.start(context);
        bundleTracker = new ServiceTracker(context, PackageAdmin.class.getName(), null);
        bundleTracker.open();
    }

    public synchronized void stop(BundleContext context) throws Exception {
        if (bundleTracker != null) {
            bundleTracker.close();
            bundleTracker = null;
        }
        super.stop(context);
    }

    public static void log(String message) {
        JRubyPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static void log(String message, Throwable throwable) {
        JRubyPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message, throwable));
    }

    public static boolean isRubyInstalled() {
        try {
            JRubyPlugin.getResolverBundle().loadClass(RUBY_CLASS);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }

    public static boolean checkOnStartup() {
        return JRubyPlugin.getDefault().getPreferenceStore().getBoolean(CHECK_ON_STARTUP_PREFERENCE);
    }

    public static Bundle getResolverBundle() {
        Bundle[] bundles;
        Bundle[] bundleArray = bundles = JRubyPlugin.getDefault().getBundle().getBundleContext().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle b = bundleArray[n2];
            if (b.getSymbolicName().equals(RESOLVER_PLUGIN_ID)) {
                return b;
            }
            ++n2;
        }
        return null;
    }

    public static PackageAdmin getPackageAdmin() {
        if (bundleTracker == null) {
            JRubyPlugin.log(Messages.JRubyPlugin_BundleNoActivatedError);
            return null;
        }
        return (PackageAdmin)bundleTracker.getService();
    }
}

