/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mat.jruby.JRubyPlugin;
import org.eclipse.mat.jruby.operations.Messages;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

public abstract class AbstractJRubyBundleOperation
implements IRunnableWithProgress,
FrameworkListener {
    private Object syncMonitor = new Object();
    private Throwable error;

    protected abstract void doExecute() throws BundleException;

    protected abstract String getTaskName();

    protected abstract String getSubTaskName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(this.getTaskName(), 2);
        JRubyPlugin.getDefault().getBundle().getBundleContext().addFrameworkListener((FrameworkListener)this);
        try {
            this.error = null;
            monitor.subTask(this.getSubTaskName());
            try {
                this.doExecute();
            }
            catch (BundleException e) {
                throw new InvocationTargetException(e);
            }
            monitor.worked(1);
            monitor.subTask(Messages.AbstractJRubyBundleOperation_RefreshingPackages);
            Object object = this.syncMonitor;
            synchronized (object) {
                this.checkForError();
                JRubyPlugin.getPackageAdmin().refreshPackages(new Bundle[]{JRubyPlugin.getResolverBundle()});
                this.syncMonitor.wait();
                this.checkForError();
            }
            monitor.worked(1);
        }
        finally {
            JRubyPlugin.getDefault().getBundle().getBundleContext().removeFrameworkListener((FrameworkListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent e) {
        if (e.getType() == 4) {
            Object object = this.syncMonitor;
            synchronized (object) {
                this.syncMonitor.notify();
            }
        }
        if (e.getType() == 2 && e.getBundle().getSymbolicName().equals("org.jruby.jruby")) {
            Object object = this.syncMonitor;
            synchronized (object) {
                this.error = e.getThrowable();
            }
        }
    }

    private void checkForError() throws InvocationTargetException {
        if (this.error != null) {
            throw new InvocationTargetException(this.error);
        }
    }
}

