/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.ui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mat.jruby.JRubyPlugin;
import org.eclipse.mat.jruby.operations.InstallJRubyBundleOperation;
import org.eclipse.mat.jruby.operations.ReinstallJRubyBundleOperation;
import org.eclipse.mat.jruby.ui.InstallJRubyWizardModel;
import org.eclipse.mat.jruby.ui.InstallJRubyWizardPage;
import org.eclipse.mat.jruby.ui.Messages;

public class InstallJRubyWizard
extends Wizard {
    private boolean onStartup;
    private InstallJRubyWizardModel model;
    private InstallJRubyWizardPage page;

    public InstallJRubyWizard() {
        this(false);
    }

    public InstallJRubyWizard(boolean onStartup) {
        this.setWindowTitle(Messages.InstallJRubyWizard_Title);
        this.setNeedsProgressMonitor(true);
        this.onStartup = onStartup;
        this.model = new InstallJRubyWizardModel();
    }

    public void addPages() {
        this.page = new InstallJRubyWizardPage(this.model);
        this.addPage((IWizardPage)this.page);
    }

    public boolean isOnStartup() {
        return this.onStartup;
    }

    public boolean performCancel() {
        this.storeCheckOnStartupPreference();
        return super.performCancel();
    }

    public boolean performFinish() {
        this.storeCheckOnStartupPreference();
        String location = (String)this.model.getLocationValue().getValue();
        String url = new File(location).toURI().toString();
        Object operation = null;
        operation = JRubyPlugin.isRubyInstalled() ? new ReinstallJRubyBundleOperation(url) : new InstallJRubyBundleOperation(url);
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            JRubyPlugin.log(Messages.InstallJRubyWizard_InstallRubyBundleError, e);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private void storeCheckOnStartupPreference() {
        if (this.onStartup) {
            boolean currentValue = JRubyPlugin.checkOnStartup();
            boolean newValue = (Boolean)this.model.getCheckOnStartupValue().getValue();
            if (newValue != currentValue) {
                IPreferenceStore store = JRubyPlugin.getDefault().getPreferenceStore();
                store.setValue("checkOnStartup", newValue);
            }
        }
    }
}

