/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.ui;

import java.io.File;
import java.io.IOException;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mat.jruby.JRubyPlugin;
import org.eclipse.mat.jruby.ui.Messages;

public class InstallJRubyWizardModel {
    private IObservableValue locationValue = new WritableValue(null, String.class);
    private IObservableValue checkOnStartupValue = new WritableValue((Object)JRubyPlugin.checkOnStartup(), Boolean.class);

    public IObservableValue getLocationValue() {
        return this.locationValue;
    }

    public IObservableValue getCheckOnStartupValue() {
        return this.checkOnStartupValue;
    }

    static class LocationValidator
    implements IValidator {
        LocationValidator() {
        }

        public IStatus validate(Object value) {
            String location = (String)value;
            if (location == null || location.trim().length() == 0) {
                return ValidationStatus.error((String)Messages.InstallJRubyWizardPage_EmptyLocationError);
            }
            File file = new File(location);
            if (!file.exists()) {
                return ValidationStatus.error((String)Messages.InstallJRubyWizardPage_NotFoundError);
            }
            try {
                JarFile jar = new JarFile(file);
                Manifest manifest = jar.getManifest();
                if (manifest == null) {
                    return ValidationStatus.error((String)Messages.InstallJRubyWizardPage_NoManifestError);
                }
                String symbolicName = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
                if (!"org.jruby.jruby".equals(symbolicName)) {
                    return ValidationStatus.error((String)Messages.InstallJRubyWizardPage_InvalidJRubyJarError);
                }
            }
            catch (IOException iOException) {
                return ValidationStatus.error((String)Messages.InstallJRubyWizardPage_InvalidJarError);
            }
            return ValidationStatus.ok();
        }
    }
}

