/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.ui;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mat.jruby.JRubyPlugin;
import org.eclipse.mat.jruby.ui.InstallJRubyWizard;
import org.eclipse.mat.jruby.ui.InstallJRubyWizardModel;
import org.eclipse.mat.jruby.ui.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class InstallJRubyWizardPage
extends WizardPage {
    private InstallJRubyWizardModel model;

    public InstallJRubyWizardPage(InstallJRubyWizardModel model) {
        super("wizardPage");
        this.setTitle(Messages.InstallJRubyWizardPage_Title);
        this.setDescription(Messages.InstallJRubyWizardPage_Description);
        this.model = model;
    }

    public void createControl(Composite parent) {
        DataBindingContext dbc = new DataBindingContext();
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        Composite container = new Composite(parent, 0);
        Label locationLabel = new Label(container, 0);
        locationLabel.setText(Messages.InstallJRubyWizardPage_FileLocation);
        final Text locationText = new Text(container, 2052);
        locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)locationText, (int)24), this.model.getLocationValue(), new UpdateValueStrategy().setAfterConvertValidator((IValidator)new InstallJRubyWizardModel.LocationValidator()), null);
        final Button browseButton = new Button(container, 8);
        browseButton.setText(Messages.InstallJRubyWizardPage_Browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(browseButton.getShell(), 0x10000000);
                dialog.setText(Messages.InstallJRubyWizardPage_FileDialogTitle);
                dialog.setFilterExtensions(new String[]{"*.jar"});
                String location = dialog.open();
                if (location != null) {
                    locationText.setText(location);
                }
            }
        });
        Label helpText = new Label(container, 0);
        helpText.setText(Messages.InstallJRubyWizardPage_HelpMessage);
        helpText.setLayoutData((Object)new GridData(64, 1024, true, true, 2, 1));
        if (this.isOnStartup()) {
            Button checkOnStartupCheckbox = new Button(container, 32);
            checkOnStartupCheckbox.setText(Messages.JRubyPreferencePage_CheckOnStartup);
            checkOnStartupCheckbox.setLayoutData((Object)new GridData(4, 1024, true, true, 2, 1));
            checkOnStartupCheckbox.setSelection(JRubyPlugin.checkOnStartup());
            dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)checkOnStartupCheckbox), this.model.getCheckOnStartupValue(), null, null);
        }
        GridLayoutFactory.swtDefaults().numColumns(3).generateLayout(container);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
    }

    private boolean isOnStartup() {
        IWizard wizard = this.getWizard();
        if (wizard instanceof InstallJRubyWizard) {
            InstallJRubyWizard jrubyWizard = (InstallJRubyWizard)wizard;
            return jrubyWizard.isOnStartup();
        }
        return false;
    }
}

