/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.jruby.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mat.jruby.JRubyPlugin;
import org.eclipse.mat.jruby.operations.UninstallJRubyBundleOperation;
import org.eclipse.mat.jruby.ui.InstallJRubyWizard;
import org.eclipse.mat.jruby.ui.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JRubyPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Label jrubyStatusLabel;
    private Button installButton;
    private Button uninstallButton;
    private Bundle bundle;
    private BundleContext bundleContext;
    private IObservableValue checkOnStartupValue;

    public JRubyPreferencePage() {
        this.setDescription(Messages.JRubyPreferencePage_Description);
    }

    public void init(IWorkbench workbench) {
        this.bundle = JRubyPlugin.getDefault().getBundle();
        this.bundleContext = this.bundle.getBundleContext();
        this.checkOnStartupValue = new WritableValue((Object)JRubyPlugin.checkOnStartup(), Boolean.class);
    }

    protected Control createContents(Composite parent) {
        DataBindingContext dbc = new DataBindingContext();
        Composite container = new Composite(parent, 0);
        this.jrubyStatusLabel = new Label(container, 0);
        this.jrubyStatusLabel.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.installButton = new Button(container, 8);
        this.installButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.installButton.setText(Messages.JRubyPreferencePage_Install);
        this.installButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallJRubyWizard wizard = new InstallJRubyWizard();
                new WizardDialog(JRubyPreferencePage.this.getShell(), (IWizard)wizard).open();
                JRubyPreferencePage.this.updateLabels();
            }
        });
        this.uninstallButton = new Button(container, 8);
        this.uninstallButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.uninstallButton.setText(Messages.JRubyPreferencePage_Uninstall);
        this.uninstallButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean confirmed = MessageDialog.openQuestion((Shell)JRubyPreferencePage.this.getShell(), (String)Messages.JRubyPreferencePage_ConfirmUninstallTitle, (String)Messages.JRubyPreferencePage_ConfirmUninstallDescription);
                if (confirmed) {
                    UninstallJRubyBundleOperation operation = new UninstallJRubyBundleOperation();
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    try {
                        service.run(false, false, (IRunnableWithProgress)operation);
                    }
                    catch (InvocationTargetException exc) {
                        JRubyPlugin.log(Messages.JRubyPreferencePage_UninstallJRubyBundleError, exc);
                    }
                    catch (InterruptedException interruptedException) {}
                    JRubyPreferencePage.this.updateLabels();
                }
            }
        });
        new Label(container, 0);
        Button checkOnStartupCheckbox = new Button(container, 32);
        checkOnStartupCheckbox.setText(Messages.JRubyPreferencePage_CheckOnStartup);
        checkOnStartupCheckbox.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)checkOnStartupCheckbox), this.checkOnStartupValue, null, null);
        this.updateLabels();
        GridLayoutFactory.swtDefaults().margins(0, 5).numColumns(2).generateLayout(container);
        return container;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JRubyPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        boolean defaultValue = this.getPreferenceStore().getDefaultBoolean("checkOnStartup");
        this.checkOnStartupValue.setValue((Object)defaultValue);
        super.performDefaults();
    }

    public boolean performOk() {
        boolean value = (Boolean)this.checkOnStartupValue.getValue();
        this.getPreferenceStore().setValue("checkOnStartup", value);
        return super.performOk();
    }

    private void updateLabels() {
        boolean enableUninstall;
        String installButtonText;
        String statusText;
        if (JRubyPlugin.isRubyInstalled()) {
            Bundle[] bundles = this.bundleContext.getBundles();
            Bundle jrubyBundle = null;
            Bundle[] bundleArray = bundles;
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle b = bundleArray[n2];
                if (b.getSymbolicName().equals("org.jruby.jruby")) {
                    jrubyBundle = b;
                    break;
                }
                ++n2;
            }
            if (jrubyBundle == null) {
                statusText = Messages.JRubyPreferencePage_JRubyInstalledButCannotIdentify;
                installButtonText = Messages.JRubyPreferencePage_Install;
                enableUninstall = false;
            } else {
                statusText = NLS.bind((String)Messages.JRubyPreferencePage_JRubyInstalled, (Object)jrubyBundle.getVersion());
                installButtonText = Messages.JRubyPreferencePage_Reinstall;
                enableUninstall = true;
            }
        } else {
            statusText = Messages.JRubyPreferencePage_JRubyNotInstalled;
            installButtonText = Messages.JRubyPreferencePage_Install;
            enableUninstall = false;
        }
        this.jrubyStatusLabel.setText(NLS.bind((String)Messages.JRubyPreferencePage_Status, (Object)statusText));
        this.installButton.setText(installButtonText);
        this.uninstallButton.setEnabled(enableUninstall);
        this.installButton.getParent().pack();
    }
}

