/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot;

import java.io.File;
import java.math.BigInteger;
import java.text.ParsePosition;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.snapshot.ArgumentParser;
import org.eclipse.mat.internal.snapshot.SnapshotArgument;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.registry.QueryContextImpl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SnapshotQueryContext
extends QueryContextImpl {
    private ISnapshot snapshot;

    public SnapshotQueryContext(ISnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public File getPrimaryFile() {
        return new File(this.snapshot.getSnapshotInfo().getPath());
    }

    public String mapToExternalIdentifier(int objectId) throws SnapshotException {
        long address = this.snapshot.mapIdToAddress(objectId);
        return "0x" + Long.toHexString(address);
    }

    public int mapToObjectId(String externalIdentifier) throws SnapshotException {
        long objectAddress = new BigInteger(externalIdentifier.substring(2), 16).longValue();
        return this.snapshot.mapAddressToId(objectAddress);
    }

    public boolean available(Class<?> type, Argument.Advice advice) {
        block7: {
            block6: {
                block5: {
                    try {
                        if (!type.isAssignableFrom(ISnapshot.class) || advice != null) break block5;
                        return true;
                    }
                    catch (SnapshotException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!type.isAssignableFrom(SnapshotInfo.class)) break block6;
                return true;
            }
            if (this.snapshot.getSnapshotAddons(type) == null) break block7;
            return true;
        }
        return super.available(type, advice);
    }

    public Object get(Class<?> type, Argument.Advice advice) {
        if (type.isAssignableFrom(ISnapshot.class) && advice == null) {
            return this.snapshot;
        }
        if (type.isAssignableFrom(SnapshotInfo.class)) {
            return this.snapshot.getSnapshotInfo();
        }
        try {
            Object s = this.snapshot.getSnapshotAddons(type);
            if (s != null) {
                return s;
            }
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
        return super.get(type, advice);
    }

    public boolean converts(Class<?> type, Argument.Advice advice) {
        if (type.isAssignableFrom(ISnapshot.class) && advice == Argument.Advice.SECONDARY_SNAPSHOT) {
            return true;
        }
        if (type.isAssignableFrom(Integer.TYPE) && advice == Argument.Advice.HEAP_OBJECT) {
            return true;
        }
        if (type.isAssignableFrom(IObject.class)) {
            return true;
        }
        if (type.isAssignableFrom(IHeapObjectArgument.class)) {
            return true;
        }
        return super.converts(type, advice);
    }

    public String convertToString(Class<?> type, Argument.Advice advice, Object value) throws SnapshotException {
        if (type.isAssignableFrom(ISnapshot.class) && advice == Argument.Advice.SECONDARY_SNAPSHOT) {
            return ((SnapshotArgument)value).getFilename();
        }
        if (type.isAssignableFrom(Integer.TYPE) && advice == Argument.Advice.HEAP_OBJECT) {
            return this.mapToExternalIdentifier((Integer)value);
        }
        if (type.isAssignableFrom(IObject.class)) {
            return this.mapToExternalIdentifier(((IObject)value).getObjectId());
        }
        if (type.isAssignableFrom(IHeapObjectArgument.class)) {
            return value.toString();
        }
        return super.convertToString(type, advice, value);
    }

    public Object convertToValue(Class<?> type, Argument.Advice advice, String value) throws SnapshotException {
        if (type.isAssignableFrom(ISnapshot.class) && advice == Argument.Advice.SECONDARY_SNAPSHOT) {
            return new SnapshotArgument(value);
        }
        if (type.isAssignableFrom(Integer.TYPE) && advice == Argument.Advice.HEAP_OBJECT) {
            return ArgumentParser.consumeHeapObjects(this.snapshot, value);
        }
        if (type.isAssignableFrom(IObject.class)) {
            return ArgumentParser.consumeHeapObjects(this.snapshot, value);
        }
        if (type.isAssignableFrom(IHeapObjectArgument.class)) {
            return ArgumentParser.consumeHeapObjects(this.snapshot, value);
        }
        return super.convertToValue(type, advice, value);
    }

    public boolean parses(Class<?> type, Argument.Advice advice) {
        if (type.isAssignableFrom(Integer.TYPE) && advice == Argument.Advice.HEAP_OBJECT) {
            return true;
        }
        if (type.isAssignableFrom(IObject.class)) {
            return true;
        }
        return type.isAssignableFrom(IHeapObjectArgument.class);
    }

    public Object parse(Class<?> type, Argument.Advice advice, String[] args, ParsePosition pos) throws SnapshotException {
        return ArgumentParser.consumeHeapObjects(this.snapshot, args, pos);
    }

    public ContextDerivedData getContextDerivedData() {
        return new RetainedSizeDerivedData(this.snapshot);
    }
}

