/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.IOException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.DataFile;
import org.eclipse.mat.report.internal.PartsFactory;
import org.eclipse.mat.report.internal.ResultRenderer;
import org.eclipse.mat.util.IProgressListener;

public class SectionPart
extends AbstractPart {
    SectionPart(String id, AbstractPart parent, DataFile artefact, SectionSpec spec) {
        super(id, parent, artefact, spec);
        this.status = spec.getStatus();
        if (spec.getName() == null) {
            spec.setName("");
            this.params().put("html.show_heading", Boolean.FALSE.toString());
        }
    }

    void init(PartsFactory factory) {
        for (Spec child : ((SectionSpec)this.spec).getChildren()) {
            this.children.add(factory.create(this, child));
        }
    }

    public AbstractPart execute(IQueryContext context, ResultRenderer renderer, IProgressListener listener) throws SnapshotException, IOException {
        renderer.beginSection(this);
        int ii = 0;
        while (ii < this.children.size()) {
            AbstractPart part = ((AbstractPart)this.children.get(ii)).execute(context, renderer, listener);
            this.status = ITestResult.Status.max(this.status, part.status);
            this.children.set(ii, part);
            ++ii;
        }
        renderer.endSection(this);
        return this;
    }
}

