/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.CompilerImpl;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

abstract class Operation
extends Expression {
    static final String ERR_NO_COMPARABLE = Messages.Operation_ErrorNoComparable;
    static final String ERR_NOT_A_NUMBER = Messages.Operation_ErrorNotNumber;
    protected Expression[] args;

    public Operation(Expression[] args) {
        this.args = args;
    }

    public boolean isContextDependent(EvaluationContext ctx) {
        Expression[] expressionArray = this.args;
        int n = this.args.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            if (expression.isContextDependent(ctx)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Expression[] getArguments() {
        return this.args;
    }

    public abstract String getSymbol();

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        int ii = 0;
        while (ii < this.args.length) {
            if (ii != 0) {
                buf.append(this.getSymbol());
            }
            buf.append(this.args[ii]);
            ++ii;
        }
        buf.append(")");
        return buf.toString();
    }

    static boolean booleanValue(Object object) {
        if (object instanceof Number) {
            double value = ((Number)object).doubleValue();
            return value != 0.0 && value != 0.0 && !Double.isNaN(value);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return ((String)object).length() != 0;
        }
        return object != null;
    }

    static Object numberValue(Object object) {
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        if (object instanceof Float) {
            return ((Float)object).doubleValue();
        }
        return object;
    }

    static class And
    extends Operation {
        public And(Expression[] args) {
            super(args);
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Expression[] expressionArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Expression ex = expressionArray[n2];
                if (!And.booleanValue(ex.compute(ctx))) {
                    return Boolean.FALSE;
                }
                ++n2;
            }
            return Boolean.TRUE;
        }

        public String getSymbol() {
            return "and";
        }
    }

    static class Divide
    extends NumberOperation {
        public Divide(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object calculate(long left, long right) {
            return (double)left / (double)right;
        }

        Object calculate(double left, double right) {
            return left / right;
        }

        public String getSymbol() {
            return "/";
        }
    }

    static class Equal
    extends RelationalOperation {
        public Equal(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object evalNull(Object left, Object right) {
            return this.eval(left, right);
        }

        Object eval(double left, double right) {
            if (left == right) {
                return true;
            }
            return false;
        }

        Object eval(long left, long right) {
            if (left == right) {
                return true;
            }
            return false;
        }

        Object eval(Object left, Object right) {
            if (left == CompilerImpl.ConstantExpression.NULL) {
                left = null;
            }
            if (right == CompilerImpl.ConstantExpression.NULL) {
                right = null;
            }
            if (left == null) {
                if (right == null) {
                    return true;
                }
                return false;
            }
            if (right == null) {
                return false;
            }
            return left.equals(right);
        }

        public String getSymbol() {
            return "=";
        }
    }

    static class GreaterThan
    extends RelationalOperation {
        public GreaterThan(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object evalNull(Object left, Object right) {
            throw new NullPointerException(this.args[left == null ? 0 : 1].toString());
        }

        Object eval(double left, double right) {
            if (left > right) {
                return true;
            }
            return false;
        }

        Object eval(long left, long right) {
            if (left > right) {
                return true;
            }
            return false;
        }

        Object eval(Object left, Object right) {
            if (!(left instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[0], left, left.getClass().getName(), this.getSymbol()}));
            }
            if (!(right instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[1], right, right.getClass().getName(), this.getSymbol()}));
            }
            if (((Comparable)left).compareTo(right) > 0) {
                return true;
            }
            return false;
        }

        public String getSymbol() {
            return ">";
        }
    }

    static class GreaterThanOrEqual
    extends RelationalOperation {
        public GreaterThanOrEqual(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object evalNull(Object left, Object right) {
            throw new NullPointerException(this.args[left == null ? 0 : 1].toString());
        }

        Object eval(double left, double right) {
            if (left >= right) {
                return true;
            }
            return false;
        }

        Object eval(long left, long right) {
            if (left >= right) {
                return true;
            }
            return false;
        }

        Object eval(Object left, Object right) {
            if (!(left instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[0], left, left.getClass().getName(), this.getSymbol()}));
            }
            if (!(right instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[1], right, right.getClass().getName(), this.getSymbol()}));
            }
            if (((Comparable)left).compareTo(right) >= 0) {
                return true;
            }
            return false;
        }

        public String getSymbol() {
            return ">=";
        }
    }

    static class In
    extends Operation {
        public In(Expression arg1, Expression arg2) {
            super(new Expression[]{arg1, arg2});
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Object obj1 = this.args[0].compute(ctx);
            Object obj2 = this.args[1].compute(ctx);
            if (obj1 == null || obj2 == null) {
                return Boolean.FALSE;
            }
            if (obj2 instanceof List) {
                return ((List)obj2).contains(obj1);
            }
            if (obj2 instanceof Object[]) {
                Object[] objectArray = (Object[])obj2;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (obj1.equals(element)) {
                        return Boolean.TRUE;
                    }
                    ++n2;
                }
                return Boolean.FALSE;
            }
            if (obj2 instanceof int[]) {
                int leftId = -1;
                if (obj1 instanceof Integer) {
                    leftId = (Integer)obj1;
                } else if (obj1 instanceof IObject) {
                    leftId = ((IObject)obj1).getObjectId();
                } else {
                    throw new RuntimeException(MessageUtil.format((String)Messages.Operation_Error_CannotCompare, (Object[])new Object[]{obj1.getClass().getName()}));
                }
                int[] nArray = (int[])obj2;
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int objectId = nArray[n3];
                    if (leftId == objectId) {
                        return Boolean.TRUE;
                    }
                    ++n3;
                }
                return Boolean.FALSE;
            }
            if (obj2 instanceof IResultTable) {
                IResultTable other = (IResultTable)obj2;
                int count = other.getRowCount();
                int ii = 0;
                while (ii < count) {
                    if (obj1.equals(other.getColumnValue(other.getRow(ii), 0))) {
                        return Boolean.TRUE;
                    }
                    ++ii;
                }
                return Boolean.FALSE;
            }
            throw new RuntimeException(MessageUtil.format((String)Messages.Operation_Error_ArgumentOfUnknownClass, (Object[])new Object[]{obj2.getClass().getName()}));
        }

        public String getSymbol() {
            return " IN ";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InstanceOf
    extends Operation {
        private static Map<String, Set<String>> class2intf = new HashMap<String, Set<String>>();
        String className;

        public InstanceOf(Expression arg1, String className) {
            super(new Expression[]{arg1});
            this.className = className;
        }

        @Override
        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Set<String> interfaces;
            Object obj1 = this.args[0].compute(ctx);
            if (obj1 == null) {
                return Boolean.FALSE;
            }
            if (obj1 instanceof Integer) {
                obj1 = ctx.getSnapshot().getObject(((Integer)obj1).intValue());
            }
            return (interfaces = InstanceOf.getIntf(obj1.getClass())).contains(this.className) ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public String getSymbol() {
            return " INSTANCEOF ";
        }

        @Override
        public String toString() {
            return "(" + this.args[0] + this.getSymbol() + this.className + ")";
        }

        private static Set<String> getIntf(Class<?> context) {
            Set<String> intf = class2intf.get(context.getName());
            if (intf == null) {
                intf = new HashSet<String>();
                class2intf.put(context.getName(), intf);
                InstanceOf.inspect(intf, context);
            }
            return intf;
        }

        private static void inspect(Set<String> types, Class<?> clasz) {
            Class<?>[] classes;
            if (clasz == null || Object.class.equals(clasz)) {
                return;
            }
            if (!types.add(clasz.getName())) {
                return;
            }
            Class<?>[] classArray = classes = clasz.getInterfaces();
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                InstanceOf.inspect(types, c);
                ++n2;
            }
            InstanceOf.inspect(types, clasz.getSuperclass());
        }
    }

    static class LessThan
    extends RelationalOperation {
        public LessThan(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object evalNull(Object left, Object right) {
            throw new NullPointerException(this.args[left == null ? 0 : 1].toString());
        }

        Object eval(double left, double right) {
            if (left < right) {
                return true;
            }
            return false;
        }

        Object eval(long left, long right) {
            if (left < right) {
                return true;
            }
            return false;
        }

        Object eval(Object left, Object right) {
            if (!(left instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[0], left, left.getClass().getName(), this.getSymbol()}));
            }
            if (!(right instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[1], right, right.getClass().getName(), this.getSymbol()}));
            }
            if (((Comparable)left).compareTo(right) < 0) {
                return true;
            }
            return false;
        }

        public String getSymbol() {
            return "<";
        }
    }

    static class LessThanOrEqual
    extends RelationalOperation {
        public LessThanOrEqual(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object evalNull(Object left, Object right) {
            throw new NullPointerException(this.args[left == null ? 0 : 1].toString());
        }

        Object eval(double left, double right) {
            if (left <= right) {
                return true;
            }
            return false;
        }

        Object eval(long left, long right) {
            if (left <= right) {
                return true;
            }
            return false;
        }

        Object eval(Object left, Object right) {
            if (!(left instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[0], left, left.getClass().getName(), this.getSymbol()}));
            }
            if (!(right instanceof Comparable)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NO_COMPARABLE, (Object[])new Object[]{this.args[1], right, right.getClass().getName(), this.getSymbol()}));
            }
            if (((Comparable)left).compareTo(right) <= 0) {
                return true;
            }
            return false;
        }

        public String getSymbol() {
            return "<=";
        }
    }

    static class Like
    extends Operation {
        Pattern pattern;

        public Like(Expression arg1, String regex) {
            super(new Expression[]{arg1});
            this.pattern = Pattern.compile(PatternUtil.smartFix((String)regex, (boolean)false));
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Object obj1 = this.args[0].compute(ctx);
            if (obj1 == null) {
                return Boolean.FALSE;
            }
            return this.pattern.matcher(String.valueOf(obj1)).matches();
        }

        public String getSymbol() {
            return " LIKE ";
        }

        public String toString() {
            return "(" + this.args[0] + this.getSymbol() + "\"" + this.pattern.toString() + "\"" + ")";
        }
    }

    static class Minus
    extends NumberOperation {
        public Minus(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object calculate(long left, long right) {
            return left - right;
        }

        Object calculate(double left, double right) {
            return left - right;
        }

        public String getSymbol() {
            return "-";
        }
    }

    static class Multiply
    extends NumberOperation {
        public Multiply(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object calculate(long left, long right) {
            return left * right;
        }

        Object calculate(double left, double right) {
            return left * right;
        }

        public String getSymbol() {
            return "*";
        }
    }

    static class NotEqual
    extends RelationalOperation {
        public NotEqual(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object evalNull(Object left, Object right) {
            return this.eval(left, right);
        }

        Object eval(double left, double right) {
            if (left != right) {
                return true;
            }
            return false;
        }

        Object eval(long left, long right) {
            if (left != right) {
                return true;
            }
            return false;
        }

        Object eval(Object left, Object right) {
            if (left == CompilerImpl.ConstantExpression.NULL) {
                left = null;
            }
            if (right == CompilerImpl.ConstantExpression.NULL) {
                right = null;
            }
            if (left == null) {
                if (right != null) {
                    return true;
                }
                return false;
            }
            if (right == null) {
                return true;
            }
            return !left.equals(right);
        }

        public String getSymbol() {
            return "!=";
        }
    }

    static class NotIn
    extends Operation {
        public NotIn(Expression arg1, Expression arg2) {
            super(new Expression[]{arg1, arg2});
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Object obj1 = this.args[0].compute(ctx);
            Object obj2 = this.args[1].compute(ctx);
            if (obj1 == null || obj2 == null) {
                return Boolean.FALSE;
            }
            if (obj2 instanceof List) {
                return !((List)obj2).contains(obj1);
            }
            if (obj2 instanceof Object[]) {
                Object[] objectArray = (Object[])obj2;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (obj1.equals(element)) {
                        return Boolean.FALSE;
                    }
                    ++n2;
                }
                return Boolean.TRUE;
            }
            if (obj2 instanceof int[]) {
                int leftId = -1;
                if (obj1 instanceof Integer) {
                    leftId = (Integer)obj1;
                } else if (obj1 instanceof IObject) {
                    leftId = ((IObject)obj1).getObjectId();
                } else {
                    throw new RuntimeException(MessageUtil.format((String)Messages.Operation_Error_NotInCannotCompare, (Object[])new Object[]{obj1.getClass().getName()}));
                }
                int[] nArray = (int[])obj2;
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int objectId = nArray[n3];
                    if (leftId == objectId) {
                        return Boolean.FALSE;
                    }
                    ++n3;
                }
                return Boolean.TRUE;
            }
            if (obj2 instanceof IResultTable) {
                IResultTable other = (IResultTable)obj2;
                int count = other.getRowCount();
                int ii = 0;
                while (ii < count) {
                    if (obj1.equals(other.getColumnValue(other.getRow(ii), 0))) {
                        return Boolean.FALSE;
                    }
                    ++ii;
                }
                return Boolean.TRUE;
            }
            throw new RuntimeException(MessageUtil.format((String)Messages.Operation_Error_NotInArgumentOfUnknownClass, (Object[])new Object[]{obj2.getClass().getName()}));
        }

        public String getSymbol() {
            return " NOT IN ";
        }
    }

    static class NotLike
    extends Operation {
        Pattern pattern;

        public NotLike(Expression arg1, String regex) {
            super(new Expression[]{arg1});
            this.pattern = Pattern.compile(PatternUtil.smartFix((String)regex, (boolean)false));
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Object obj1 = this.args[0].compute(ctx);
            if (obj1 == null) {
                return Boolean.FALSE;
            }
            return !this.pattern.matcher(String.valueOf(obj1)).matches();
        }

        public String getSymbol() {
            return " NOT LIKE ";
        }

        public String toString() {
            return "(" + this.args[0] + this.getSymbol() + "\"" + this.pattern.toString() + "\"" + ")";
        }
    }

    static abstract class NumberOperation
    extends Operation {
        public NumberOperation(Expression arg1, Expression arg2) {
            super(new Expression[]{arg1, arg2});
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Object obj1 = this.args[0].compute(ctx);
            Object obj2 = this.args[1].compute(ctx);
            if (obj1 == null || !(obj1 instanceof Number)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NOT_A_NUMBER, (Object[])new Object[]{this.args[0], obj1, obj1 != null ? obj1.getClass().getName() : Messages.Function_unknown, this.getSymbol()}));
            }
            if (obj2 == null || !(obj2 instanceof Number)) {
                throw new UnsupportedOperationException(MessageUtil.format((String)ERR_NOT_A_NUMBER, (Object[])new Object[]{this.args[1], obj2, obj2 != null ? obj2.getClass().getName() : Messages.Function_unknown, this.getSymbol()}));
            }
            if (obj1 instanceof Double || obj1 instanceof Float || obj2 instanceof Double || obj2 instanceof Float) {
                return this.calculate(((Number)obj1).doubleValue(), ((Number)obj2).doubleValue());
            }
            return this.calculate(((Number)obj1).longValue(), ((Number)obj2).longValue());
        }

        abstract Object calculate(long var1, long var3);

        abstract Object calculate(double var1, double var3);
    }

    static class Or
    extends Operation {
        public Or(Expression[] args) {
            super(args);
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Expression[] expressionArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Expression ex = expressionArray[n2];
                if (Or.booleanValue(ex.compute(ctx))) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
            return Boolean.FALSE;
        }

        public String getSymbol() {
            return "or";
        }
    }

    static class Plus
    extends NumberOperation {
        public Plus(Expression arg1, Expression arg2) {
            super(arg1, arg2);
        }

        Object calculate(long left, long right) {
            return left + right;
        }

        Object calculate(double left, double right) {
            return left + right;
        }

        public String getSymbol() {
            return "+";
        }
    }

    static abstract class RelationalOperation
    extends Operation {
        public RelationalOperation(Expression arg1, Expression arg2) {
            super(new Expression[]{arg1, arg2});
        }

        public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
            Object obj1 = this.args[0].compute(ctx);
            Object obj2 = this.args[1].compute(ctx);
            if (obj1 == null || obj2 == null) {
                return this.evalNull(obj1, obj2);
            }
            boolean obj1IsNumber = obj1 instanceof Number;
            boolean obj2IsNumber = obj2 instanceof Number;
            if (obj1IsNumber && obj2IsNumber) {
                if (obj1 instanceof Double || obj1 instanceof Float || obj2 instanceof Double || obj2 instanceof Float) {
                    return this.eval(((Number)obj1).doubleValue(), ((Number)obj2).doubleValue());
                }
                return this.eval(((Number)obj1).longValue(), ((Number)obj2).longValue());
            }
            return this.eval(obj1, obj2);
        }

        abstract Object evalNull(Object var1, Object var2);

        abstract Object eval(Object var1, Object var2);

        abstract Object eval(long var1, long var3);

        abstract Object eval(double var1, double var3);
    }
}

