/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mat.query.registry.QueryDescriptor;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.internal.ErrorLogHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MemoryAnalyserPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mat.ui";
    public static final String EDITOR_ID = "org.eclipse.mat.ui.editors.HeapEditor";
    private static MemoryAnalyserPlugin plugin;
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(20);
    private Map<URL, ImageDescriptor> imagePathCache = new HashMap<URL, ImageDescriptor>(20);
    private IExtensionTracker tracker;
    private Logger logger;
    private ErrorLogHandler errorLogHandler;
    private boolean useParentHandlers;

    public MemoryAnalyserPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.tracker = new ExtensionTracker(Platform.getExtensionRegistry());
        this.logger = Logger.getLogger("org.eclipse.mat");
        this.useParentHandlers = this.logger.getUseParentHandlers();
        this.logger.setUseParentHandlers(false);
        this.errorLogHandler = new ErrorLogHandler();
        this.logger.addHandler(this.errorLogHandler);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.tracker.close();
        for (Image image : this.imageCache.values()) {
            image.dispose();
        }
        this.imageCache.clear();
        this.logger.removeHandler(this.errorLogHandler);
        this.logger.setUseParentHandlers(this.useParentHandlers);
        this.logger = null;
        this.errorLogHandler = null;
        super.stop(context);
    }

    public static MemoryAnalyserPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static Image getImage(String name) {
        return MemoryAnalyserPlugin.getDefault().getImage(MemoryAnalyserPlugin.getImageDescriptor(name));
    }

    public Image getImage(ImageDescriptor descriptor) {
        Image image = this.imageCache.get(descriptor);
        if (image == null && descriptor != null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(URL path) {
        ImageDescriptor descriptor = this.imagePathCache.get(path);
        if (descriptor == null) {
            descriptor = ImageDescriptor.createFromURL((URL)path);
            this.imagePathCache.put(path, descriptor);
        }
        return descriptor;
    }

    public Image getImage(URL path) {
        return this.getImage(this.getImageDescriptor(path));
    }

    public ImageDescriptor getImageDescriptor(QueryDescriptor query) {
        URL url = query != null ? query.getIcon() : null;
        return url != null ? this.getImageDescriptor(url) : null;
    }

    public Image getImage(QueryDescriptor query) {
        ImageDescriptor imageDescriptor = this.getImageDescriptor(query);
        return imageDescriptor == null ? null : this.getImage(imageDescriptor);
    }

    public IExtensionTracker getExtensionTracker() {
        return this.tracker;
    }

    public static void log(IStatus status) {
        MemoryAnalyserPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        MemoryAnalyserPlugin.log(e, Messages.MemoryAnalyserPlugin_InternalError);
    }

    public static void log(Throwable e, String message) {
        MemoryAnalyserPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, e));
    }

    public static interface ISharedImages {
        public static final String HEAP = "icons/heapobjects/heapdump16.gif";
        public static final String OPEN_SNAPSHOT = "icons/open_snapshot.gif";
        public static final String CONSOLE = "icons/console.gif";
        public static final String CONSOLE_PLUS = "icons/console_plus.gif";
        public static final String CONSOLE_REMOVE = "icons/remove_console.gif";
        public static final String COPY = "icons/copy.gif";
        public static final String PLUS = "icons/plus.gif";
        public static final String EXPERT_SYSTEM = "icons/expert.gif";
        public static final String REFRESH = "icons/refresh.gif";
        public static final String THREAD = "icons/thread.gif";
        public static final String RETAINED_SET = "icons/retainedSet.gif";
        public static final String PACKAGE = "icons/package.gif";
        public static final String SYNCED = "icons/synced.gif";
        public static final String SYNCED_DISABLED = "icons/synced_disabled.gif";
        public static final String ID = "icons/id.gif";
        public static final String SIZE = "icons/size.gif";
        public static final String CLASS = "icons/heapobjects/class.gif";
        public static final String CLASS_MIXED = "icons/heapobjects/class_mixed.gif";
        public static final String CLASS_OLD = "icons/heapobjects/class_old.gif";
        public static final String SUPERCLASS = "icons/heapobjects/superclass.gif";
        public static final String NOTEPAD = "icons/notepad.gif";
        public static final String ARGUMENTS_WIZARD = "icons/fill_arguments_wiz.gif";
        public static final String QUERY = "icons/query_browser.gif";
        public static final String QUERY_DISABLED = "icons/query_disabled.gif";
        public static final String OQL = "icons/oql.gif";
        public static final String IMPORT_REPORT = "icons/import_report.gif";
        public static final String EXPORT_MENU = "icons/export.gif";
        public static final String EXPORT_HTML = "icons/export_html.gif";
        public static final String EXPORT_CSV = "icons/export_csv.gif";
        public static final String EXPORT_TXT = "icons/export_txt.gif";
        public static final String REFRESHING = "icons/refreshing.gif";
        public static final String CALCULATOR = "icons/calculator.gif";
        public static final String FILTER = "icons/filter.gif";
        public static final String GROUPING = "icons/grouping.gif";
        public static final String COMPARE = "icons/compare.gif";
        public static final String PERCENTAGE = "icons/percentage.gif";
        public static final String INFO = "icons/info.gif";
        public static final String HELP = "icons/help.png";
        public static final String FIND = "icons/find.gif";
        public static final String EXECUTE_QUERY = "icons/execute_query.gif";
        public static final String SHOW_AS_HISTOGRAM = "icons/as_histogram.gif";
        public static final String EXPLORE = "icons/explore.gif";
        public static final String SHOW_PANE = "icons/show_pane.gif";
        public static final String CLOSE_PANE = "icons/close_pane.gif";
        public static final String CLOSE_BRANCH = "icons/close_branch.gif";
        public static final String PINNED = "icons/pinned.gif";
        public static final String MOVE_UP = "icons/move_up.gif";
        public static final String MOVE_DOWN = "icons/move_down.gif";
        public static final String REMOVE = "icons/remove.gif";
        public static final String REMOVE_ALL = "icons/removeall.gif";
        public static final String SELECT_COLUMN = "icons/select_table.gif";
    }
}

