/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="group_by_value")
public class GroupByValueQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public String field;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.GroupByValueQuery_GroupingObjects);
        Quantize quantize = Quantize.valueDistribution((String[])new String[]{Messages.GroupByValueQuery_Column_StringValue}).column(Messages.GroupByValueQuery_Column_Objects, Quantize.COUNT).column(Messages.Column_ShallowHeap, Quantize.SUM_LONG, Column.SortDirection.DESC).column(Messages.GroupByValueQuery_Column_AvgRetainedSize, Quantize.AVERAGE_LONG).addDerivedData(RetainedSizeDerivedData.APPROXIMATE).build();
        boolean canceled = false;
        for (int[] objectIds : this.objects) {
            int ii = 0;
            while (ii < objectIds.length) {
                if (listener.isCanceled()) {
                    canceled = true;
                    break;
                }
                int objectId = objectIds[ii];
                IObject object = this.snapshot.getObject(objectId);
                Object subject = object;
                if (this.field != null) {
                    subject = object.resolveValue(this.field);
                }
                if (subject instanceof IObject) {
                    subject = subject.getClassSpecificName();
                }
                quantize.addValue(objectId, new Object[]{subject, null, object.getUsedHeapSize(), object.getRetainedHeapSize()});
                ++ii;
            }
            if (canceled) break;
        }
        return quantize.getResult();
    }
}

