/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.util.Collection;
import org.eclipse.mat.inspections.collections.HashEntriesQuery;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="system_properties")
public class SystemPropertiesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public HashEntriesQuery.Result execute(IProgressListener listener) throws Exception {
        Collection<IClass> classes = this.snapshot.getClassesByName("java.lang.System", false);
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        IClass systemClass = classes.iterator().next();
        IObject properties = (IObject)systemClass.resolveValue("props");
        if (properties == null) {
            properties = (IObject)systemClass.resolveValue("systemProperties");
        }
        if (properties == null) {
            return null;
        }
        return (HashEntriesQuery.Result)SnapshotQuery.lookup("hash_entries", this.snapshot).setArgument("objects", properties).execute(listener);
    }
}

