/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.PseudoReference;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="extract_list_values")
public class ExtractListValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject list;

    public IResult execute(IProgressListener listener) throws Exception {
        CollectionUtil.Info info = CollectionUtil.getInfo(this.list);
        if (info != null && !info.isMap()) {
            if (info.hasBackingArray()) {
                return this.extractArrayList(info, listener);
            }
            if (this.list.getClazz().doesExtend("java.util.LinkedList")) {
                return this.extractLinkedList(info, listener);
            }
        }
        throw new IllegalArgumentException(MessageUtil.format((String)Messages.ExtractListValuesQuery_NotAWellKnownList, (Object[])new Object[]{this.list.getDisplayName()}));
    }

    private IResult extractArrayList(CollectionUtil.Info info, IProgressListener listener) throws SnapshotException {
        int size = info.getSize(this.list);
        if (size == 0) {
            return new ObjectListResult.Outbound(this.snapshot, new int[0]);
        }
        String taskMsg = MessageUtil.format((String)Messages.ExtractListValuesQuery_CollectingElements, (Object[])new Object[]{size, this.list.getTechnicalName()});
        listener.beginTask(taskMsg, size);
        ArrayInt result = new ArrayInt();
        IObjectArray elementData = info.getBackingArray(this.list);
        if (elementData != null) {
            for (NamedReference ref : elementData.getOutboundReferences()) {
                if (ref instanceof PseudoReference) continue;
                result.add(ref.getObjectId());
                listener.worked(1);
                if (listener.isCanceled()) break;
            }
        }
        listener.done();
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }

    private IResult extractLinkedList(CollectionUtil.Info info, IProgressListener listener) throws Exception {
        int size = info.getSize(this.list);
        if (size == 0) {
            return new ObjectListResult.Outbound(this.snapshot, new int[0]);
        }
        String taskMsg = MessageUtil.format((String)Messages.ExtractListValuesQuery_CollectingElements, (Object[])new Object[]{size, this.list.getTechnicalName()});
        listener.beginTask(taskMsg, size);
        ArrayInt result = new ArrayInt();
        int loopingLimit = size;
        IObject header = (IObject)this.list.resolveValue("header");
        if (header == null) {
            header = (IObject)this.list.resolveValue("voidLink");
        }
        if (header == null) {
            header = info.resolveNextFields(this.list);
        }
        IObject previous = header;
        IObject current = (IObject)header.resolveValue("next");
        if (current == null) {
            ISnapshot snapshot = header.getSnapshot();
            int[] nArray = snapshot.getOutboundReferentIds(header.getObjectId());
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                IObject o = snapshot.getObject(i);
                if (i != header.getClazz().getObjectId() && o.getClazz().equals(header.getClazz())) {
                    current = o;
                    break;
                }
                ++n2;
            }
        }
        while (current != null && current != header && loopingLimit-- > 0) {
            IObject next;
            IObject ref = (IObject)current.resolveValue("element");
            if (ref == null) {
                ref = (IObject)current.resolveValue("data");
            }
            if ((next = (IObject)current.resolveValue("next")) == null) {
                ISnapshot snapshot = current.getSnapshot();
                int[] nArray = snapshot.getOutboundReferentIds(current.getObjectId());
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int i = nArray[n3];
                    IObject o = snapshot.getObject(i);
                    if (i != previous.getObjectId() && i != current.getClazz().getObjectId()) {
                        if (o.getClazz().equals(current.getClazz())) {
                            if (next != null) {
                                next = null;
                                break;
                            }
                            next = o;
                        } else if (ref == null) {
                            ref = o;
                        }
                    }
                    ++n3;
                }
            }
            if (ref != null) {
                result.add(ref.getObjectId());
            }
            previous = current;
            current = next;
            listener.worked(1);
            if (listener.isCanceled()) break;
        }
        listener.done();
        return new ObjectListResult.Outbound(this.snapshot, result.toArray());
    }
}

