/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.report.QuerySpec;
import org.eclipse.mat.report.SectionSpec;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.SnapshotQuery;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CommandName(value="component_report_top")
public class TopComponentsReportQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(isMandatory=false, flag="t")
    public int thresholdPercent = 1;
    @Argument(isMandatory=false)
    public boolean aggressive;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] topDominators = this.snapshot.getImmediateDominatedIds(-1);
        List<Record> loaders = this.createClassLoaderRecords(listener, topDominators);
        SectionSpec result = new SectionSpec(Messages.TopComponentsReportQuery_TopComponentReports);
        long totalHeapSize = this.snapshot.getSnapshotInfo().getUsedHeapSize();
        long threshold = totalHeapSize / 100L * (long)this.thresholdPercent;
        for (Record record : loaders) {
            if (record.retainedSize < threshold) break;
            SnapshotQuery query = SnapshotQuery.lookup("component_report", this.snapshot).setArgument("objects", record.objects);
            query.setArgument("aggressive", this.aggressive);
            IResult report = query.execute(listener);
            QuerySpec spec = new QuerySpec(MessageUtil.format((String)"{0} ({1,number,percent})", (Object[])new Object[]{record.name, (double)record.retainedSize / (double)totalHeapSize}), report);
            spec.set("html.separate_file", Boolean.TRUE.toString());
            result.add((Spec)spec);
        }
        return result;
    }

    private List<Record> createClassLoaderRecords(IProgressListener listener, int[] topDominators) throws SnapshotException {
        HashMapIntObject id2loader = new HashMapIntObject();
        int ii = 0;
        while (ii < topDominators.length) {
            int classLoaderId = this.snapshot.getClassOf(topDominators[ii]).getClassLoaderId();
            Record loaderRecord = (Record)id2loader.get(classLoaderId);
            if (loaderRecord == null) {
                IObject loader = this.snapshot.getObject(classLoaderId);
                String name = loader.getClassSpecificName();
                if (name == null) {
                    name = loader.getTechnicalName();
                }
                loaderRecord = new Record(name);
                id2loader.put(classLoaderId, (Object)loaderRecord);
            }
            loaderRecord.objects.add(topDominators[ii]);
            loaderRecord.retainedSize += this.snapshot.getRetainedHeapSize(topDominators[ii]);
            if (ii % 1000 == 0) {
                listener.worked(1);
                if (listener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            ++ii;
        }
        ArrayList<Record> loaders = new ArrayList<Record>(id2loader.size());
        Iterator ee = id2loader.values();
        while (ee.hasNext()) {
            loaders.add((Record)ee.next());
        }
        Collections.sort(loaders);
        return loaders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Record
    implements Comparable<Record> {
        String name;
        ArrayInt objects = new ArrayInt();
        long retainedSize;

        public Record(String name) {
            this.name = name;
        }

        @Override
        public int compareTo(Record other) {
            return this.retainedSize > other.retainedSize ? -1 : (this.retainedSize == other.retainedSize ? 0 : 1);
        }
    }
}

