/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IResultTable;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.Icons;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnreachableObjectsHistogram
implements IResultTable,
IIconProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<Record> histogram;
    private transient ISnapshot snapshot;

    public UnreachableObjectsHistogram(Collection<Record> records) {
        this.histogram = new ArrayList<Record>(records);
    }

    public List<Record> getRecords() {
        return Collections.unmodifiableList(this.histogram);
    }

    public ResultMetaData getResultMetaData() {
        return null;
    }

    public Column[] getColumns() {
        return new Column[]{new Column(Messages.Column_ClassName), new Column(Messages.Column_Objects, Long.TYPE), new Column(Messages.Column_ShallowHeap, Long.TYPE).sorting(Column.SortDirection.DESC)};
    }

    public int getRowCount() {
        return this.histogram.size();
    }

    public Object getRow(int rowId) {
        return this.histogram.get(rowId);
    }

    public Object getColumnValue(Object row, int columnIndex) {
        Record r = (Record)row;
        switch (columnIndex) {
            case 0: {
                return r.getClassName();
            }
            case 1: {
                return r.getObjectCount();
            }
            case 2: {
                return r.getShallowHeapSize();
            }
        }
        return null;
    }

    public IContextObject getContext(Object row) {
        int classId;
        Record record = (Record)row;
        long classAddress = record.getClassAddress();
        if (classAddress == 0L) {
            return null;
        }
        try {
            classId = this.snapshot.mapAddressToId(classAddress);
        }
        catch (SnapshotException snapshotException) {
            return null;
        }
        return new IContextObjectSet(){

            public int getObjectId() {
                return classId;
            }

            public int[] getObjectIds() {
                return new int[0];
            }

            public String getOQL() {
                return null;
            }
        };
    }

    public URL getIcon(Object row) {
        return Icons.CLASS;
    }

    public void setSnapshot(ISnapshot snapshot) {
        if (this.snapshot == null) {
            this.snapshot = snapshot;
        }
    }

    public static class Record
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String className;
        private int objectCount;
        private long shallowHeapSize;
        private long classAddress;

        public Record(String className, long classAddress, int nrOfObjects, long sizeOfObjects) {
            this.className = className;
            this.objectCount = nrOfObjects;
            this.shallowHeapSize = sizeOfObjects;
            this.classAddress = classAddress;
        }

        public Record(String className, int nrOfObjects, long sizeOfObjects) {
            this(className, 0L, nrOfObjects, sizeOfObjects);
        }

        public String getClassName() {
            return this.className;
        }

        public int getObjectCount() {
            return this.objectCount;
        }

        public long getShallowHeapSize() {
            return this.shallowHeapSize;
        }

        public long getClassAddress() {
            return this.classAddress;
        }
    }
}

