/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.chart;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.computation.DataPointHints;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mat.impl.chart.ChartBuilder;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.query.registry.QueryResult;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.actions.OpenHelpPageAction;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.internal.chart.ChartCanvas;
import org.eclipse.mat.ui.internal.chart.Messages;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.mat.ui.util.QueryContextMenu;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.widgets.FormText;

public class PieChartPane
extends AbstractEditorPane
implements ISelectionProvider {
    List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    FormText label;
    ChartCanvas canvas;
    QueryResult queryResult;
    QueryContextMenu contextMenu;
    List<? extends IResultPie.Slice> slices;
    IResultPie.Slice current;
    private Menu menu;

    public void initWithArgument(Object argument) {
        if (argument != null) {
            this.contextMenu = new QueryContextMenu((AbstractEditorPane)this, new ContextProvider(null){

                public IContextObject getContext(Object row) {
                    return ((IResultPie.Slice)row).getContext();
                }
            });
            this.queryResult = (QueryResult)argument;
            IResultPie pie = (IResultPie)this.queryResult.getSubject();
            this.slices = pie.getSlices();
            this.canvas.setChart(ChartBuilder.create((IResultPie)pie, (boolean)true));
            this.canvas.redraw();
        }
    }

    public void createPartControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setBackground(parent.getDisplay().getSystemColor(1));
        top.setTabList(new Control[0]);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).spacing(0, 0).applyTo(top);
        this.canvas = new ChartCanvas(top, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 300).applyTo((Control)this.canvas);
        this.label = new FormText(top, 0);
        this.label.setBackground(parent.getDisplay().getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).indent(5, 0).hint(-1, 45).applyTo((Control)this.label);
        this.canvas.renderer.setProperty("device.component", (Object)new CallBackListener());
    }

    public void contributeToToolBar(IToolBarManager manager) {
        if (this.queryResult.getQuery() != null && this.queryResult.getQuery().getHelpUrl() != null) {
            manager.appendToGroup("help", (IAction)new OpenHelpPageAction(this.queryResult.getQuery().getHelpUrl()));
        }
        super.contributeToToolBar(manager);
    }

    public String getTitle() {
        return Messages.PieChartPane_Chart;
    }

    public Image getTitleImage() {
        return this.queryResult != null ? MemoryAnalyserPlugin.getDefault().getImage(this.queryResult.getQuery()) : null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        IContextObject ctx;
        if (this.current != null && (ctx = this.current.getContext()) != null) {
            return new StructuredSelection((Object)ctx);
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
    }

    private void fireSelectionEvent() {
        ArrayList<ISelectionChangedListener> receivers = new ArrayList<ISelectionChangedListener>(this.listeners);
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : receivers) {
            listener.selectionChanged(event);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
    }

    class CallBackListener
    implements ICallBackNotifier {
        CallBackListener() {
        }

        public void callback(Object event, Object source, CallBackValue value) {
            IContextObject ctx;
            StructureSource structuredSource = (StructureSource)source;
            DataPointHints dph = (DataPointHints)structuredSource.getSource();
            IResultPie.Slice slice = PieChartPane.this.slices.get(dph.getIndex());
            if (PieChartPane.this.current != slice) {
                PieChartPane.this.label.setText("<form>" + slice.getDescription() + "</form>", true, false);
                PieChartPane.this.current = slice;
                PieChartPane.this.fireSelectionEvent();
            }
            if (slice != null && "click".equals(value.getIdentifier()) && (ctx = slice.getContext()) != null) {
                if (PieChartPane.this.menu != null && !PieChartPane.this.menu.isDisposed()) {
                    PieChartPane.this.menu.dispose();
                }
                PopupMenu popupMenu = new PopupMenu();
                PieChartPane.this.contextMenu.addContextActions(popupMenu, (IStructuredSelection)new StructuredSelection((Object)slice), null);
                PieChartPane.this.menu = popupMenu.createMenu(PieChartPane.this.getEditorSite().getActionBars().getStatusLineManager(), (Control)PieChartPane.this.canvas);
                PieChartPane.this.menu.setVisible(true);
            }
        }

        public Chart getDesignTimeModel() {
            return PieChartPane.this.canvas.getChart();
        }

        public Chart getRunTimeModel() {
            return PieChartPane.this.canvas.getRunTimeModel();
        }

        public Object peerInstance() {
            return PieChartPane.this.canvas;
        }

        public void regenerateChart() {
            PieChartPane.this.canvas.redraw();
        }

        public void repaintChart() {
            PieChartPane.this.canvas.redraw();
        }
    }
}

