/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class InitDTFJ
extends Plugin
implements IRegistryChangeListener {
    private static final String DTFJ_NAMESPACE = "com.ibm.dtfj.api";
    private static final String DTFJ_IMAGEFACTORY = "imagefactory";
    private static final Map<String, Map<String, String>> allexts = new HashMap<String, Map<String, String>>();
    private static InitDTFJ plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        reg.addRegistryChangeListener((IRegistryChangeListener)this, DTFJ_NAMESPACE);
        this.registerFileExtensions();
    }

    public void stop(BundleContext context) throws Exception {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        this.removalAllExtensions();
        reg.removeRegistryChangeListener((IRegistryChangeListener)this);
        DTFJIndexBuilder.clearCachedDumps();
        plugin = null;
        super.stop(context);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IContributor cont = this.getContributor(reg);
        IExtensionPoint contentPoint = this.contentExtensionPoint(reg);
        IExtensionDelta[] iExtensionDeltaArray = event.getExtensionDeltas(DTFJ_NAMESPACE, DTFJ_IMAGEFACTORY);
        int n = iExtensionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtensionDelta delta = iExtensionDeltaArray[n2];
            IExtension dtfjExtension = delta.getExtension();
            switch (delta.getKind()) {
                case 1: {
                    try {
                        this.contributeParserExtension(reg, cont, contentPoint, dtfjExtension);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    break;
                }
                case 2: {
                    this.removeParserExtension(reg, cont, dtfjExtension);
                }
            }
            ++n2;
        }
    }

    private void removeParserExtension(IExtensionRegistry reg, IContributor cont, IExtension dtfjExtension) {
        IConfigurationElement[] iConfigurationElementArray = dtfjExtension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals("factory")) {
                String id = el.getAttribute("id");
                String fullid = String.valueOf(cont.getName()) + "." + id;
                allexts.remove(fullid);
            }
            ++n2;
        }
    }

    private void removalAllExtensions() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IContributor cont = this.getContributor(reg);
        IExtensionPoint dtfjPoint = this.dtfjExtensionPoint(reg);
        if (dtfjPoint != null) {
            IExtension[] iExtensionArray = dtfjPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension ex = iExtensionArray[n2];
                this.removeParserExtension(reg, cont, ex);
                ++n2;
            }
        }
        allexts.clear();
    }

    void registerFileExtensions() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        try {
            IContributor cont = this.getContributor(reg);
            IExtensionPoint dtfjPoint = this.dtfjExtensionPoint(reg);
            IExtensionPoint contentPoint = this.contentExtensionPoint(reg);
            if (dtfjPoint != null) {
                IExtension[] iExtensionArray = dtfjPoint.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension ex = iExtensionArray[n2];
                    this.contributeParserExtension(reg, cont, contentPoint, ex);
                    ++n2;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private IExtensionPoint contentExtensionPoint(IExtensionRegistry reg) {
        return reg.getExtensionPoint("org.eclipse.core.contenttype", "contentTypes");
    }

    private IExtensionPoint dtfjExtensionPoint(IExtensionRegistry reg) {
        IExtensionPoint dtfjPoint = reg.getExtensionPoint(DTFJ_NAMESPACE, DTFJ_IMAGEFACTORY);
        return dtfjPoint;
    }

    private IContributor getContributor(IExtensionRegistry reg) {
        IExtension es = reg.getExtension("org.eclipse.ui.startup", "org.eclipse.mat.dtfj.dtfj");
        if (es == null) {
            es = reg.getExtension("org.eclipse.core.contenttype.contentTypes", "com.ibm.dtfj.base");
        }
        IContributor cont = es != null ? es.getContributor() : ContributorFactoryOSGi.createContributor((Bundle)this.getBundle());
        return cont;
    }

    private void contributeParserExtension(IExtensionRegistry reg, IContributor cont, IExtensionPoint contentPoint, IExtension dtfjExtension) throws UnsupportedEncodingException {
        IConfigurationElement[] iConfigurationElementArray = dtfjExtension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement el = iConfigurationElementArray[n2];
            if (el.getName().equals("factory")) {
                HashSet<String> done = new HashSet<String>();
                String id = el.getAttribute("id");
                String name = el.getAttribute("label");
                String exts = null;
                IConfigurationElement[] iConfigurationElementArray2 = el.getChildren();
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el2 = iConfigurationElementArray2[n4];
                    String ref = el2.getAttribute("dump-type");
                    if (ref != null && done.add(ref)) {
                        exts = InitDTFJ.addExtension(exts, InitDTFJ.genParser(ref, contentPoint));
                    }
                    if ((ref = el2.getAttribute("meta-type")) != null && done.add(ref)) {
                        exts = InitDTFJ.addExtension(exts, InitDTFJ.genParser(ref, contentPoint));
                    }
                    ++n4;
                }
                HashMap<String, String> vals = new HashMap<String, String>();
                vals.put("id", id);
                vals.put("name", name);
                vals.put("fileExtension", exts);
                String fullid = String.valueOf(cont.getName()) + "." + id;
                allexts.put(fullid, vals);
            }
            ++n2;
        }
    }

    private static String genParser(String ref, IExtensionPoint point2) {
        IContentType ct = Platform.getContentTypeManager().getContentType(ref);
        if (ct == null) {
            return null;
        }
        String exts = null;
        IContentType[] iContentTypeArray = Platform.getContentTypeManager().getAllContentTypes();
        int n = iContentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContentType ct1 = iContentTypeArray[n2];
            if (ct1.isKindOf(ct)) {
                String s1 = InitDTFJ.genParser(ct1);
                exts = InitDTFJ.addExtension(exts, s1);
            }
            ++n2;
        }
        return exts;
    }

    private static String addExtension(String exts, String ext) {
        if (exts == null) {
            exts = ext;
        } else if (ext != null) {
            exts = String.valueOf(exts) + "," + ext;
        }
        return exts;
    }

    private static String genParser(IContentType ct) {
        String[] s;
        String label = ct.getName();
        String exts = null;
        if (label != null && (s = ct.getFileSpecs(8)).length > 0) {
            String[] stringArray = s;
            int n = s.length;
            int n2 = 0;
            while (n2 < n) {
                String s1 = stringArray[n2];
                exts = InitDTFJ.addExtension(exts, s1);
                ++n2;
            }
        }
        return exts;
    }

    static InitDTFJ getDefault() {
        return plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DynamicInfo
    extends HashMap<String, Map<String, String>> {
        private static final long serialVersionUID = -5291159195829859576L;

        public DynamicInfo() {
            super.putAll(allexts);
        }
    }
}

