/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.Attribute;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathExpression
extends Expression {
    private List<Object> attributes;

    public PathExpression(List<Object> attributes) {
        this.attributes = attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException {
        try {
            Object current = null;
            int index = 0;
            Object firstItem = this.attributes.get(0);
            if (firstItem instanceof Attribute) {
                Attribute firstAttribute = (Attribute)firstItem;
                Object object = current = !firstAttribute.isNative() ? ctx.getAlias(firstAttribute.getName()) : null;
            }
            if (current == null) {
                current = ctx.getSubject();
            } else {
                ++index;
            }
            while (index < this.attributes.size()) {
                List<?> element = this.attributes.get(index);
                if (element != null && element.getClass().isArray()) {
                    element = PathExpression.asList(element);
                }
                if (element instanceof Attribute) {
                    Attribute attribute = (Attribute)((Object)element);
                    if (attribute.isNative() || !(current instanceof IObject)) {
                        if (current.getClass().isArray()) {
                            if (!"length".equals(attribute.getName())) throw new SnapshotException(MessageUtil.format((String)Messages.PathExpression_Error_ArrayHasNoProperty, (Object[])new Object[]{current.getClass().getComponentType().getName(), attribute.name}));
                            current = Array.getLength(current);
                        } else {
                            PropertyDescriptor[] descriptors;
                            boolean didFindProperty = false;
                            BeanInfo info = Introspector.getBeanInfo(current.getClass());
                            PropertyDescriptor[] propertyDescriptorArray = descriptors = info.getPropertyDescriptors();
                            int n = descriptors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                                if (attribute.getName().equals(descriptor.getName())) {
                                    current = descriptor.getReadMethod().invoke(current, null);
                                    didFindProperty = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!didFindProperty) {
                                throw new SnapshotException(MessageUtil.format((String)Messages.PathExpression_Error_TypeHasNoProperty, (Object[])new Object[]{current.getClass().getName(), attribute.name}));
                            }
                        }
                    } else {
                        IObject c = (IObject)current;
                        current = c.resolveValue(attribute.getName());
                    }
                } else {
                    if (!(element instanceof Expression)) throw new SnapshotException(MessageUtil.format((String)Messages.PathExpression_Error_UnknownElementInPath, (Object[])new Object[]{element}));
                    EvaluationContext methodCtx = new EvaluationContext(ctx);
                    methodCtx.setSubject(current);
                    current = ((Expression)((Object)element)).compute(methodCtx);
                }
                if (current == null) return current;
                ++index;
            }
            return current;
        }
        catch (Exception e) {
            throw SnapshotException.rethrow((Throwable)e);
        }
    }

    protected static List<?> asList(Object element) {
        int size = Array.getLength(element);
        ArrayList<Object> answer = new ArrayList<Object>(size);
        int ii = 0;
        while (ii < size) {
            answer.add(Array.get(element, ii));
            ++ii;
        }
        return answer;
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        Object firstItem = this.attributes.get(0);
        if (firstItem instanceof Attribute) {
            Attribute firstAttribute = (Attribute)firstItem;
            return !firstAttribute.isNative() && ctx.isAlias(firstAttribute.getName());
        }
        if (firstItem instanceof Expression) {
            return ((Expression)firstItem).isContextDependent(ctx);
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        Iterator<Object> iter = this.attributes.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            buf.append(element);
            if (!iter.hasNext()) continue;
            buf.append(".");
        }
        return buf.toString();
    }
}

