/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="map_collision_ratio")
public class MapCollisionRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public int segments = 5;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;
    @Argument(isMandatory=false)
    public String array_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.MapCollisionRatioQuery_CalculatingCollisionRatios);
        HashMapIntObject<CollectionUtil.Info> metadata = CollectionUtil.getKnownMaps(this.snapshot);
        if (this.collection != null) {
            if (this.size_attribute == null || this.array_attribute == null) {
                String msg = Messages.MapCollisionRatioQuery_ErrorMsg_MissingArgument;
                throw new SnapshotException(msg);
            }
            CollectionUtil.Info info = new CollectionUtil.Info(this.collection, this.size_attribute, this.array_attribute);
            Collection<IClass> classes = this.snapshot.getClassesByName(this.collection, true);
            if (classes == null || classes.isEmpty()) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.MapCollisionRatioQuery_ErrorMsg_ClassNotFound, (Object[])new Object[]{this.collection}), null);
            } else {
                for (IClass clasz : classes) {
                    metadata.put(clasz.getObjectId(), (Object)info);
                }
            }
        }
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)Messages.MapCollisionRatioQuery_Column_CollisionRatio, (double)0.0, (double)1.0, (double)(1.0 / (double)this.segments));
        builder.column(Messages.MapCollisionRatioQuery_Column_NumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator<IClass> iterator = this.objects.iterator();
        block3: while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) continue block3;
                CollectionUtil.Info info = (CollectionUtil.Info)metadata.get(this.snapshot.getClassOf(objectId).getObjectId());
                if (info != null) {
                    IObject obj = this.snapshot.getObject(objectId);
                    try {
                        double collisionRatio = MapCollisionRatioQuery.getCollisionRatio(info, obj);
                        quantize.addValue(obj.getObjectId(), new Object[]{collisionRatio, null, obj.getUsedHeapSize()});
                    }
                    catch (SnapshotException e) {
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.MapCollisionRatioQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }

    private static double getCollisionRatio(CollectionUtil.Info info, IObject hashtableObject) throws SnapshotException {
        int size = info.getSize(hashtableObject);
        if (size <= 0) {
            return size;
        }
        if (!info.hasBackingArray()) {
            return 0.0;
        }
        return (double)(size - info.getNumberOfNoNullArrayElements(hashtableObject)) / (double)size;
    }
}

