/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.snapshot;

import java.math.BigInteger;
import java.text.ParsePosition;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.snapshot.HeapObjectParamArgument;
import org.eclipse.mat.query.registry.CommandLine;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.PatternUtil;

public final class ArgumentParser {
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("^0x\\p{XDigit}+$");

    public static HeapObjectParamArgument consumeHeapObjects(ISnapshot snapshot, String line) throws SnapshotException {
        String[] args = CommandLine.tokenize((String)line);
        ParsePosition pos = new ParsePosition(0);
        HeapObjectParamArgument hopa = ArgumentParser.consumeHeapObjects(snapshot, args, pos);
        if (pos.getIndex() < args.length) {
            StringBuilder buf = new StringBuilder();
            while (pos.getIndex() < args.length) {
                buf.append(args[pos.getIndex()]).append(" ");
                pos.setIndex(pos.getIndex() + 1);
            }
            throw new SnapshotException(MessageUtil.format((String)Messages.ArgumentParser_ErrorMsg_Unparsed, (Object[])new Object[]{buf.toString()}));
        }
        return hopa;
    }

    public static HeapObjectParamArgument consumeHeapObjects(ISnapshot snapshot, String[] args, ParsePosition pos) throws SnapshotException {
        if (pos.getIndex() >= args.length) {
            return null;
        }
        HeapObjectParamArgument proxy = new HeapObjectParamArgument(snapshot);
        while (pos.getIndex() < args.length) {
            String arg = args[pos.getIndex()];
            if (arg == null) {
                pos.setIndex(pos.getIndex() + 1);
                continue;
            }
            if ("-verbose".equals(arg)) {
                pos.setIndex(pos.getIndex() + 1);
                proxy.setVerbose(true);
                continue;
            }
            if ("-include_subclasses".equals(arg)) {
                pos.setIndex(pos.getIndex() + 1);
                proxy.setIncludeSubclasses(true);
                continue;
            }
            if ("-include_class_instance".equals(arg)) {
                pos.setIndex(pos.getIndex() + 1);
                proxy.setIncludeClassInstance(true);
                continue;
            }
            if ("-include_loaded_instances".equals(arg)) {
                pos.setIndex(pos.getIndex() + 1);
                proxy.setIncludeLoadedInstances(true);
                continue;
            }
            if ("-retained".equals(arg)) {
                pos.setIndex(pos.getIndex() + 1);
                proxy.setRetained(true);
                continue;
            }
            if (arg.charAt(0) == '-') break;
            if (ADDRESS_PATTERN.matcher(arg).matches()) {
                long address = new BigInteger(arg.substring(2), 16).longValue();
                proxy.addObjectAddress(address);
                pos.setIndex(pos.getIndex() + 1);
                continue;
            }
            if ("select".equalsIgnoreCase(arg)) {
                StringBuilder query = new StringBuilder(128);
                query.append(arg);
                pos.setIndex(pos.getIndex() + 1);
                while (pos.getIndex() < args.length) {
                    arg = args[pos.getIndex()];
                    if (arg.length() == 1 && arg.charAt(0) == ';') {
                        pos.setIndex(pos.getIndex() + 1);
                        break;
                    }
                    if (arg.charAt(arg.length() - 1) == ';') {
                        query.append(" ").append(arg.substring(0, arg.length() - 1));
                        pos.setIndex(pos.getIndex() + 1);
                        break;
                    }
                    if (arg.charAt(0) == '-') break;
                    query.append(" ").append(arg);
                    pos.setIndex(pos.getIndex() + 1);
                }
                proxy.addOql(query.toString());
                continue;
            }
            try {
                Pattern pattern = Pattern.compile(PatternUtil.smartFix((String)arg, (boolean)false));
                proxy.addPattern(pattern);
                pos.setIndex(pos.getIndex() + 1);
            }
            catch (PatternSyntaxException e) {
                throw new SnapshotException(MessageUtil.format((String)Messages.ArgumentParser_ErrorMsg_ParsingError, (Object[])new Object[]{arg, e.getMessage()}), (Throwable)e);
            }
        }
        return proxy;
    }
}

