/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ibmvm.acquire;

import org.eclipse.mat.ibmvm.acquire.BaseProvider;
import org.eclipse.mat.ibmvm.acquire.DumpType;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.snapshot.acquire.IHeapDumpProvider;
import org.eclipse.mat.snapshot.acquire.VmInfo;

public class IBMVmInfo
extends VmInfo {
    @Argument
    public DumpType type = DumpType.SYSTEM;
    @Argument
    public boolean compress = false;
    private String pid;

    IBMVmInfo(String pid, String description, boolean heapDumpEnabled, String proposedFileName, IHeapDumpProvider heapDumpProvider) {
        super(0, description, heapDumpEnabled, proposedFileName, heapDumpProvider);
        this.setPid(pid);
    }

    void setPid(String s) {
        this.pid = s;
        try {
            int i = Integer.parseInt(s.split("\\.")[0]);
            this.setPid(i);
        }
        catch (NumberFormatException numberFormatException) {
            this.setPid(-1);
        }
    }

    String getPidName() {
        return this.pid;
    }

    String agentCommand() {
        if (this.type == DumpType.SYSTEM) {
            return "system";
        }
        if (this.type == DumpType.HEAP) {
            return "heap+java";
        }
        if (this.type == DumpType.JAVA) {
            return "java";
        }
        return null;
    }

    public String getProposedFileName() {
        String ret = super.getProposedFileName();
        if (ret == null) {
            BaseProvider provider = (BaseProvider)this.getHeapDumpProvider();
            if (this.type == DumpType.SYSTEM) {
                ret = this.compress ? provider.systemDumpZipTemplate : provider.systemDumpTemplate;
            } else if (this.type == DumpType.HEAP) {
                ret = this.compress ? provider.heapDumpZipTemplate : provider.heapDumpTemplate;
            } else if (this.type == DumpType.JAVA) {
                ret = provider.javaDumpTemplate;
            }
        }
        return ret;
    }
}

