/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="show_retained_set")
@Icon(value="/META-INF/icons/show_retained_set.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/retained_set.html")
public class RetainedSetQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false, flag="f")
    public String[] fieldNames;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] retainedSet = this.fieldNames == null ? this.snapshot.getRetainedSet(this.objects.getIds(listener), listener) : this.snapshot.getRetainedSet(this.objects.getIds(listener), this.fieldNames, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Histogram histogram = this.snapshot.getHistogram(retainedSet, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        histogram.setLabel(MessageUtil.format((String)Messages.RetainedSetQuery_RetainedBy, (Object[])new Object[]{this.objects.getLabel()}));
        return histogram;
    }
}

