/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collections.CollectionUtil;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;

@CommandName(value="collection_fill_ratio")
public class CollectionFillRatioQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;
    @Argument(isMandatory=false)
    public int segments = 5;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String size_attribute;
    @Argument(isMandatory=false)
    public String array_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.CollectionFillRatioQuery_ExtractingFillRatios);
        HashMap<Integer, CollectionUtil.Info> metadata = new HashMap<Integer, CollectionUtil.Info>();
        for (CollectionUtil.Info info : CollectionUtil.getKnownCollections(this.snapshot)) {
            Collection<IClass> classes;
            if (!info.hasSize() || !info.hasBackingArray() || (classes = this.snapshot.getClassesByName(info.getClassName(), true)) == null) continue;
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), info);
            }
        }
        if (this.collection != null) {
            CollectionUtil.Info info;
            if (this.size_attribute == null || this.array_attribute == null) {
                String msg = Messages.CollectionFillRatioQuery_ErrorMsg_AllArgumentsMustBeSet;
                throw new SnapshotException(msg);
            }
            info = new CollectionUtil.Info(this.collection, this.size_attribute, this.array_attribute);
            Collection<IClass> classes = this.snapshot.getClassesByName(this.collection, true);
            if (classes.isEmpty()) {
                listener.sendUserMessage(IProgressListener.Severity.WARNING, MessageUtil.format((String)Messages.CollectionFillRatioQuery_ClassNotFound, (Object[])new Object[]{this.collection}), null);
            }
            for (IClass clasz : classes) {
                metadata.put(clasz.getObjectId(), info);
            }
        }
        Quantize.Builder builder = Quantize.linearFrequencyDistribution((String)Messages.CollectionFillRatioQuery_Column_FillRatio, (double)0.0, (double)5.0000000001, (double)(1.0 / (double)this.segments));
        builder.column(Messages.CollectionFillRatioQuery_ColumnNumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_LONG);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        Iterator<IClass> iterator = this.objects.iterator();
        block5: while (iterator.hasNext()) {
            int[] objectIds;
            int[] nArray = objectIds = (int[])iterator.next();
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                int objectId = nArray[n2];
                if (listener.isCanceled()) break block5;
                CollectionUtil.Info info = (CollectionUtil.Info)metadata.get(this.snapshot.getClassOf(objectId).getObjectId());
                if (info != null) {
                    IObject obj = this.snapshot.getObject(objectId);
                    try {
                        double fillRatio = CollectionFillRatioQuery.getFillRatio(info, obj);
                        quantize.addValue(obj.getObjectId(), new Object[]{fillRatio, 1, obj.getUsedHeapSize()});
                    }
                    catch (SnapshotException e) {
                        listener.sendUserMessage(IProgressListener.Severity.INFO, MessageUtil.format((String)Messages.CollectionFillRatioQuery_IgnoringCollection, (Object[])new Object[]{obj.getTechnicalName()}), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        return quantize.getResult();
    }

    private static double getFillRatio(CollectionUtil.Info info, IObject hashtableObject) throws SnapshotException {
        int size = info.getSize(hashtableObject);
        int capacity = info.getCapacity(hashtableObject);
        if (capacity == 0) {
            return 1.0;
        }
        return (double)size / (double)capacity;
    }
}

